/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.model;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.ExtensiblePolymorphicDomainObjectContainer;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.Named;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.NamedDomainObjectList;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.artifacts.ExternalModuleDependencyBundle;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.collections.DomainObjectCollectionFactory;
import org.gradle.api.internal.file.DefaultSourceDirectorySet;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FilePropertyFactory;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.api.internal.provider.PropertyFactory;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.reflect.ObjectInstantiationException;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Cast;
import org.gradle.internal.Factory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.reflect.JavaReflectionUtil;

public class DefaultObjectFactory
implements ObjectFactory {
    private final Instantiator instantiator;
    private final NamedObjectInstantiator namedObjectInstantiator;
    private final DirectoryFileTreeFactory directoryFileTreeFactory;
    private final Factory<PatternSet> patternSetFactory;
    private final PropertyFactory propertyFactory;
    private final FilePropertyFactory filePropertyFactory;
    private final TaskDependencyFactory taskDependencyFactory;
    private final FileCollectionFactory fileCollectionFactory;
    private final DomainObjectCollectionFactory domainObjectCollectionFactory;

    public DefaultObjectFactory(Instantiator instantiator2, NamedObjectInstantiator namedObjectInstantiator, DirectoryFileTreeFactory directoryFileTreeFactory, Factory<PatternSet> patternSetFactory, PropertyFactory propertyFactory, FilePropertyFactory filePropertyFactory, TaskDependencyFactory taskDependencyFactory, FileCollectionFactory fileCollectionFactory, DomainObjectCollectionFactory domainObjectCollectionFactory) {
        this.instantiator = instantiator2;
        this.namedObjectInstantiator = namedObjectInstantiator;
        this.directoryFileTreeFactory = directoryFileTreeFactory;
        this.patternSetFactory = patternSetFactory;
        this.propertyFactory = propertyFactory;
        this.filePropertyFactory = filePropertyFactory;
        this.taskDependencyFactory = taskDependencyFactory;
        this.fileCollectionFactory = fileCollectionFactory;
        this.domainObjectCollectionFactory = domainObjectCollectionFactory;
    }

    @Override
    public <T extends Named> T named(Class<T> type, String name) {
        return this.namedObjectInstantiator.named(type, name);
    }

    @Override
    public <T> T newInstance(Class<? extends T> type, Object ... parameters) throws ObjectInstantiationException {
        return this.instantiator.newInstance(type, parameters);
    }

    @Override
    public ConfigurableFileCollection fileCollection() {
        return this.fileCollectionFactory.configurableFiles();
    }

    @Override
    public ConfigurableFileTree fileTree() {
        return this.fileCollectionFactory.fileTree();
    }

    @Override
    public SourceDirectorySet sourceDirectorySet(String name, String displayName) {
        return this.newInstance(DefaultSourceDirectorySet.class, name, displayName, this.patternSetFactory, this.taskDependencyFactory, this.fileCollectionFactory, this.directoryFileTreeFactory, this);
    }

    @Override
    public DirectoryProperty directoryProperty() {
        return this.filePropertyFactory.newDirectoryProperty();
    }

    @Override
    public RegularFileProperty fileProperty() {
        return this.filePropertyFactory.newFileProperty();
    }

    @Override
    public <T> NamedDomainObjectContainer<T> domainObjectContainer(Class<T> elementType) {
        return this.domainObjectCollectionFactory.newNamedDomainObjectContainer(elementType);
    }

    @Override
    public <T> NamedDomainObjectContainer<T> domainObjectContainer(Class<T> elementType, NamedDomainObjectFactory<T> factory) {
        return this.domainObjectCollectionFactory.newNamedDomainObjectContainer(elementType, factory);
    }

    @Override
    public <T> ExtensiblePolymorphicDomainObjectContainer<T> polymorphicDomainObjectContainer(Class<T> elementType) {
        return this.domainObjectCollectionFactory.newPolymorphicDomainObjectContainer(elementType);
    }

    @Override
    public <T> NamedDomainObjectSet<T> namedDomainObjectSet(Class<T> elementType) {
        return this.domainObjectCollectionFactory.newNamedDomainObjectSet(elementType);
    }

    @Override
    public <T> NamedDomainObjectList<T> namedDomainObjectList(Class<T> elementType) {
        return this.domainObjectCollectionFactory.newNamedDomainObjectList(elementType);
    }

    @Override
    public <T> DomainObjectSet<T> domainObjectSet(Class<T> elementType) {
        return this.domainObjectCollectionFactory.newDomainObjectSet(elementType);
    }

    @Override
    public <T> Property<T> property(Class<T> valueType) {
        if (valueType == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        if (valueType.isPrimitive()) {
            return (Property)Cast.uncheckedNonnullCast(this.property(JavaReflectionUtil.getWrapperTypeForPrimitiveType(valueType)));
        }
        if (List.class.isAssignableFrom(valueType)) {
            if (!ExternalModuleDependencyBundle.class.isAssignableFrom(valueType)) {
                throw new InvalidUserCodeException(this.invalidPropertyCreationError("listProperty()", "List<T>"));
            }
        } else {
            if (Set.class.isAssignableFrom(valueType)) {
                throw new InvalidUserCodeException(this.invalidPropertyCreationError("setProperty()", "Set<T>"));
            }
            if (Map.class.isAssignableFrom(valueType)) {
                throw new InvalidUserCodeException(this.invalidPropertyCreationError("mapProperty()", "Map<K, V>"));
            }
            if (Directory.class.isAssignableFrom(valueType)) {
                throw new InvalidUserCodeException(this.invalidPropertyCreationError("directoryProperty()", "Directory"));
            }
            if (RegularFile.class.isAssignableFrom(valueType)) {
                throw new InvalidUserCodeException(this.invalidPropertyCreationError("fileProperty()", "RegularFile"));
            }
        }
        return this.propertyFactory.property(valueType);
    }

    private String invalidPropertyCreationError(String correctMethodName, String propertyType) {
        return "Please use the ObjectFactory." + correctMethodName + " method to create a property of type " + propertyType + ".";
    }

    @Override
    public <T> ListProperty<T> listProperty(Class<T> elementType) {
        if (elementType.isPrimitive()) {
            return (ListProperty)Cast.uncheckedNonnullCast(this.listProperty(JavaReflectionUtil.getWrapperTypeForPrimitiveType(elementType)));
        }
        return this.propertyFactory.listProperty(elementType);
    }

    @Override
    public <T> SetProperty<T> setProperty(Class<T> elementType) {
        if (elementType.isPrimitive()) {
            return (SetProperty)Cast.uncheckedNonnullCast(this.setProperty(JavaReflectionUtil.getWrapperTypeForPrimitiveType(elementType)));
        }
        return this.propertyFactory.setProperty(elementType);
    }

    @Override
    public <K, V> MapProperty<K, V> mapProperty(Class<K> keyType, Class<V> valueType) {
        if (keyType.isPrimitive()) {
            return (MapProperty)Cast.uncheckedNonnullCast(this.mapProperty(JavaReflectionUtil.getWrapperTypeForPrimitiveType(keyType), valueType));
        }
        if (valueType.isPrimitive()) {
            return (MapProperty)Cast.uncheckedNonnullCast(this.mapProperty(keyType, JavaReflectionUtil.getWrapperTypeForPrimitiveType(valueType)));
        }
        return this.propertyFactory.mapProperty(keyType, valueType);
    }
}

