/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import groovy.lang.Closure;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.gradle.api.Describable;
import org.gradle.api.NonNullApi;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.FilePropertyContainer;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.TaskOutputsEnterpriseInternal;
import org.gradle.api.internal.file.CompositeFileCollection;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.tasks.DefaultTaskOutputFilePropertyRegistration;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.internal.tasks.TaskMutator;
import org.gradle.api.internal.tasks.TaskOutputFilePropertyRegistration;
import org.gradle.api.internal.tasks.TaskPropertyUtils;
import org.gradle.api.internal.tasks.execution.SelfDescribingSpec;
import org.gradle.api.internal.tasks.properties.OutputFilePropertySpec;
import org.gradle.api.internal.tasks.properties.OutputFilesCollector;
import org.gradle.api.internal.tasks.properties.OutputUnpacker;
import org.gradle.api.specs.AndSpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskOutputFilePropertyBuilder;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedSet;
import org.gradle.internal.properties.OutputFilePropertyType;
import org.gradle.internal.properties.PropertyValue;
import org.gradle.internal.properties.PropertyVisitor;
import org.gradle.internal.properties.StaticValue;
import org.gradle.internal.properties.bean.PropertyWalker;

@NonNullApi
public class DefaultTaskOutputs
implements TaskOutputsEnterpriseInternal {
    private final FileCollection allOutputFiles;
    private final PropertyWalker propertyWalker;
    private final FileCollectionFactory fileCollectionFactory;
    private AndSpec<TaskInternal> upToDateSpec = AndSpec.empty();
    private boolean storeInCache = true;
    private final List<SelfDescribingSpec<TaskInternal>> cacheIfSpecs = new LinkedList<SelfDescribingSpec<TaskInternal>>();
    private final List<SelfDescribingSpec<TaskInternal>> doNotCacheIfSpecs = new LinkedList<SelfDescribingSpec<TaskInternal>>();
    private FileCollection previousOutputFiles;
    private final FilePropertyContainer<TaskOutputFilePropertyRegistration> registeredFileProperties = FilePropertyContainer.create();
    private final TaskInternal task;
    private final TaskMutator taskMutator;

    public DefaultTaskOutputs(TaskInternal task, TaskMutator taskMutator, PropertyWalker propertyWalker, TaskDependencyFactory taskDependencyFactory, FileCollectionFactory fileCollectionFactory) {
        this.task = task;
        this.taskMutator = taskMutator;
        this.allOutputFiles = new TaskOutputUnionFileCollection(taskDependencyFactory, task);
        this.propertyWalker = propertyWalker;
        this.fileCollectionFactory = fileCollectionFactory;
    }

    @Override
    public void visitRegisteredProperties(PropertyVisitor visitor) {
        for (TaskOutputFilePropertyRegistration registration : this.registeredFileProperties) {
            visitor.visitOutputFileProperty(registration.getPropertyName(), registration.isOptional(), registration.getValue(), registration.getPropertyType());
        }
    }

    @Override
    public AndSpec<? super TaskInternal> getUpToDateSpec() {
        return this.upToDateSpec;
    }

    @Override
    public void upToDateWhen(Closure upToDateClosure) {
        this.taskMutator.mutate("TaskOutputs.upToDateWhen(Closure)", () -> {
            this.upToDateSpec = this.upToDateSpec.and(upToDateClosure);
        });
    }

    @Override
    public void upToDateWhen(Spec<? super Task> spec) {
        this.taskMutator.mutate("TaskOutputs.upToDateWhen(Spec)", () -> {
            this.upToDateSpec = this.upToDateSpec.and((Spec<TaskInternal>)spec);
        });
    }

    @Override
    public boolean getStoreInCache() {
        return this.storeInCache;
    }

    @Override
    public void doNotStoreInCache() {
        this.storeInCache = false;
    }

    @Override
    public void cacheIf(Spec<? super Task> spec) {
        this.cacheIf("Task outputs cacheable", spec);
    }

    @Override
    public void cacheIf(String cachingEnabledReason, Spec<? super Task> spec) {
        this.taskMutator.mutate("TaskOutputs.cacheIf(Spec)", () -> this.cacheIfSpecs.add(new SelfDescribingSpec(spec, cachingEnabledReason)));
    }

    @Override
    public void doNotCacheIf(String cachingDisabledReason, Spec<? super Task> spec) {
        this.taskMutator.mutate("TaskOutputs.doNotCacheIf(Spec)", () -> this.doNotCacheIfSpecs.add(new SelfDescribingSpec(spec, cachingDisabledReason)));
    }

    @Override
    public List<SelfDescribingSpec<TaskInternal>> getCacheIfSpecs() {
        return this.cacheIfSpecs;
    }

    @Override
    public List<SelfDescribingSpec<TaskInternal>> getDoNotCacheIfSpecs() {
        return this.doNotCacheIfSpecs;
    }

    @Override
    public boolean getHasOutput() {
        if (!this.upToDateSpec.isEmpty()) {
            return true;
        }
        HasDeclaredOutputsVisitor visitor = new HasDeclaredOutputsVisitor();
        TaskPropertyUtils.visitProperties(this.propertyWalker, this.task, visitor);
        return visitor.hasDeclaredOutputs();
    }

    @Override
    public FileCollection getFiles() {
        return this.allOutputFiles;
    }

    public ImmutableSortedSet<OutputFilePropertySpec> getFileProperties() {
        OutputFilesCollector collector = new OutputFilesCollector();
        TaskPropertyUtils.visitProperties(this.propertyWalker, this.task, new OutputUnpacker(this.task.toString(), this.fileCollectionFactory, false, false, collector));
        return collector.getFileProperties();
    }

    @Override
    public TaskOutputFilePropertyBuilder file(Object path) {
        return this.taskMutator.mutate("TaskOutputs.file(Object)", () -> {
            StaticValue value = new StaticValue(path);
            value.attachProducer(this.task);
            DefaultTaskOutputFilePropertyRegistration registration = new DefaultTaskOutputFilePropertyRegistration(value, OutputFilePropertyType.FILE);
            this.registeredFileProperties.add(registration);
            return registration;
        });
    }

    @Override
    public TaskOutputFilePropertyBuilder dir(Object path) {
        return this.taskMutator.mutate("TaskOutputs.dir(Object)", () -> {
            StaticValue value = new StaticValue(path);
            value.attachProducer(this.task);
            DefaultTaskOutputFilePropertyRegistration registration = new DefaultTaskOutputFilePropertyRegistration(value, OutputFilePropertyType.DIRECTORY);
            this.registeredFileProperties.add(registration);
            return registration;
        });
    }

    @Override
    public TaskOutputFilePropertyBuilder files(Object ... paths) {
        return this.taskMutator.mutate("TaskOutputs.files(Object...)", () -> {
            StaticValue value = new StaticValue(DefaultTaskOutputs.resolveSingleArray(paths));
            DefaultTaskOutputFilePropertyRegistration registration = new DefaultTaskOutputFilePropertyRegistration(value, OutputFilePropertyType.FILES);
            this.registeredFileProperties.add(registration);
            return registration;
        });
    }

    @Override
    public TaskOutputFilePropertyBuilder dirs(Object ... paths) {
        return this.taskMutator.mutate("TaskOutputs.dirs(Object...)", () -> {
            StaticValue value = new StaticValue(DefaultTaskOutputs.resolveSingleArray(paths));
            DefaultTaskOutputFilePropertyRegistration registration = new DefaultTaskOutputFilePropertyRegistration(value, OutputFilePropertyType.DIRECTORIES);
            this.registeredFileProperties.add(registration);
            return registration;
        });
    }

    @Nullable
    private static Object resolveSingleArray(@Nullable Object[] paths) {
        return paths != null && paths.length == 1 ? paths[0] : paths;
    }

    @Override
    public void setPreviousOutputFiles(FileCollection previousOutputFiles) {
        this.previousOutputFiles = previousOutputFiles;
    }

    @Override
    public Set<File> getPreviousOutputFiles() {
        if (this.previousOutputFiles == null) {
            throw new IllegalStateException("Task history is currently not available for this task.");
        }
        return this.previousOutputFiles.getFiles();
    }

    private class TaskOutputUnionFileCollection
    extends CompositeFileCollection
    implements Describable {
        private final TaskInternal buildDependencies;

        public TaskOutputUnionFileCollection(TaskDependencyFactory taskDependencyFactory, TaskInternal buildDependencies) {
            super(taskDependencyFactory);
            this.buildDependencies = buildDependencies;
        }

        @Override
        public String getDisplayName() {
            return "task '" + DefaultTaskOutputs.this.task.getName() + "' output files";
        }

        @Override
        protected void visitChildren(Consumer<FileCollectionInternal> visitor) {
            for (OutputFilePropertySpec propertySpec : DefaultTaskOutputs.this.getFileProperties()) {
                visitor.accept(propertySpec.getPropertyFiles());
            }
        }

        @Override
        public void visitDependencies(TaskDependencyResolveContext context) {
            context.add(this.buildDependencies);
            super.visitDependencies(context);
        }
    }

    private static class HasDeclaredOutputsVisitor
    implements PropertyVisitor {
        boolean hasDeclaredOutputs;

        private HasDeclaredOutputsVisitor() {
        }

        @Override
        public void visitOutputFileProperty(String propertyName, boolean optional, PropertyValue value, OutputFilePropertyType filePropertyType) {
            this.hasDeclaredOutputs = true;
        }

        public boolean hasDeclaredOutputs() {
            return this.hasDeclaredOutputs;
        }
    }
}

