/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import java.util.ArrayList;
import javax.annotation.Nullable;
import org.gradle.api.internal.tasks.TaskExecutionOutcome;
import org.gradle.api.tasks.TaskExecutionException;
import org.gradle.api.tasks.TaskState;
import org.gradle.util.internal.CollectionUtils;

public class TaskStateInternal
implements TaskState {
    private boolean executing;
    private boolean actionable = true;
    private boolean didWork;
    private RuntimeException failure;
    private TaskExecutionOutcome outcome;
    @Nullable
    private String skipReasonMessage;

    @Override
    public boolean getDidWork() {
        return this.didWork;
    }

    public void setDidWork(boolean didWork) {
        this.didWork = didWork;
    }

    @Override
    public boolean getExecuted() {
        return this.outcome != null;
    }

    public boolean isConfigurable() {
        return !this.getExecuted() && !this.executing;
    }

    @Nullable
    public TaskExecutionOutcome getOutcome() {
        return this.outcome;
    }

    public void setOutcome(TaskExecutionOutcome outcome) {
        assert (this.outcome == null);
        this.outcome = outcome;
    }

    @Nullable
    public String getSkipReasonMessage() {
        return this.skipReasonMessage;
    }

    public void setSkipReasonMessage(@Nullable String skipReasonMessage) {
        this.skipReasonMessage = skipReasonMessage;
    }

    public void setOutcome(RuntimeException failure) {
        assert (this.failure == null);
        this.outcome = TaskExecutionOutcome.EXECUTED;
        this.failure = failure;
    }

    public void addFailure(TaskExecutionException failure) {
        if (this.failure == null) {
            this.failure = failure;
        } else if (this.failure instanceof TaskExecutionException) {
            TaskExecutionException taskExecutionException = (TaskExecutionException)this.failure;
            ArrayList<? extends Throwable> causes = new ArrayList<Throwable>(taskExecutionException.getCauses());
            CollectionUtils.addAll(causes, failure.getCauses());
            taskExecutionException.initCauses(causes);
        } else {
            ArrayList<? extends Throwable> causes = new ArrayList<Throwable>();
            causes.add(this.failure);
            causes.addAll(failure.getCauses());
            failure.initCauses(causes);
            this.failure = failure;
        }
    }

    public boolean getExecuting() {
        return this.executing;
    }

    public void setExecuting(boolean executing) {
        this.executing = executing;
    }

    @Override
    public Throwable getFailure() {
        return this.failure;
    }

    @Override
    public void rethrowFailure() {
        if (this.failure != null) {
            throw this.failure;
        }
    }

    @Override
    public boolean getSkipped() {
        return this.outcome != null && this.outcome.isSkipped();
    }

    @Override
    public String getSkipMessage() {
        return this.outcome != null ? this.outcome.getMessage() : null;
    }

    @Override
    public boolean getUpToDate() {
        return this.outcome != null && this.outcome.isUpToDate();
    }

    @Override
    public boolean getNoSource() {
        return this.outcome == TaskExecutionOutcome.NO_SOURCE;
    }

    public boolean isFromCache() {
        return this.outcome == TaskExecutionOutcome.FROM_CACHE;
    }

    public boolean isActionable() {
        return this.actionable;
    }

    public void setActionable(boolean actionable) {
        this.actionable = actionable;
    }
}

