/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.internal.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.Named;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.component.ComponentWithCoordinates;
import org.gradle.api.component.ComponentWithVariants;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.component.SoftwareComponentVariant;
import org.gradle.api.internal.artifacts.DefaultExcludeRule;
import org.gradle.api.internal.artifacts.ImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.PublishArtifactInternal;
import org.gradle.api.internal.artifacts.dependencies.DefaultImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.dependencies.DefaultProjectDependencyConstraint;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectDependencyPublicationResolver;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.component.SoftwareComponentInternal;
import org.gradle.api.publish.internal.PublicationInternal;
import org.gradle.api.publish.internal.metadata.ComponentData;
import org.gradle.api.publish.internal.metadata.DependencyAttributesValidator;
import org.gradle.api.publish.internal.metadata.InvalidPublicationChecker;
import org.gradle.api.publish.internal.metadata.ModuleMetadataSpec;
import org.gradle.api.publish.internal.versionmapping.VariantVersionMappingStrategyInternal;
import org.gradle.api.publish.internal.versionmapping.VersionMappingStrategyInternal;
import org.gradle.internal.impldep.com.google.common.base.Strings;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;

class ModuleMetadataSpecBuilder {
    private final PublicationInternal<?> publication;
    private final ModuleVersionIdentifier publicationCoordinates;
    private final SoftwareComponentInternal component;
    private final Collection<? extends PublicationInternal<?>> publications;
    private final Map<SoftwareComponent, ComponentData> componentCoordinates = new HashMap<SoftwareComponent, ComponentData>();
    private final ProjectDependencyPublicationResolver projectDependencyResolver;
    private final InvalidPublicationChecker checker;
    private final List<DependencyAttributesValidator> dependencyAttributeValidators;

    public ModuleMetadataSpecBuilder(PublicationInternal<?> publication, Collection<? extends PublicationInternal<?>> publications, InvalidPublicationChecker checker, ProjectDependencyPublicationResolver projectDependencyResolver, List<DependencyAttributesValidator> dependencyAttributeValidators) {
        this.component = publication.getComponent();
        this.publicationCoordinates = publication.getCoordinates();
        this.publication = publication;
        this.publications = publications;
        this.checker = checker;
        this.projectDependencyResolver = projectDependencyResolver;
        this.dependencyAttributeValidators = dependencyAttributeValidators;
        this.collectCoordinates(this.componentCoordinates);
    }

    ModuleMetadataSpec build() {
        return new ModuleMetadataSpec(this.identity(), this.variants(), this.publication.isPublishBuildId());
    }

    private ModuleMetadataSpec.Identity identity() {
        HashMap<SoftwareComponent, SoftwareComponent> owners = new HashMap<SoftwareComponent, SoftwareComponent>();
        this.collectOwners(this.publications, owners);
        SoftwareComponent owner = (SoftwareComponent)owners.get(this.component);
        ComponentData ownerData = owner == null ? null : this.componentCoordinates.get(owner);
        ComponentData componentData = new ComponentData(this.publication.getCoordinates(), this.publication.getAttributes());
        return ownerData != null ? this.identityFor(ownerData, ModuleMetadataSpecBuilder.relativeUrlTo(componentData.coordinates, ownerData.coordinates)) : this.identityFor(componentData, null);
    }

    private ModuleMetadataSpec.Identity identityFor(ComponentData componentData, String relativeUrl) {
        return new ModuleMetadataSpec.Identity(componentData.coordinates, this.attributesFor(componentData.attributes), relativeUrl);
    }

    private List<ModuleMetadataSpec.Variant> variants() {
        ArrayList<ModuleMetadataSpec.Variant> variants = new ArrayList<ModuleMetadataSpec.Variant>();
        for (SoftwareComponentVariant softwareComponentVariant : this.component.getUsages()) {
            this.checkVariant(softwareComponentVariant);
            variants.add(new ModuleMetadataSpec.LocalVariant(softwareComponentVariant.getName(), this.attributesFor(softwareComponentVariant.getAttributes()), this.capabilitiesFor(softwareComponentVariant.getCapabilities()), this.dependenciesOf(softwareComponentVariant), this.dependencyConstraintsFor(softwareComponentVariant), this.artifactsOf(softwareComponentVariant)));
        }
        if (this.component instanceof ComponentWithVariants) {
            for (SoftwareComponent softwareComponent : ((ComponentWithVariants)((Object)this.component)).getVariants()) {
                ModuleVersionIdentifier childCoordinates = this.coordinatesOf(softwareComponent);
                assert (childCoordinates != null);
                if (!(softwareComponent instanceof SoftwareComponentInternal)) continue;
                for (SoftwareComponentVariant softwareComponentVariant : ((SoftwareComponentInternal)softwareComponent).getUsages()) {
                    this.checkVariant(softwareComponentVariant);
                    variants.add(new ModuleMetadataSpec.RemoteVariant(softwareComponentVariant.getName(), this.attributesFor(softwareComponentVariant.getAttributes()), this.availableAt(this.publicationCoordinates, childCoordinates), this.capabilitiesFor(softwareComponentVariant.getCapabilities())));
                }
            }
        }
        return variants;
    }

    private List<ModuleMetadataSpec.Artifact> artifactsOf(SoftwareComponentVariant variant) {
        if (variant.getArtifacts().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ModuleMetadataSpec.Artifact> artifacts2 = new ArrayList<ModuleMetadataSpec.Artifact>();
        for (PublishArtifact publishArtifact : variant.getArtifacts()) {
            ModuleMetadataSpec.Artifact metadataArtifact = this.artifactFor(publishArtifact);
            if (metadataArtifact == null) continue;
            artifacts2.add(metadataArtifact);
        }
        return artifacts2;
    }

    @Nullable
    private ModuleMetadataSpec.Artifact artifactFor(PublishArtifact artifact) {
        if (this.shouldNotBePublished(artifact)) {
            return null;
        }
        PublicationInternal.PublishedFile publishedFile = this.publication.getPublishedFile(artifact);
        return new ModuleMetadataSpec.Artifact(publishedFile.getName(), publishedFile.getUri(), artifact.getFile());
    }

    private boolean shouldNotBePublished(PublishArtifact artifact) {
        return !PublishArtifactInternal.shouldBePublished(artifact);
    }

    private ModuleMetadataSpec.AvailableAt availableAt(ModuleVersionIdentifier coordinates, ModuleVersionIdentifier targetCoordinates) {
        if (coordinates.getModule().equals(targetCoordinates.getModule())) {
            throw new InvalidUserCodeException("Cannot have a remote variant with coordinates '" + targetCoordinates.getModule() + "' that are the same as the module itself.");
        }
        return new ModuleMetadataSpec.AvailableAt(ModuleMetadataSpecBuilder.relativeUrlTo(coordinates, targetCoordinates), targetCoordinates);
    }

    private ModuleMetadataSpec.Dependency dependencyFor(ModuleDependency dependency, Set<ExcludeRule> additionalExcludes, VariantVersionMappingStrategyInternal versionMappingStrategy, DependencyArtifact dependencyArtifact, String variant) {
        return new ModuleMetadataSpec.Dependency(this.dependencyCoordinatesFor(dependency, versionMappingStrategy), this.excludedRulesFor(dependency, additionalExcludes), this.dependencyAttributesFor(variant, dependency.getGroup(), dependency.getName(), dependency.getAttributes()), this.capabilitiesFor(dependency.getRequestedCapabilities()), dependency.isEndorsingStrictVersions(), StringUtils.isNotEmpty((String)dependency.getReason()) ? dependency.getReason() : null, dependencyArtifact != null ? this.artifactSelectorFor(dependencyArtifact) : null);
    }

    private ModuleMetadataSpec.DependencyCoordinates dependencyCoordinatesFor(ModuleDependency dependency, VariantVersionMappingStrategyInternal versionMappingStrategy) {
        return dependency instanceof ProjectDependency ? this.projectDependencyCoordinatesFor((ProjectDependency)dependency, versionMappingStrategy) : this.moduleDependencyCoordinatesFor(dependency, versionMappingStrategy);
    }

    private ModuleMetadataSpec.ArtifactSelector artifactSelectorFor(DependencyArtifact dependencyArtifact) {
        return new ModuleMetadataSpec.ArtifactSelector(dependencyArtifact.getName(), dependencyArtifact.getType(), Strings.isNullOrEmpty((String)dependencyArtifact.getExtension()) ? null : dependencyArtifact.getExtension(), Strings.isNullOrEmpty((String)dependencyArtifact.getClassifier()) ? null : dependencyArtifact.getClassifier());
    }

    private List<ModuleMetadataSpec.Capability> capabilitiesFor(Collection<? extends Capability> capabilities) {
        if (capabilities.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ModuleMetadataSpec.Capability> metadataCapabilities = new ArrayList<ModuleMetadataSpec.Capability>();
        for (Capability capability : capabilities) {
            metadataCapabilities.add(new ModuleMetadataSpec.Capability(capability.getGroup(), capability.getName(), StringUtils.isNotEmpty((String)capability.getVersion()) ? capability.getVersion() : null));
        }
        return metadataCapabilities;
    }

    private List<ModuleMetadataSpec.Attribute> attributesFor(AttributeContainer attributes) {
        if (attributes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ModuleMetadataSpec.Attribute> metadataAttributes = new ArrayList<ModuleMetadataSpec.Attribute>();
        for (Attribute<?> attribute : this.sorted(attributes).values()) {
            String name = attribute.getName();
            Object value = attributes.getAttribute(attribute);
            Object effectiveValue = this.attributeValueFor(value);
            if (effectiveValue == null) {
                throw new IllegalArgumentException(String.format("Cannot write attribute %s with unsupported value %s of type %s.", name, value, value.getClass().getName()));
            }
            metadataAttributes.add(new ModuleMetadataSpec.Attribute(name, effectiveValue));
        }
        return metadataAttributes;
    }

    private List<ModuleMetadataSpec.Attribute> dependencyAttributesFor(String variant, String group, String name, AttributeContainer attributes) {
        for (DependencyAttributesValidator validator : this.dependencyAttributeValidators) {
            Optional<String> error = validator.validationErrorFor(group, name, attributes);
            error.ifPresent(s -> this.checker.addDependencyValidationError(variant, (String)s, validator.getExplanation(), validator.getSuppressor()));
        }
        return this.attributesFor(attributes);
    }

    private Object attributeValueFor(Object value) {
        if (value instanceof Boolean || value instanceof Integer || value instanceof String) {
            return value;
        }
        if (value instanceof Named) {
            return ((Named)value).getName();
        }
        if (value instanceof Enum) {
            return ((Enum)value).name();
        }
        return null;
    }

    private ModuleMetadataSpec.DependencyCoordinates moduleDependencyCoordinatesFor(ModuleDependency dependency, VariantVersionMappingStrategyInternal versionMappingStrategy) {
        ModuleVersionIdentifier resolvedVersionId;
        String group = dependency.getGroup();
        String name = dependency.getName();
        String resolvedVersion = null;
        if (versionMappingStrategy != null && (resolvedVersionId = versionMappingStrategy.maybeResolveVersion(group, name, null)) != null) {
            group = resolvedVersionId.getGroup();
            name = resolvedVersionId.getName();
            resolvedVersion = resolvedVersionId.getVersion();
        }
        return new ModuleMetadataSpec.DependencyCoordinates(group, name, this.versionFor(this.versionConstraintFor(dependency), resolvedVersion));
    }

    private ModuleMetadataSpec.DependencyCoordinates projectDependencyCoordinatesFor(ProjectDependency projectDependency, VariantVersionMappingStrategyInternal versionMappingStrategy) {
        ModuleVersionIdentifier resolved;
        String resolvedVersion = null;
        ModuleVersionIdentifier identifier = this.moduleIdentifierFor(projectDependency);
        if (versionMappingStrategy != null && (resolved = versionMappingStrategy.maybeResolveVersion(identifier.getGroup(), identifier.getName(), projectDependency.getDependencyProject().getPath())) != null) {
            identifier = resolved;
            resolvedVersion = identifier.getVersion();
        }
        return new ModuleMetadataSpec.DependencyCoordinates(identifier.getGroup(), identifier.getName(), this.versionFor(DefaultImmutableVersionConstraint.of(identifier.getVersion()), resolvedVersion));
    }

    private List<ModuleMetadataSpec.Dependency> dependenciesOf(SoftwareComponentVariant variant) {
        if (variant.getDependencies().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ModuleMetadataSpec.Dependency> dependencies = new ArrayList<ModuleMetadataSpec.Dependency>();
        Set<ExcludeRule> additionalExcludes = variant.getGlobalExcludes();
        VariantVersionMappingStrategyInternal versionMappingStrategy = this.versionMappingStrategyFor(variant);
        for (ModuleDependency moduleDependency : variant.getDependencies()) {
            if (moduleDependency.getArtifacts().isEmpty()) {
                dependencies.add(this.dependencyFor(moduleDependency, additionalExcludes, versionMappingStrategy, null, variant.getName()));
                continue;
            }
            for (DependencyArtifact dependencyArtifact : moduleDependency.getArtifacts()) {
                dependencies.add(this.dependencyFor(moduleDependency, additionalExcludes, versionMappingStrategy, dependencyArtifact, variant.getName()));
            }
        }
        return dependencies;
    }

    private List<ModuleMetadataSpec.DependencyConstraint> dependencyConstraintsFor(SoftwareComponentVariant variant) {
        if (variant.getDependencyConstraints().isEmpty()) {
            return Collections.emptyList();
        }
        VariantVersionMappingStrategyInternal versionMappingStrategy = this.versionMappingStrategyFor(variant);
        ArrayList<ModuleMetadataSpec.DependencyConstraint> dependencyConstraints = new ArrayList<ModuleMetadataSpec.DependencyConstraint>();
        for (DependencyConstraint dependencyConstraint : variant.getDependencyConstraints()) {
            dependencyConstraints.add(this.dependencyConstraintFor(dependencyConstraint, versionMappingStrategy, variant.getName()));
        }
        return dependencyConstraints;
    }

    private ModuleMetadataSpec.DependencyConstraint dependencyConstraintFor(DependencyConstraint dependencyConstraint, VariantVersionMappingStrategyInternal variantVersionMappingStrategy, String variant) {
        String module;
        String group;
        String resolvedVersion = null;
        String projectPath = null;
        if (dependencyConstraint instanceof DefaultProjectDependencyConstraint) {
            DefaultProjectDependencyConstraint dependency = (DefaultProjectDependencyConstraint)dependencyConstraint;
            ProjectDependency projectDependency = dependency.getProjectDependency();
            ModuleVersionIdentifier identifier = this.moduleIdentifierFor(projectDependency);
            group = identifier.getGroup();
            module = identifier.getName();
            projectPath = projectDependency.getDependencyProject().getPath();
            resolvedVersion = identifier.getVersion();
        } else {
            group = dependencyConstraint.getGroup();
            module = dependencyConstraint.getName();
        }
        ModuleVersionIdentifier resolvedVersionId = variantVersionMappingStrategy != null ? variantVersionMappingStrategy.maybeResolveVersion(group, module, projectPath) : null;
        String effectiveGroup = resolvedVersionId != null ? resolvedVersionId.getGroup() : group;
        String effectiveModule = resolvedVersionId != null ? resolvedVersionId.getName() : module;
        String effectiveVersion = resolvedVersionId != null ? resolvedVersionId.getVersion() : resolvedVersion;
        return new ModuleMetadataSpec.DependencyConstraint(effectiveGroup, effectiveModule, this.versionFor(DefaultImmutableVersionConstraint.of(dependencyConstraint.getVersionConstraint()), effectiveVersion), this.dependencyAttributesFor(variant, dependencyConstraint.getGroup(), dependencyConstraint.getName(), dependencyConstraint.getAttributes()), StringUtils.isNotEmpty((String)dependencyConstraint.getReason()) ? dependencyConstraint.getReason() : null);
    }

    @Nullable
    private ModuleMetadataSpec.Version versionFor(ImmutableVersionConstraint versionConstraint, @Nullable String resolvedVersion) {
        String preferred;
        String version;
        boolean isStrict;
        this.checker.sawDependencyOrConstraint();
        if (resolvedVersion == null && this.isEmpty(versionConstraint)) {
            return null;
        }
        this.checker.sawVersion();
        boolean bl = isStrict = !versionConstraint.getStrictVersion().isEmpty();
        if (resolvedVersion != null) {
            version = resolvedVersion;
            preferred = null;
        } else {
            version = isStrict ? versionConstraint.getStrictVersion() : (!versionConstraint.getRequiredVersion().isEmpty() ? versionConstraint.getRequiredVersion() : null);
            preferred = !versionConstraint.getPreferredVersion().isEmpty() ? versionConstraint.getPreferredVersion() : null;
        }
        return new ModuleMetadataSpec.Version(version, isStrict ? version : null, preferred, versionConstraint.getRejectedVersions());
    }

    private void collectOwners(Collection<? extends PublicationInternal<?>> publications, Map<SoftwareComponent, SoftwareComponent> owners) {
        for (PublicationInternal<?> publication : publications) {
            if (!(publication.getComponent() instanceof ComponentWithVariants)) continue;
            ComponentWithVariants componentWithVariants = (ComponentWithVariants)((Object)publication.getComponent());
            for (SoftwareComponent softwareComponent : componentWithVariants.getVariants()) {
                owners.put(softwareComponent, publication.getComponent());
            }
        }
    }

    private void collectCoordinates(Map<SoftwareComponent, ComponentData> coordinates) {
        for (PublicationInternal<?> publication : this.publications) {
            SoftwareComponentInternal component = publication.getComponent();
            if (component == null) continue;
            coordinates.put(component, new ComponentData(publication.getCoordinates(), publication.getAttributes()));
        }
    }

    private void checkVariant(SoftwareComponentVariant variant) {
        this.checker.registerVariant(variant.getName(), variant.getAttributes(), variant.getCapabilities());
    }

    private ImmutableVersionConstraint versionConstraintFor(ModuleDependency dependency) {
        return dependency instanceof ExternalDependency ? DefaultImmutableVersionConstraint.of(((ExternalDependency)dependency).getVersionConstraint()) : DefaultImmutableVersionConstraint.of(Strings.nullToEmpty((String)dependency.getVersion()));
    }

    private Set<ExcludeRule> excludedRulesFor(ModuleDependency moduleDependency, Set<ExcludeRule> additionalExcludes) {
        return moduleDependency.isTransitive() ? Sets.union(additionalExcludes, moduleDependency.getExcludeRules()) : Collections.singleton(new DefaultExcludeRule(null, null));
    }

    private Map<String, Attribute<?>> sorted(AttributeContainer attributes) {
        TreeMap sortedAttributes = new TreeMap();
        for (Attribute<?> attribute : attributes.keySet()) {
            sortedAttributes.put(attribute.getName(), attribute);
        }
        return sortedAttributes;
    }

    private ModuleVersionIdentifier coordinatesOf(SoftwareComponent childComponent) {
        if (childComponent instanceof ComponentWithCoordinates) {
            return ((ComponentWithCoordinates)childComponent).getCoordinates();
        }
        ComponentData componentData = this.componentCoordinates.get(childComponent);
        if (componentData != null) {
            return componentData.coordinates;
        }
        return null;
    }

    private ModuleVersionIdentifier moduleIdentifierFor(ProjectDependency projectDependency) {
        return this.projectDependencyResolver.resolve(ModuleVersionIdentifier.class, projectDependency);
    }

    private VariantVersionMappingStrategyInternal versionMappingStrategyFor(SoftwareComponentVariant variant) {
        VersionMappingStrategyInternal versionMappingStrategy = this.publication.getVersionMappingStrategy();
        return versionMappingStrategy != null ? versionMappingStrategy.findStrategyForVariant(this.immutableAttributesOf(variant)) : null;
    }

    private ImmutableAttributes immutableAttributesOf(SoftwareComponentVariant variant) {
        return ((AttributeContainerInternal)variant.getAttributes()).asImmutable();
    }

    private boolean isEmpty(ImmutableVersionConstraint versionConstraint) {
        return DefaultImmutableVersionConstraint.of().equals(versionConstraint);
    }

    public static String relativeUrlTo(ModuleVersionIdentifier from, ModuleVersionIdentifier to) {
        StringBuilder path = new StringBuilder();
        path.append("../../");
        path.append(to.getName());
        path.append("/");
        path.append(to.getVersion());
        path.append("/");
        path.append(to.getName());
        path.append("-");
        path.append(to.getVersion());
        path.append(".module");
        return path.toString();
    }
}

