/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.services.internal;

import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.DefaultProperty;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.services.internal.BuildServiceDetails;
import org.gradle.api.services.internal.BuildServiceRegistryInternal;
import org.gradle.internal.Cast;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.state.Managed;

public abstract class BuildServiceProvider<T extends BuildService<P>, P extends BuildServiceParameters>
extends AbstractMinimalProvider<T>
implements Managed {
    static <T> Class<T> getProvidedType(Provider<T> provider) {
        return ((ProviderInternal)provider).getType();
    }

    static BuildServiceProvider<?, ?> asBuildServiceProvider(Provider<? extends BuildService<?>> service) {
        if (service instanceof BuildServiceProvider) {
            return (BuildServiceProvider)Cast.uncheckedCast(service);
        }
        throw new UnsupportedOperationException("Unexpected provider for a build service: " + service);
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    @Override
    public Object unpackState() {
        throw new UnsupportedOperationException("Build services cannot be serialized.");
    }

    @Override
    public ValueSupplier.ExecutionTimeValue<? extends T> calculateExecutionTimeValue() {
        return ValueSupplier.ExecutionTimeValue.changingValue(this);
    }

    public void maybeStop() {
    }

    public static <P extends BuildServiceParameters, T extends BuildService<P>> void setBuildServiceAsConvention(@Nonnull DefaultProperty<T> property2, ServiceLookup serviceLookup, String buildServiceName) {
        BuildServiceRegistryInternal buildServiceRegistry = (BuildServiceRegistryInternal)serviceLookup.get((Type)((Object)BuildServiceRegistry.class));
        BuildServiceProvider consumer = (BuildServiceProvider)Cast.uncheckedCast(buildServiceRegistry.consume(buildServiceName, property2.getType()));
        property2.convention(consumer);
    }

    public abstract BuildServiceDetails<T, P> getServiceDetails();

    public abstract String getName();

    @Override
    @Nonnull
    public abstract Class<T> getType();

    public abstract BuildIdentifier getBuildIdentifier();

    public static boolean isSameService(Provider<? extends BuildService<?>> thisProvider, Provider<? extends BuildService<?>> anotherProvider) {
        if (thisProvider == anotherProvider) {
            return true;
        }
        if (!(thisProvider instanceof BuildServiceProvider) || !(anotherProvider instanceof BuildServiceProvider)) {
            return false;
        }
        BuildServiceProvider thisBuildServiceProvider = (BuildServiceProvider)thisProvider;
        BuildServiceProvider otherBuildServiceProvider = (BuildServiceProvider)anotherProvider;
        String thisName = thisBuildServiceProvider.getName();
        String otherName = otherBuildServiceProvider.getName();
        if (!(thisName.isEmpty() || otherName.isEmpty() || thisName.equals(otherName))) {
            return false;
        }
        if (!BuildServiceProvider.isCompatibleServiceType(thisBuildServiceProvider, otherBuildServiceProvider)) {
            return false;
        }
        return thisBuildServiceProvider.getBuildIdentifier().equals(otherBuildServiceProvider.getBuildIdentifier());
    }

    private static boolean isCompatibleServiceType(BuildServiceProvider thisBuildServiceProvider, BuildServiceProvider otherBuildServiceProvider) {
        Class otherType = otherBuildServiceProvider.getType();
        Class thisType = thisBuildServiceProvider.getType();
        return otherType.isAssignableFrom((Class)Cast.uncheckedCast(thisType));
    }

    public static interface Listener {
        public static final Listener EMPTY = provider -> {};

        public void beforeGet(BuildServiceProvider<?, ?> var1);
    }
}

