/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.CommandLineArgumentProvider;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.gradle.process.ProcessForkOptions;
import org.gradle.process.internal.DefaultExecSpec;
import org.gradle.process.internal.ExecAction;
import org.gradle.process.internal.ExecActionFactory;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Abstract super-class, not to be instantiated directly")
public abstract class AbstractExecTask<T extends AbstractExecTask>
extends ConventionTask
implements ExecSpec {
    private final Class<T> taskType;
    private final Property<ExecResult> execResult;
    private final DefaultExecSpec execSpec = this.getObjectFactory().newInstance(DefaultExecSpec.class, new Object[0]);

    public AbstractExecTask(Class<T> taskType) {
        this.execResult = this.getObjectFactory().property(ExecResult.class);
        this.taskType = taskType;
    }

    @Inject
    protected ObjectFactory getObjectFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ExecActionFactory getExecActionFactory() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    protected void exec() {
        ExecAction execAction = this.getExecActionFactory().newExecAction();
        this.execSpec.copyTo(execAction);
        this.execResult.set(execAction.execute());
    }

    public T commandLine(Object ... arguments) {
        this.execSpec.commandLine(arguments);
        return (T)((AbstractExecTask)this.taskType.cast(this));
    }

    public T commandLine(Iterable<?> args) {
        this.execSpec.commandLine(args);
        return (T)((AbstractExecTask)this.taskType.cast(this));
    }

    public T args(Object ... args) {
        this.execSpec.args(args);
        return (T)((AbstractExecTask)this.taskType.cast(this));
    }

    public T args(Iterable<?> args) {
        this.execSpec.args(args);
        return (T)((AbstractExecTask)this.taskType.cast(this));
    }

    public T setArgs(List<String> arguments) {
        this.execSpec.setArgs(arguments);
        return (T)((AbstractExecTask)this.taskType.cast(this));
    }

    public T setArgs(@Nullable Iterable<?> arguments) {
        this.execSpec.setArgs(arguments);
        return (T)((AbstractExecTask)this.taskType.cast(this));
    }

    @Override
    @Nullable
    @Optional
    @Input
    public List<String> getArgs() {
        return this.execSpec.getArgs();
    }

    @Override
    @Nested
    public List<CommandLineArgumentProvider> getArgumentProviders() {
        return this.execSpec.getArgumentProviders();
    }

    @Override
    @Internal
    public List<String> getCommandLine() {
        return this.execSpec.getCommandLine();
    }

    @Override
    public void setCommandLine(List<String> args) {
        this.execSpec.setCommandLine(args);
    }

    @Override
    public void setCommandLine(Iterable<?> args) {
        this.execSpec.setCommandLine(args);
    }

    @Override
    public void setCommandLine(Object ... args) {
        this.execSpec.setCommandLine(args);
    }

    @Override
    @Nullable
    @Optional
    @Input
    public String getExecutable() {
        return this.execSpec.getExecutable();
    }

    @Override
    public void setExecutable(@Nullable String executable) {
        this.execSpec.setExecutable(executable);
    }

    @Override
    public void setExecutable(Object executable) {
        this.execSpec.setExecutable(executable);
    }

    public T executable(Object executable) {
        this.execSpec.executable(executable);
        return (T)((AbstractExecTask)this.taskType.cast(this));
    }

    @Override
    @Internal
    public File getWorkingDir() {
        return this.execSpec.getWorkingDir();
    }

    @Override
    public void setWorkingDir(File dir) {
        this.execSpec.setWorkingDir(dir);
    }

    @Override
    public void setWorkingDir(Object dir) {
        this.execSpec.setWorkingDir(dir);
    }

    public T workingDir(Object dir) {
        this.execSpec.workingDir(dir);
        return (T)((AbstractExecTask)this.taskType.cast(this));
    }

    @Override
    @Internal
    public Map<String, Object> getEnvironment() {
        return this.execSpec.getEnvironment();
    }

    @Override
    public void setEnvironment(Map<String, ?> environmentVariables) {
        this.execSpec.setEnvironment(environmentVariables);
    }

    public T environment(String name, Object value) {
        this.execSpec.environment(name, value);
        return (T)((AbstractExecTask)this.taskType.cast(this));
    }

    public T environment(Map<String, ?> environmentVariables) {
        this.execSpec.environment(environmentVariables);
        return (T)((AbstractExecTask)this.taskType.cast(this));
    }

    public T copyTo(ProcessForkOptions target) {
        this.execSpec.copyTo(target);
        return (T)((AbstractExecTask)this.taskType.cast(this));
    }

    public T setStandardInput(InputStream inputStream) {
        this.execSpec.setStandardInput(inputStream);
        return (T)((AbstractExecTask)this.taskType.cast(this));
    }

    @Override
    @Internal
    public InputStream getStandardInput() {
        return this.execSpec.getStandardInput();
    }

    public T setStandardOutput(OutputStream outputStream) {
        this.execSpec.setStandardOutput(outputStream);
        return (T)((AbstractExecTask)this.taskType.cast(this));
    }

    @Override
    @Internal
    public OutputStream getStandardOutput() {
        return this.execSpec.getStandardOutput();
    }

    public T setErrorOutput(OutputStream outputStream) {
        this.execSpec.setErrorOutput(outputStream);
        return (T)((AbstractExecTask)this.taskType.cast(this));
    }

    @Override
    @Internal
    public OutputStream getErrorOutput() {
        return this.execSpec.getErrorOutput();
    }

    public T setIgnoreExitValue(boolean ignoreExitValue) {
        this.execSpec.setIgnoreExitValue(ignoreExitValue);
        return (T)((AbstractExecTask)this.taskType.cast(this));
    }

    @Override
    @Input
    public boolean isIgnoreExitValue() {
        return this.execSpec.isIgnoreExitValue();
    }

    @Internal
    public Provider<ExecResult> getExecutionResult() {
        return this.execResult;
    }
}

