/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal;

import javax.annotation.Nullable;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.UnresolvableConfigurationResult;
import org.gradle.internal.deprecation.DeprecatableConfiguration;

public class ConfigurationDetails {
    private final String name;
    @Nullable
    private final String description;
    private final boolean canBeResolved;
    @Nullable
    private final Provider<ResolvedComponentResult> resolutionResultRoot;
    @Nullable
    private final UnresolvableConfigurationResult unresolvableResult;

    public static ConfigurationDetails of(Configuration configuration) {
        boolean canBeResolved = ConfigurationDetails.canBeResolved(configuration);
        return new ConfigurationDetails(configuration.getName(), configuration.getDescription(), canBeResolved, canBeResolved ? configuration.getIncoming().getResolutionResult().getRootComponent() : null, canBeResolved ? null : UnresolvableConfigurationResult.of(configuration));
    }

    private static boolean canBeResolved(Configuration configuration) {
        boolean isDeprecatedForResolving = ((DeprecatableConfiguration)configuration).isDeprecatedForResolution();
        return configuration.isCanBeResolved() && !isDeprecatedForResolving;
    }

    private ConfigurationDetails(String name, @Nullable String description, boolean canBeResolved, @Nullable Provider<ResolvedComponentResult> resolutionResultRoot, @Nullable UnresolvableConfigurationResult unresolvableResult) {
        this.name = name;
        this.description = description;
        this.canBeResolved = canBeResolved;
        this.resolutionResultRoot = resolutionResultRoot;
        this.unresolvableResult = unresolvableResult;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public boolean isCanBeResolved() {
        return this.canBeResolved;
    }

    @Nullable
    public Provider<ResolvedComponentResult> getResolutionResultRoot() {
        return this.resolutionResultRoot;
    }

    @Nullable
    public UnresolvableConfigurationResult getUnresolvableResult() {
        return this.unresolvableResult;
    }
}

