/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import org.gradle.util.internal.TextUtil;

public class TemplateValue {
    private final String value;

    public TemplateValue(String value) {
        this.value = value;
    }

    public String getGroovyComment() {
        return this.value.replace("\\", "\\\\");
    }

    public String getGroovyString() {
        StringBuilder result2 = new StringBuilder();
        block9: for (int i = 0; i < this.value.length(); ++i) {
            char ch = this.value.charAt(i);
            switch (ch) {
                case '\\': {
                    result2.append('\\').append('\\');
                    continue block9;
                }
                case '\'': {
                    result2.append('\\').append('\'');
                    continue block9;
                }
                case '\n': {
                    result2.append('\\').append('n');
                    continue block9;
                }
                case '\r': {
                    result2.append('\\').append('r');
                    continue block9;
                }
                case '\t': {
                    result2.append('\\').append('t');
                    continue block9;
                }
                case '\f': {
                    result2.append('\\').append('f');
                    continue block9;
                }
                case '\b': {
                    result2.append('\\').append('b');
                    continue block9;
                }
                default: {
                    result2.append(ch);
                }
            }
        }
        return result2.toString();
    }

    public String getStatement() {
        if (this.value.isEmpty()) {
            return "";
        }
        return this.value + TextUtil.getPlatformLineSeparator();
    }

    public String getJavaStatement() {
        if (this.value.isEmpty()) {
            return "";
        }
        return this.value + ";" + TextUtil.getPlatformLineSeparator();
    }

    public String getJavaIdentifier() {
        return this.value;
    }

    public String getRaw() {
        return this.value;
    }

    public String toString() {
        return ">>>" + this.value + "<<<";
    }
}

