/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.controller.service;

import java.io.File;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.controller.service.BuildCacheLoadResult;
import org.gradle.caching.internal.controller.service.LocalBuildCacheServiceHandle;
import org.gradle.caching.local.internal.LocalBuildCacheService;

public class DefaultLocalBuildCacheServiceHandle
implements LocalBuildCacheServiceHandle {
    private final LocalBuildCacheService service;
    private final boolean pushEnabled;

    public DefaultLocalBuildCacheServiceHandle(LocalBuildCacheService service, boolean pushEnabled) {
        this.service = service;
        this.pushEnabled = pushEnabled;
    }

    @Override
    @Nullable
    public LocalBuildCacheService getService() {
        return this.service;
    }

    @Override
    public Optional<BuildCacheLoadResult> maybeLoad(BuildCacheKey key, Function<File, BuildCacheLoadResult> unpackFunction) {
        AtomicReference result2 = new AtomicReference(Optional.empty());
        this.service.loadLocally(key, file -> result2.set(Optional.ofNullable((BuildCacheLoadResult)unpackFunction.apply((File)file))));
        return result2.get();
    }

    @Override
    public boolean canStore() {
        return this.pushEnabled;
    }

    @Override
    public boolean maybeStore(BuildCacheKey key, File file) {
        if (this.canStore()) {
            this.service.storeLocally(key, file);
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        this.service.close();
    }
}

