/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.util.ArrayList;
import java.util.Set;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.initialization.ScriptClassPathInitializer;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskDependencyUtil;
import org.gradle.composite.internal.BuildTreeWorkGraphController;
import org.gradle.composite.internal.TaskIdentifier;
import org.gradle.internal.build.BuildState;

public class CompositeBuildClassPathInitializer
implements ScriptClassPathInitializer {
    private final BuildTreeWorkGraphController buildTreeWorkGraphController;
    private final BuildState currentBuild;

    public CompositeBuildClassPathInitializer(BuildTreeWorkGraphController buildTreeWorkGraphController, BuildState currentBuild) {
        this.buildTreeWorkGraphController = buildTreeWorkGraphController;
        this.currentBuild = currentBuild;
    }

    @Override
    public void execute(Configuration classpath) {
        ArrayList<TaskIdentifier.TaskBasedTaskIdentifier> tasksToBuild = new ArrayList<TaskIdentifier.TaskBasedTaskIdentifier>();
        Set<? extends Task> dependencies = TaskDependencyUtil.getDependenciesForInternalUse(classpath.getBuildDependencies(), null);
        for (Task task : dependencies) {
            BuildState targetBuild = ((ProjectInternal)task.getProject()).getOwner().getOwner();
            assert (targetBuild != this.currentBuild);
            tasksToBuild.add(TaskIdentifier.of(targetBuild.getBuildIdentifier(), (TaskInternal)task));
        }
        if (!tasksToBuild.isEmpty()) {
            this.buildTreeWorkGraphController.withNewWorkGraph(graph -> {
                graph.scheduleWork(builder -> builder.scheduleTasks(tasksToBuild)).runWork().rethrow();
                return null;
            });
        }
    }
}

