/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.ScriptHandlerInternal;
import org.gradle.api.internal.plugins.PluginManagerInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.configuration.CompileOperationFactory;
import org.gradle.configuration.DefaultScriptTarget;
import org.gradle.configuration.InitScriptTarget;
import org.gradle.configuration.InitialPassSettingScriptTarget;
import org.gradle.configuration.ProjectScriptTarget;
import org.gradle.configuration.ScriptPlugin;
import org.gradle.configuration.ScriptPluginFactory;
import org.gradle.configuration.ScriptTarget;
import org.gradle.configuration.SettingScriptTarget;
import org.gradle.groovy.scripts.BasicScript;
import org.gradle.groovy.scripts.ScriptCompiler;
import org.gradle.groovy.scripts.ScriptCompilerFactory;
import org.gradle.groovy.scripts.ScriptRunner;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.internal.BuildScriptData;
import org.gradle.groovy.scripts.internal.CompileOperation;
import org.gradle.internal.Actions;
import org.gradle.internal.Factory;
import org.gradle.internal.logging.LoggingManagerInternal;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.model.dsl.internal.transform.ClosureCreationInterceptingVerifier;
import org.gradle.plugin.management.internal.PluginRequests;
import org.gradle.plugin.management.internal.autoapply.AutoAppliedPluginHandler;
import org.gradle.plugin.use.internal.PluginRequestApplicator;
import org.gradle.plugin.use.internal.PluginsAwareScript;

public class DefaultScriptPluginFactory
implements ScriptPluginFactory {
    private final ServiceRegistry scriptServices;
    private final ScriptCompilerFactory scriptCompilerFactory;
    private final Factory<LoggingManagerInternal> loggingFactoryManager;
    private final AutoAppliedPluginHandler autoAppliedPluginHandler;
    private final PluginRequestApplicator pluginRequestApplicator;
    private final CompileOperationFactory compileOperationFactory;
    private ScriptPluginFactory scriptPluginFactory;

    public DefaultScriptPluginFactory(ServiceRegistry scriptServices, ScriptCompilerFactory scriptCompilerFactory, Factory<LoggingManagerInternal> loggingFactoryManager, AutoAppliedPluginHandler autoAppliedPluginHandler, PluginRequestApplicator pluginRequestApplicator, CompileOperationFactory compileOperationFactory) {
        this.scriptServices = scriptServices;
        this.scriptCompilerFactory = scriptCompilerFactory;
        this.loggingFactoryManager = loggingFactoryManager;
        this.autoAppliedPluginHandler = autoAppliedPluginHandler;
        this.pluginRequestApplicator = pluginRequestApplicator;
        this.compileOperationFactory = compileOperationFactory;
        this.scriptPluginFactory = this;
    }

    public void setScriptPluginFactory(ScriptPluginFactory scriptPluginFactory) {
        this.scriptPluginFactory = scriptPluginFactory;
    }

    @Override
    public ScriptPlugin create(ScriptSource scriptSource, ScriptHandler scriptHandler, ClassLoaderScope targetScope, ClassLoaderScope baseScope, boolean topLevelScript) {
        return new ScriptPluginImpl(scriptSource, (ScriptHandlerInternal)scriptHandler, targetScope, baseScope, topLevelScript);
    }

    private PluginRequests getInitialPluginRequests(ScriptRunner<? extends BasicScript, ?> initialRunner) {
        BasicScript script;
        if (initialRunner.getRunDoesSomething() && (script = initialRunner.getScript()) instanceof PluginsAwareScript) {
            return ((PluginsAwareScript)script).getPluginRequests();
        }
        return PluginRequests.EMPTY;
    }

    private class ScriptPluginImpl
    implements ScriptPlugin {
        private final ScriptSource scriptSource;
        private final ClassLoaderScope targetScope;
        private final ClassLoaderScope baseScope;
        private final ScriptHandlerInternal scriptHandler;
        private final boolean topLevelScript;

        public ScriptPluginImpl(ScriptSource scriptSource, ScriptHandlerInternal scriptHandler, ClassLoaderScope targetScope, ClassLoaderScope baseScope, boolean topLevelScript) {
            this.scriptSource = scriptSource;
            this.targetScope = targetScope;
            this.baseScope = baseScope;
            this.scriptHandler = scriptHandler;
            this.topLevelScript = topLevelScript;
        }

        @Override
        public ScriptSource getSource() {
            return this.scriptSource;
        }

        @Override
        public void apply(Object target) {
            DefaultServiceRegistry services = new DefaultServiceRegistry(DefaultScriptPluginFactory.this.scriptServices);
            services.add(ScriptPluginFactory.class, DefaultScriptPluginFactory.this.scriptPluginFactory);
            services.add(ClassLoaderScope.class, this.baseScope);
            services.add(LoggingManagerInternal.class, (LoggingManagerInternal)DefaultScriptPluginFactory.this.loggingFactoryManager.create());
            services.add(ScriptHandler.class, this.scriptHandler);
            ScriptTarget initialPassScriptTarget = this.initialPassTarget(target);
            ScriptCompiler compiler = DefaultScriptPluginFactory.this.scriptCompilerFactory.createCompiler(this.scriptSource);
            CompileOperation<?> initialOperation = DefaultScriptPluginFactory.this.compileOperationFactory.getPluginsBlockCompileOperation(initialPassScriptTarget);
            Class<? extends BasicScript> scriptType = initialPassScriptTarget.getScriptClass();
            ScriptRunner<BasicScript, ?> initialRunner = compiler.compile(scriptType, initialOperation, this.baseScope, Actions.doNothing());
            initialRunner.run(target, services);
            PluginRequests initialPluginRequests = DefaultScriptPluginFactory.this.getInitialPluginRequests(initialRunner);
            PluginRequests mergedPluginRequests = DefaultScriptPluginFactory.this.autoAppliedPluginHandler.mergeWithAutoAppliedPlugins(initialPluginRequests, target);
            PluginManagerInternal pluginManager = this.topLevelScript ? initialPassScriptTarget.getPluginManager() : null;
            DefaultScriptPluginFactory.this.pluginRequestApplicator.applyPlugins(mergedPluginRequests, this.scriptHandler, pluginManager, this.targetScope);
            ScriptTarget scriptTarget = this.secondPassTarget(target);
            scriptType = scriptTarget.getScriptClass();
            CompileOperation<BuildScriptData> operation = DefaultScriptPluginFactory.this.compileOperationFactory.getScriptCompileOperation(this.scriptSource, scriptTarget);
            ScriptRunner<? extends BasicScript, BuildScriptData> runner = compiler.compile(scriptType, operation, this.targetScope, ClosureCreationInterceptingVerifier.INSTANCE);
            if (scriptTarget.getSupportsMethodInheritance() && runner.getHasMethods()) {
                BasicScript script = runner.getScript();
                script.init(scriptTarget, DefaultScriptPluginFactory.this.scriptServices);
                scriptTarget.attachScript(script);
            }
            if (!runner.getRunDoesSomething()) {
                return;
            }
            Runnable buildScriptRunner = () -> runner.run(target, services);
            boolean hasImperativeStatements = runner.getData().getHasImperativeStatements();
            scriptTarget.addConfiguration(buildScriptRunner, !hasImperativeStatements);
        }

        private ScriptTarget initialPassTarget(Object target) {
            return this.wrap(target, true);
        }

        private ScriptTarget secondPassTarget(Object target) {
            return this.wrap(target, false);
        }

        private ScriptTarget wrap(Object target, boolean isInitialPass) {
            if (target instanceof ProjectInternal && this.topLevelScript) {
                return new ProjectScriptTarget((ProjectInternal)target);
            }
            if (target instanceof GradleInternal && this.topLevelScript) {
                return new InitScriptTarget((GradleInternal)target);
            }
            if (target instanceof SettingsInternal && this.topLevelScript) {
                if (isInitialPass) {
                    return new InitialPassSettingScriptTarget((SettingsInternal)target);
                }
                return new SettingScriptTarget((SettingsInternal)target);
            }
            return new DefaultScriptTarget(target);
        }
    }
}

