/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.gradle.api.NonNullApi;
import org.gradle.configuration.TaskDetails;
import org.gradle.internal.InternalTransformer;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.logging.text.LinePrefixingStyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.util.internal.CollectionUtils;
import org.gradle.util.internal.TextUtil;

@NonNullApi
public class TaskDetailPrinter {
    private final String taskPath;
    private final List<TaskDetails> tasks;
    private static final String INDENT = "     ";

    public TaskDetailPrinter(String taskPath, List<TaskDetails> tasks) {
        this.taskPath = taskPath;
        this.tasks = tasks;
    }

    public void print(StyledTextOutput output) {
        output.text("Detailed task information for ").withStyle(StyledTextOutput.Style.UserInput).println(this.taskPath);
        Map<String, List<TaskDetails>> detailsByTaskType = this.groupTasksByType(this.tasks);
        Set<String> typeNames = detailsByTaskType.keySet();
        boolean multipleTaskTypes = typeNames.size() > 1;
        List<String> sortedTaskTypes = CollectionUtils.sort(typeNames);
        for (String taskType : sortedTaskTypes) {
            output.println();
            List<TaskDetails> tasksByType = detailsByTaskType.get(taskType);
            TaskDetails anyTask = tasksByType.iterator().next();
            String shortTypeName = anyTask.getShortTypeName();
            LinePrefixingStyledTextOutput pathOutput = this.createIndentedOutput(output, INDENT);
            pathOutput.println("Path" + TextUtil.getPluralEnding(tasksByType));
            for (TaskDetails task : tasksByType) {
                pathOutput.withStyle(StyledTextOutput.Style.UserInput).println(task.getPath());
            }
            output.println();
            LinePrefixingStyledTextOutput typeOutput = this.createIndentedOutput(output, INDENT);
            typeOutput.println("Type");
            typeOutput.withStyle(StyledTextOutput.Style.UserInput).text(shortTypeName);
            typeOutput.println(" (" + taskType + ")");
            this.printlnCommandlineOptions(output, tasksByType);
            output.println();
            this.printTaskDescription(output, tasksByType);
            output.println();
            this.printTaskGroup(output, tasksByType);
            if (!multipleTaskTypes) continue;
            output.println();
            output.println("----------------------");
        }
    }

    private Map<String, List<TaskDetails>> groupTasksByType(Collection<TaskDetails> tasks) {
        return tasks.stream().collect(Collectors.groupingBy(TaskDetails::getTaskType, LinkedHashMap::new, Collectors.toList()));
    }

    private void printTaskDescription(StyledTextOutput output, List<TaskDetails> tasks) {
        this.printTaskAttribute(output, "Description", tasks, TaskDetails::getDescription);
    }

    private void printTaskGroup(StyledTextOutput output, List<TaskDetails> tasks) {
        this.printTaskAttribute(output, "Group", tasks, TaskDetails::getGroup);
    }

    private void printTaskAttribute(StyledTextOutput output, String attributeHeader, List<TaskDetails> tasks, InternalTransformer<String, TaskDetails> transformer) {
        int count = CollectionUtils.collect(tasks, new HashSet(), transformer).size();
        LinePrefixingStyledTextOutput attributeOutput = this.createIndentedOutput(output, INDENT);
        if (count == 1) {
            attributeOutput.println(attributeHeader);
            TaskDetails task = tasks.iterator().next();
            String value = transformer.transform(task);
            attributeOutput.println(value == null ? "-" : value);
        } else {
            attributeOutput.println(attributeHeader + "s");
            for (TaskDetails task : tasks) {
                attributeOutput.withStyle(StyledTextOutput.Style.UserInput).text("(" + task.getPath() + ") ");
                String value = transformer.transform(task);
                attributeOutput.println(value == null ? "-" : value);
            }
        }
    }

    private void printlnCommandlineOptions(StyledTextOutput output, List<TaskDetails> tasks) {
        ArrayList<TaskDetails.OptionDetails> allOptions = new ArrayList<TaskDetails.OptionDetails>();
        for (TaskDetails task : tasks) {
            allOptions.addAll(task.getOptions());
        }
        if (!allOptions.isEmpty()) {
            output.println();
            output.text("Options").println();
        }
        Map<String, Set<String>> optionToAvailableOptionsValues = this.optionToAvailableValues(allOptions);
        Map<String, String> optionToDescription = this.optionToDescription(allOptions);
        Iterator<String> optionNames = optionToAvailableOptionsValues.keySet().iterator();
        while (optionNames.hasNext()) {
            String currentOption = optionNames.next();
            Set<String> availableValues = optionToAvailableOptionsValues.get(currentOption);
            String optionString = "--" + currentOption;
            output.text(INDENT).withStyle(StyledTextOutput.Style.UserInput).text(optionString);
            output.text(INDENT).text(optionToDescription.get(currentOption));
            if (!availableValues.isEmpty()) {
                int optionDescriptionOffset = 2 * INDENT.length() + optionString.length();
                LinePrefixingStyledTextOutput prefixedOutput = this.createIndentedOutput(output, optionDescriptionOffset);
                prefixedOutput.println();
                prefixedOutput.println("Available values are:");
                for (String value : availableValues) {
                    prefixedOutput.text(INDENT);
                    prefixedOutput.withStyle(StyledTextOutput.Style.UserInput).println(value);
                }
            } else {
                output.println();
            }
            if (!optionNames.hasNext()) continue;
            output.println();
        }
    }

    private Map<String, Set<String>> optionToAvailableValues(List<TaskDetails.OptionDetails> allOptions) {
        LinkedHashMap<String, Set<String>> result2 = new LinkedHashMap<String, Set<String>>();
        for (TaskDetails.OptionDetails optionDescriptor : allOptions) {
            if (result2.containsKey(optionDescriptor.getName())) {
                Sets.SetView commonValues = Sets.intersection(optionDescriptor.getAvailableValues(), (Set)((Set)result2.get(optionDescriptor.getName())));
                result2.put(optionDescriptor.getName(), new TreeSet(commonValues));
                continue;
            }
            result2.put(optionDescriptor.getName(), optionDescriptor.getAvailableValues());
        }
        return result2;
    }

    private Map<String, String> optionToDescription(List<TaskDetails.OptionDetails> allOptions) {
        HashMap<String, String> result2 = new HashMap<String, String>();
        for (TaskDetails.OptionDetails optionDescriptor : allOptions) {
            result2.put(optionDescriptor.getName(), optionDescriptor.getDescription());
        }
        return result2;
    }

    private LinePrefixingStyledTextOutput createIndentedOutput(StyledTextOutput output, int offset) {
        return this.createIndentedOutput(output, StringUtils.leftPad((String)"", (int)offset, (char)' '));
    }

    private LinePrefixingStyledTextOutput createIndentedOutput(StyledTextOutput output, String prefix) {
        return new LinePrefixingStyledTextOutput(output, prefix, false);
    }
}

