/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration.project;

import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.configuration.ScriptPlugin;
import org.gradle.configuration.ScriptPluginFactory;
import org.gradle.configuration.project.ProjectConfigureAction;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildScriptProcessor
implements ProjectConfigureAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildScriptProcessor.class);
    private final ScriptPluginFactory configurerFactory;

    public BuildScriptProcessor(ScriptPluginFactory configurerFactory) {
        this.configurerFactory = configurerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ProjectInternal project) {
        ScriptSource scriptSource = project.getBuildScriptSource();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Evaluating {} using {}.", (Object)project, (Object)scriptSource.getDisplayName());
        }
        Timer clock = Time.startTimer();
        try {
            ScriptPlugin configurer = this.configurerFactory.create(scriptSource, project.getBuildscript(), project.getClassLoaderScope(), project.getBaseClassLoaderScope(), true);
            project.getOwner().applyToMutableState(configurer::apply);
        }
        finally {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Timing: Running the build script took {}", (Object)clock.getElapsed());
            }
        }
    }
}

