/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configurationcache.problems;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.configuration.internal.UserCodeApplicationContext;
import org.gradle.configurationcache.problems.DefaultProblemFactory;
import org.gradle.configurationcache.problems.DocumentationSection;
import org.gradle.configurationcache.problems.ProblemFactory;
import org.gradle.configurationcache.problems.PropertyProblem;
import org.gradle.configurationcache.problems.PropertyTrace;
import org.gradle.configurationcache.problems.StructuredMessage;
import org.gradle.internal.DisplayName;
import org.gradle.problems.Location;
import org.gradle.problems.buildtree.ProblemLocationAnalyzer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J$\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J!\u0010\r\u001a\u00020\u00132\u0017\u0010\u0014\u001a\u0013\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015\u00a2\u0006\u0002\b\u0018H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/gradle/configurationcache/problems/DefaultProblemFactory;", "Lorg/gradle/configurationcache/problems/ProblemFactory;", "userCodeContext", "Lorg/gradle/configuration/internal/UserCodeApplicationContext;", "locationAnalyzer", "Lorg/gradle/problems/buildtree/ProblemLocationAnalyzer;", "(Lorg/gradle/configuration/internal/UserCodeApplicationContext;Lorg/gradle/problems/buildtree/ProblemLocationAnalyzer;)V", "locationForCaller", "Lorg/gradle/configurationcache/problems/PropertyTrace;", "consumer", "", "exception", "", "problem", "Lorg/gradle/configurationcache/problems/PropertyProblem;", "message", "Lorg/gradle/configurationcache/problems/StructuredMessage;", "documentationSection", "Lorg/gradle/configurationcache/problems/DocumentationSection;", "Lorg/gradle/configurationcache/problems/ProblemFactory$Builder;", "messageBuilder", "Lkotlin/Function1;", "Lorg/gradle/configurationcache/problems/StructuredMessage$Builder;", "", "Lkotlin/ExtensionFunctionType;", "configuration-cache"})
public final class DefaultProblemFactory
implements ProblemFactory {
    @NotNull
    private final UserCodeApplicationContext userCodeContext;
    @NotNull
    private final ProblemLocationAnalyzer locationAnalyzer;

    public DefaultProblemFactory(@NotNull UserCodeApplicationContext userCodeContext, @NotNull ProblemLocationAnalyzer locationAnalyzer) {
        Intrinsics.checkNotNullParameter((Object)userCodeContext, (String)"userCodeContext");
        Intrinsics.checkNotNullParameter((Object)locationAnalyzer, (String)"locationAnalyzer");
        this.userCodeContext = userCodeContext;
        this.locationAnalyzer = locationAnalyzer;
    }

    @Override
    @NotNull
    public PropertyTrace locationForCaller(@Nullable String consumer) {
        PropertyTrace propertyTrace;
        UserCodeApplicationContext.Application currentApplication = this.userCodeContext.current();
        if (currentApplication != null) {
            DisplayName displayName = currentApplication.getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)displayName, (String)"currentApplication.displayName");
            propertyTrace = new PropertyTrace.BuildLogic(displayName, null);
        } else {
            propertyTrace = consumer != null ? (PropertyTrace)new PropertyTrace.BuildLogicClass(consumer) : (PropertyTrace)PropertyTrace.Unknown.INSTANCE;
        }
        return propertyTrace;
    }

    @Override
    @NotNull
    public PropertyProblem problem(@NotNull StructuredMessage message2, @Nullable Throwable exception, @Nullable DocumentationSection documentationSection) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        PropertyTrace trace = this.locationForCaller(exception);
        return new PropertyProblem(trace, message2, exception, documentationSection);
    }

    @Override
    @NotNull
    public ProblemFactory.Builder problem(@NotNull Function1<? super StructuredMessage.Builder, Unit> messageBuilder) {
        Intrinsics.checkNotNullParameter(messageBuilder, (String)"messageBuilder");
        StructuredMessage message2 = StructuredMessage.Companion.build(messageBuilder);
        return new ProblemFactory.Builder(message2, this){
            @Nullable
            private Throwable exception;
            @Nullable
            private DocumentationSection documentationSection;
            @NotNull
            private Function1<? super PropertyTrace, ? extends PropertyTrace> locationMapper;
            final /* synthetic */ StructuredMessage $message;
            final /* synthetic */ DefaultProblemFactory this$0;
            {
                this.$message = $message;
                this.this$0 = $receiver;
                this.locationMapper = problem.locationMapper.1.INSTANCE;
            }

            @Nullable
            public final Throwable getException() {
                return this.exception;
            }

            public final void setException(@Nullable Throwable throwable) {
                this.exception = throwable;
            }

            @Nullable
            public final DocumentationSection getDocumentationSection() {
                return this.documentationSection;
            }

            public final void setDocumentationSection(@Nullable DocumentationSection documentationSection) {
                this.documentationSection = documentationSection;
            }

            @NotNull
            public final Function1<PropertyTrace, PropertyTrace> getLocationMapper() {
                return this.locationMapper;
            }

            public final void setLocationMapper(@NotNull Function1<? super PropertyTrace, ? extends PropertyTrace> function1) {
                Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
                this.locationMapper = function1;
            }

            @NotNull
            public ProblemFactory.Builder exception(@NotNull String message2) {
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                this.exception = new InvalidUserCodeException(message2);
                return this;
            }

            @NotNull
            public ProblemFactory.Builder exception() {
                this.exception = new InvalidUserCodeException(this.$message.toString());
                return this;
            }

            @NotNull
            public ProblemFactory.Builder mapLocation(@NotNull Function1<? super PropertyTrace, ? extends PropertyTrace> mapper) {
                Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
                this.locationMapper = mapper;
                return this;
            }

            @NotNull
            public ProblemFactory.Builder documentationSection(@NotNull DocumentationSection documentationSection) {
                Intrinsics.checkNotNullParameter((Object)((Object)documentationSection), (String)"documentationSection");
                this.documentationSection = documentationSection;
                return this;
            }

            @NotNull
            public PropertyProblem build() {
                PropertyTrace location = (PropertyTrace)this.locationMapper.invoke((Object)DefaultProblemFactory.access$locationForCaller(this.this$0, this.exception));
                return new PropertyProblem(location, this.$message, this.exception, this.documentationSection);
            }
        };
    }

    private final PropertyTrace locationForCaller(Throwable exception) {
        if (exception != null) {
            StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"exception.stackTrace");
            Location location = this.locationAnalyzer.locationForUsage(ArraysKt.toList((Object[])stackTraceElementArray), false);
            if (location != null) {
                DisplayName displayName = location.getSourceShortDisplayName();
                Intrinsics.checkNotNullExpressionValue((Object)displayName, (String)"location.sourceShortDisplayName");
                return new PropertyTrace.BuildLogic(displayName, location.getLineNumber());
            }
        }
        return this.locationForCaller((String)null);
    }

    public static final /* synthetic */ PropertyTrace access$locationForCaller(DefaultProblemFactory $this, Throwable exception) {
        return $this.locationForCaller(exception);
    }
}

