/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configurationcache.serialization.codecs;

import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.configurations.ResolutionBackedFileCollection;
import org.gradle.api.internal.artifacts.transform.TransformedArtifactSet;
import org.gradle.api.internal.file.AbstractFileCollection;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.FilteredFileCollection;
import org.gradle.api.internal.file.SubtractingFileCollection;
import org.gradle.api.internal.file.collections.FailingFileCollection;
import org.gradle.api.internal.file.collections.ProviderBackedFileCollection;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.configurationcache.serialization.codecs.AbstractVisitor;
import org.gradle.configurationcache.serialization.codecs.BeanSpec;
import org.gradle.configurationcache.serialization.codecs.FilteredFileCollectionSpec;
import org.gradle.configurationcache.serialization.codecs.ProviderBackedFileCollectionSpec;
import org.gradle.configurationcache.serialization.codecs.ResolutionContentsCollectingVisitor;
import org.gradle.configurationcache.serialization.codecs.SubtractingFileCollectionSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001d\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lorg/gradle/configurationcache/serialization/codecs/CollectingVisitor;", "Lorg/gradle/configurationcache/serialization/codecs/AbstractVisitor;", "()V", "elements", "", "", "getElements", "()Ljava/util/Set;", "prepareForVisit", "Lorg/gradle/api/internal/file/FileCollectionStructureVisitor$VisitType;", "source", "Lorg/gradle/api/internal/file/FileCollectionInternal$Source;", "startVisit", "", "fileCollection", "Lorg/gradle/api/internal/file/FileCollectionInternal;", "visitCollection", "", "contents", "", "Ljava/io/File;", "configuration-cache"})
final class CollectingVisitor
extends AbstractVisitor {
    @NotNull
    private final Set<Object> elements = new LinkedHashSet();

    @NotNull
    public final Set<Object> getElements() {
        return this.elements;
    }

    @Override
    public boolean startVisit(@NotNull FileCollectionInternal.Source source, @NotNull FileCollectionInternal fileCollection) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)fileCollection, (String)"fileCollection");
        FileCollectionInternal fileCollectionInternal = fileCollection;
        if (fileCollectionInternal instanceof SubtractingFileCollection) {
            AbstractFileCollection abstractFileCollection = ((SubtractingFileCollection)fileCollection).getLeft();
            Intrinsics.checkNotNullExpressionValue((Object)abstractFileCollection, (String)"fileCollection.left");
            FileCollection fileCollection2 = abstractFileCollection;
            FileCollection fileCollection3 = ((SubtractingFileCollection)fileCollection).getRight();
            Intrinsics.checkNotNullExpressionValue((Object)fileCollection3, (String)"fileCollection.right");
            this.elements.add(new SubtractingFileCollectionSpec(fileCollection2, fileCollection3));
            bl = false;
        } else if (fileCollectionInternal instanceof FilteredFileCollection) {
            FileCollectionInternal fileCollectionInternal2 = ((FilteredFileCollection)fileCollection).getCollection();
            Intrinsics.checkNotNullExpressionValue((Object)fileCollectionInternal2, (String)"fileCollection.collection");
            FileCollection fileCollection4 = fileCollectionInternal2;
            Spec<? super File> spec = ((FilteredFileCollection)fileCollection).getFilterSpec();
            Intrinsics.checkNotNullExpressionValue(spec, (String)"fileCollection.filterSpec");
            this.elements.add(new FilteredFileCollectionSpec(fileCollection4, spec));
            bl = false;
        } else if (fileCollectionInternal instanceof ProviderBackedFileCollection) {
            ProviderInternal<?> providerInternal = ((ProviderBackedFileCollection)fileCollection).getProvider();
            Intrinsics.checkNotNullExpressionValue(providerInternal, (String)"fileCollection.provider");
            ProviderInternal<?> provider = providerInternal;
            if (!(provider instanceof TaskProvider)) {
                this.elements.add(new ProviderBackedFileCollectionSpec(provider));
                bl = false;
            } else {
                bl = true;
            }
        } else if (fileCollectionInternal instanceof FileTreeInternal) {
            this.elements.add(fileCollection);
            bl = false;
        } else if (fileCollectionInternal instanceof FailingFileCollection) {
            this.elements.add(new BeanSpec(fileCollection));
            bl = false;
        } else if (fileCollectionInternal instanceof ResolutionBackedFileCollection) {
            String string2 = ((ResolutionBackedFileCollection)fileCollection).getResolutionHost().getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"fileCollection.resolutionHost.displayName");
            String displayName = string2;
            boolean lenient = ((ResolutionBackedFileCollection)fileCollection).isLenient();
            ResolutionContentsCollectingVisitor nestedVisitor = new ResolutionContentsCollectingVisitor(displayName, lenient);
            fileCollection.visitStructure(nestedVisitor);
            nestedVisitor.addElements(this.elements);
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    @Override
    @NotNull
    public FileCollectionStructureVisitor.VisitType prepareForVisit(@NotNull FileCollectionInternal.Source source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (source instanceof TransformedArtifactSet) {
            throw new IllegalArgumentException("Found artifact set " + source + " but was not expecting an artifact set");
        }
        return FileCollectionStructureVisitor.VisitType.Visit;
    }

    public void visitCollection(@NotNull FileCollectionInternal.Source source, @NotNull Iterable<? extends File> contents) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(contents, (String)"contents");
        CollectionsKt.addAll((Collection)this.elements, contents);
    }
}

