/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import org.gradle.api.InvalidUserDataException;
import org.gradle.internal.exceptions.FailureResolutionAware;
import org.gradle.internal.logging.text.StyledTextOutput;

abstract class BaseSelectionException
extends InvalidUserDataException
implements FailureResolutionAware {
    private final String taskName;
    private final String targetName;

    public BaseSelectionException(String message2, String taskName, String targetName) {
        super(message2);
        this.taskName = taskName;
        this.targetName = targetName;
    }

    @Override
    public void appendResolutions(FailureResolutionAware.Context context) {
        context.appendResolution(output -> {
            output.text("Run ");
            context.getClientMetaData().describeCommand(output.withStyle(StyledTextOutput.Style.UserInput), this.taskName);
            output.text(" to get a list of available " + this.targetName + ".");
        });
        context.appendDocumentationResolution("on name expansion", "command_line_interface", "sec:name_abbreviation");
    }
}

