/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import org.gradle.StartParameter;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.initialization.EvaluateSettingsBuildOperationType;
import org.gradle.initialization.SettingsLocation;
import org.gradle.initialization.SettingsProcessor;
import org.gradle.initialization.SettingsState;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;

public class BuildOperationSettingsProcessor
implements SettingsProcessor {
    private static final EvaluateSettingsBuildOperationType.Result RESULT = new EvaluateSettingsBuildOperationType.Result(){};
    private final SettingsProcessor settingsProcessor;
    private final BuildOperationExecutor buildOperationExecutor;

    public BuildOperationSettingsProcessor(SettingsProcessor settingsProcessor, BuildOperationExecutor buildOperationExecutor) {
        this.settingsProcessor = settingsProcessor;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    @Override
    public SettingsState process(final GradleInternal gradle, final SettingsLocation settingsLocation, final ClassLoaderScope buildRootClassLoaderScope, final StartParameter startParameter) {
        return this.buildOperationExecutor.call(new CallableBuildOperation<SettingsState>(){

            @Override
            public SettingsState call(BuildOperationContext context) {
                SettingsState state = BuildOperationSettingsProcessor.this.settingsProcessor.process(gradle, settingsLocation, buildRootClassLoaderScope, startParameter);
                context.setResult(RESULT);
                return state;
            }

            @Override
            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName(gradle.contextualize("Evaluate settings")).progressDisplayName("Evaluating settings").details(new EvaluateSettingsBuildOperationType.Details(){

                    @Override
                    public String getBuildPath() {
                        return gradle.getIdentityPath().toString();
                    }

                    @Override
                    public String getSettingsDir() {
                        return settingsLocation.getSettingsDir().getAbsolutePath();
                    }

                    @Override
                    public String getSettingsFile() {
                        File settingsFile2 = settingsLocation.getSettingsFile();
                        return settingsFile2 != null ? settingsFile2.getPath() : null;
                    }
                });
            }
        });
    }
}

