/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildtree;

import java.util.Set;
import org.gradle.execution.selection.BuildTaskSelector;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.RootBuildState;
import org.gradle.internal.buildtree.BuildTreeWorkGraph;
import org.gradle.internal.buildtree.BuildTreeWorkGraphPreparer;

public class DefaultBuildTreeWorkGraphPreparer
implements BuildTreeWorkGraphPreparer {
    private final BuildTaskSelector taskSelector;
    private final BuildStateRegistry buildRegistry;

    public DefaultBuildTreeWorkGraphPreparer(BuildStateRegistry buildRegistry, BuildTaskSelector taskSelector) {
        this.buildRegistry = buildRegistry;
        this.taskSelector = taskSelector;
    }

    @Override
    public void prepareToScheduleTasks(BuildTreeWorkGraph.Builder workGraph) {
        RootBuildState targetBuild = this.buildRegistry.getRootBuild();
        Set<String> excludedTaskNames = targetBuild.getMutableModel().getStartParameter().getExcludedTaskNames();
        for (String taskName : excludedTaskNames) {
            BuildTaskSelector.Filter filter = this.taskSelector.resolveExcludedTaskName(targetBuild, taskName);
            workGraph.addFilter(filter.getBuild(), filter.getFilter());
        }
    }
}

