/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildtree;

import org.gradle.StartParameter;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.internal.buildtree.BuildActionRunner;
import org.gradle.internal.buildtree.BuildTreeActionExecutor;
import org.gradle.internal.buildtree.BuildTreeContext;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.featurelifecycle.LoggingDeprecatedFeatureHandler;
import org.gradle.internal.featurelifecycle.ScriptUsageLocationReporter;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.operations.BuildOperationProgressEventEmitter;

public class InitDeprecationLoggingActionExecutor
implements BuildTreeActionExecutor {
    private final BuildTreeActionExecutor delegate;
    private final ScriptUsageLocationReporter usageLocationReporter;
    private final BuildOperationProgressEventEmitter eventEmitter;
    private final StartParameter startParameter;

    public InitDeprecationLoggingActionExecutor(BuildTreeActionExecutor delegate, ScriptUsageLocationReporter usageLocationReporter, BuildOperationProgressEventEmitter eventEmitter, StartParameter startParameter) {
        this.delegate = delegate;
        this.usageLocationReporter = usageLocationReporter;
        this.eventEmitter = eventEmitter;
        this.startParameter = startParameter;
    }

    @Override
    public BuildActionRunner.Result execute(BuildAction action, BuildTreeContext buildTreeContext) {
        ShowStacktrace showStacktrace = this.startParameter.getShowStacktrace();
        switch (showStacktrace) {
            case ALWAYS: 
            case ALWAYS_FULL: {
                LoggingDeprecatedFeatureHandler.setTraceLoggingEnabled(true);
                break;
            }
            default: {
                LoggingDeprecatedFeatureHandler.setTraceLoggingEnabled(false);
            }
        }
        DeprecationLogger.init(this.usageLocationReporter, this.startParameter.getWarningMode(), this.eventEmitter);
        return this.delegate.execute(action, buildTreeContext);
    }
}

