/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath.declarations;

import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import org.gradle.internal.Cast;
import org.gradle.internal.classpath.Instrumented;
import org.gradle.internal.classpath.MethodHandleUtils;
import org.gradle.internal.classpath.declarations.Handles;
import org.gradle.internal.instrumentation.api.annotations.CallableKind;
import org.gradle.internal.instrumentation.api.annotations.InterceptCalls;
import org.gradle.internal.instrumentation.api.annotations.ParameterKind;
import org.gradle.internal.instrumentation.api.annotations.SpecificGroovyCallInterceptors;
import org.gradle.internal.instrumentation.api.annotations.SpecificJvmCallInterceptors;

@SpecificJvmCallInterceptors(generatedClassName="org.gradle.internal.classpath.InterceptorDeclaration_JvmBytecodeImpl")
@SpecificGroovyCallInterceptors(generatedClassName="org.gradle.internal.classpath.InterceptorDeclaration_GroovyInterceptorsImpl")
public class KotlinStdlibFileInterceptors {
    @InterceptCalls
    @CallableKind.StaticMethod(ofClass=FilesKt.class)
    public static byte[] intercept_readBytes(File self, @ParameterKind.CallerClassName String consumer) {
        Instrumented.fileOpened(self, consumer);
        return FilesKt.readBytes((File)self);
    }

    @InterceptCalls
    @CallableKind.StaticMethod(ofClass=FilesKt.class)
    public static void intercept_forEachBlock(File self, Function2<?, ?, ?> action, @ParameterKind.CallerClassName String consumer) {
        Instrumented.fileOpened(self, consumer);
        FilesKt.forEachBlock((File)self, (Function2)((Function2)Cast.uncheckedNonnullCast(action)));
    }

    @InterceptCalls
    @CallableKind.StaticMethod(ofClass=FilesKt.class)
    public static void intercept_forEachBlock(File self, int blockSize, Function2<?, ?, ?> action, @ParameterKind.CallerClassName String consumer) {
        Instrumented.fileOpened(self, consumer);
        FilesKt.forEachBlock((File)self, (int)blockSize, (Function2)((Function2)Cast.uncheckedNonnullCast(action)));
    }

    @InterceptCalls
    @CallableKind.StaticMethod(ofClass=FilesKt.class)
    public static void intercept_forEachLine(File self, Charset charset, Function1<?, ?> action, @ParameterKind.KotlinDefaultMask int mask, @ParameterKind.CallerClassName String consumer) throws Throwable {
        Instrumented.fileOpened(self, consumer);
        if (mask == 0) {
            FilesKt.forEachLine((File)self, (Charset)charset, (Function1)((Function1)Cast.uncheckedNonnullCast(action)));
        } else {
            MethodHandleUtils.invokeKotlinStaticDefault(Handles.FOR_EACH_LINE_DEFAULT, mask, self, charset, action);
        }
    }

    @InterceptCalls
    @CallableKind.StaticMethod(ofClass=FilesKt.class)
    public static List<String> intercept_readLines(File self, Charset charset, @ParameterKind.KotlinDefaultMask int mask, @ParameterKind.CallerClassName String consumer) throws Throwable {
        Instrumented.fileOpened(self, consumer);
        return mask == 0 ? FilesKt.readLines((File)self, (Charset)charset) : (List)MethodHandleUtils.invokeKotlinStaticDefault(Handles.READ_LINES_DEFAULT, mask, self, charset);
    }

    @InterceptCalls
    @CallableKind.StaticMethod(ofClass=FilesKt.class)
    public static Object intercept_useLines(File self, Charset charset, Function1<?, ?> block, @ParameterKind.KotlinDefaultMask int mask, @ParameterKind.CallerClassName String consumer) throws Throwable {
        Instrumented.fileOpened(self, consumer);
        return mask == 0 ? FilesKt.useLines((File)self, (Charset)charset, (Function1)((Function1)Cast.uncheckedNonnullCast(block))) : MethodHandleUtils.invokeKotlinStaticDefault(Handles.USE_LINES_DEFAULT, mask, self, charset, block);
    }
}

