/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.local.model;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.ConfigurationsProvider;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.LocalConfigurationMetadataBuilder;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.external.model.VirtualComponentIdentifier;
import org.gradle.internal.component.local.model.LocalComponentArtifactMetadata;
import org.gradle.internal.component.local.model.LocalComponentMetadata;
import org.gradle.internal.component.local.model.LocalConfigurationMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ImmutableModuleSources;
import org.gradle.internal.component.model.ModuleSources;
import org.gradle.internal.component.model.VariantGraphResolveMetadata;
import org.gradle.internal.impldep.com.google.common.base.Optional;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.model.ModelContainer;

public final class DefaultLocalComponentMetadata
implements LocalComponentMetadata {
    private static final ModuleSources MODULE_SOURCES = ImmutableModuleSources.of();
    private final ComponentIdentifier componentId;
    private final ModuleVersionIdentifier moduleVersionId;
    private final String status;
    private final AttributesSchemaInternal attributesSchema;
    private final ConfigurationMetadataFactory configurationFactory;
    private final Transformer<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata> artifactTransformer;
    private final Map<String, LocalConfigurationMetadata> allConfigurations = new LinkedHashMap<String, LocalConfigurationMetadata>();
    private Optional<List<? extends VariantGraphResolveMetadata>> consumableConfigurations;

    public DefaultLocalComponentMetadata(ModuleVersionIdentifier moduleVersionId, ComponentIdentifier componentId, String status, AttributesSchemaInternal attributesSchema, ConfigurationMetadataFactory configurationFactory, @Nullable Transformer<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata> artifactTransformer) {
        this.moduleVersionId = moduleVersionId;
        this.componentId = componentId;
        this.status = status;
        this.attributesSchema = attributesSchema;
        this.configurationFactory = configurationFactory;
        this.artifactTransformer = artifactTransformer;
    }

    @Override
    public ComponentIdentifier getId() {
        return this.componentId;
    }

    @Override
    public ModuleVersionIdentifier getModuleVersionId() {
        return this.moduleVersionId;
    }

    @Override
    public DefaultLocalComponentMetadata copy(ComponentIdentifier componentIdentifier, Transformer<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata> transformer) {
        HashMap transformedArtifacts = new HashMap();
        Transformer<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata> cachedTransformer = oldArtifact -> transformedArtifacts.computeIfAbsent(oldArtifact, transformer::transform);
        return new DefaultLocalComponentMetadata(this.moduleVersionId, componentIdentifier, this.status, this.attributesSchema, this.configurationFactory, cachedTransformer);
    }

    public String toString() {
        return this.componentId.getDisplayName();
    }

    @Override
    public ModuleSources getSources() {
        return MODULE_SOURCES;
    }

    @Override
    public ComponentResolveMetadata withSources(ModuleSources source) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isMissing() {
        return false;
    }

    @Override
    public boolean isChanging() {
        return false;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public List<String> getStatusScheme() {
        return DEFAULT_STATUS_SCHEME;
    }

    @Override
    public ImmutableList<? extends VirtualComponentIdentifier> getPlatformOwners() {
        return ImmutableList.of();
    }

    @Override
    public Set<String> getConfigurationNames() {
        return this.configurationFactory.getConfigurationNames();
    }

    @Override
    public synchronized Optional<List<? extends VariantGraphResolveMetadata>> getVariantsForGraphTraversal() {
        if (this.consumableConfigurations == null) {
            ImmutableList.Builder builder = new ImmutableList.Builder();
            for (String name : this.configurationFactory.getConfigurationNames()) {
                LocalConfigurationMetadata configuration;
                if (!this.configurationFactory.isConsumable(name) || (configuration = this.getConfiguration(name)).getAttributes().isEmpty()) continue;
                builder.add((Object)configuration);
            }
            ImmutableList variants = builder.build();
            this.consumableConfigurations = !variants.isEmpty() ? Optional.of((Object)variants) : Optional.absent();
        }
        return this.consumableConfigurations;
    }

    @Override
    public LocalConfigurationMetadata getConfiguration(String name) {
        LocalConfigurationMetadata md = this.allConfigurations.get(name);
        if (md == null) {
            md = this.configurationFactory.getConfiguration(name, this, this.artifactTransformer);
            this.allConfigurations.put(name, md);
        }
        return md;
    }

    @Override
    public AttributesSchemaInternal getAttributesSchema() {
        return this.attributesSchema;
    }

    @Override
    public ImmutableAttributes getAttributes() {
        return ImmutableAttributes.EMPTY;
    }

    @Override
    public void reevaluate() {
        this.allConfigurations.clear();
        this.configurationFactory.invalidate();
        this.consumableConfigurations = null;
    }

    @Override
    public boolean isConfigurationRealized(String configName) {
        return this.allConfigurations.get(configName) != null;
    }

    public static class ConfigurationsProviderMetadataFactory
    implements ConfigurationMetadataFactory {
        private final ConfigurationsProvider configurationsProvider;
        private final LocalConfigurationMetadataBuilder metadataBuilder;
        private final ModelContainer<?> model;
        private final CalculatedValueContainerFactory calculatedValueContainerFactory;
        private final LocalConfigurationMetadataBuilder.DependencyCache cache;

        public ConfigurationsProviderMetadataFactory(ConfigurationsProvider configurationsProvider, LocalConfigurationMetadataBuilder metadataBuilder, ModelContainer<?> model, CalculatedValueContainerFactory calculatedValueContainerFactory) {
            this.configurationsProvider = configurationsProvider;
            this.metadataBuilder = metadataBuilder;
            this.model = model;
            this.calculatedValueContainerFactory = calculatedValueContainerFactory;
            this.cache = new LocalConfigurationMetadataBuilder.DependencyCache();
        }

        @Override
        public Set<String> getConfigurationNames() {
            LinkedHashSet<String> names = new LinkedHashSet<String>();
            for (Configuration configuration : this.configurationsProvider.getAll()) {
                names.add(configuration.getName());
            }
            return names;
        }

        @Override
        public boolean isConsumable(String name) {
            return this.configurationsProvider.findByName(name).isCanBeConsumed();
        }

        @Override
        public void invalidate() {
            this.cache.invalidate();
        }

        @Override
        public LocalConfigurationMetadata getConfiguration(String name, DefaultLocalComponentMetadata parent, @Nullable Transformer<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata> artifactTransformer) {
            ConfigurationInternal configuration = this.configurationsProvider.findByName(name);
            if (configuration == null) {
                return null;
            }
            LocalConfigurationMetadata md = this.metadataBuilder.create(configuration, this.configurationsProvider, parent, this.cache, this.model, this.calculatedValueContainerFactory);
            return artifactTransformer != null ? md.copy(artifactTransformer) : md;
        }
    }

    public static class ConfigurationsMapMetadataFactory
    implements ConfigurationMetadataFactory {
        private final Map<String, LocalConfigurationMetadata> metadata;

        public ConfigurationsMapMetadataFactory(Map<String, LocalConfigurationMetadata> metadata) {
            this.metadata = metadata;
        }

        @Override
        public Set<String> getConfigurationNames() {
            return this.metadata.keySet();
        }

        @Override
        public boolean isConsumable(String name) {
            return this.metadata.get(name).isCanBeConsumed();
        }

        @Override
        public void invalidate() {
        }

        @Override
        public LocalConfigurationMetadata getConfiguration(String name, DefaultLocalComponentMetadata parent, @Nullable Transformer<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata> artifactTransformer) {
            if (artifactTransformer == null) {
                return this.metadata.get(name);
            }
            return this.metadata.get(name).copy(artifactTransformer);
        }
    }

    public static interface ConfigurationMetadataFactory {
        public Set<String> getConfigurationNames();

        public boolean isConsumable(String var1);

        public void invalidate();

        @Nullable
        public LocalConfigurationMetadata getConfiguration(String var1, DefaultLocalComponentMetadata var2, @Nullable Transformer<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata> var3);
    }
}

