/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.impl;

import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.internal.execution.WorkValidationContext;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedSet;
import org.gradle.internal.reflect.ProblemRecordingTypeValidationContext;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.internal.reflect.validation.TypeValidationProblem;

public class DefaultWorkValidationContext
implements WorkValidationContext {
    private final Set<Class<?>> types = new HashSet();
    private final ImmutableList.Builder<TypeValidationProblem> problems = ImmutableList.builder();
    private final DocumentationRegistry documentationRegistry;
    private final WorkValidationContext.TypeOriginInspector typeOriginInspector;

    public DefaultWorkValidationContext(DocumentationRegistry documentationRegistry, WorkValidationContext.TypeOriginInspector typeOriginInspector) {
        this.documentationRegistry = documentationRegistry;
        this.typeOriginInspector = typeOriginInspector;
    }

    @Override
    public TypeValidationContext forType(Class<?> type, final boolean cacheable) {
        this.types.add(type);
        Supplier<Optional> pluginId = () -> this.typeOriginInspector.findPluginDefining(type);
        return new ProblemRecordingTypeValidationContext(this.documentationRegistry, type, pluginId){

            @Override
            protected void recordProblem(TypeValidationProblem problem2) {
                boolean onlyAffectsCacheableWork = problem2.isOnlyAffectsCacheableWork();
                if (onlyAffectsCacheableWork && !cacheable) {
                    return;
                }
                DefaultWorkValidationContext.this.problems.add((Object)problem2);
            }
        };
    }

    @Override
    public List<TypeValidationProblem> getProblems() {
        return this.problems.build();
    }

    public ImmutableSortedSet<Class<?>> getValidatedTypes() {
        return ImmutableSortedSet.copyOf(Comparator.comparing(Class::getName), this.types);
    }
}

