/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.featurelifecycle;

import java.util.ArrayList;
import java.util.List;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;

public abstract class FeatureUsage {
    private final String summary;
    private final Class<?> calledFrom;
    private final Exception traceException;
    private List<StackTraceElement> stack;

    protected FeatureUsage(String summary, Class<?> calledFrom) {
        this(summary, calledFrom, new Exception());
    }

    @VisibleForTesting
    protected FeatureUsage(String summary, Class<?> calledFrom, Exception traceException) {
        this.summary = summary;
        this.calledFrom = calledFrom;
        this.traceException = traceException;
    }

    public String getSummary() {
        return this.summary;
    }

    protected Class<?> getCalledFrom() {
        return this.calledFrom;
    }

    public List<StackTraceElement> getStack() {
        if (this.stack == null) {
            this.stack = FeatureUsage.calculateStack(this.calledFrom, this.traceException);
        }
        return this.stack;
    }

    private static List<StackTraceElement> calculateStack(Class<?> calledFrom, Exception traceRoot) {
        int caller;
        StackTraceElement[] originalStack = traceRoot.getStackTrace();
        ArrayList<StackTraceElement> result2 = new ArrayList<StackTraceElement>();
        String calledFromName = calledFrom.getName();
        boolean calledFromFound = false;
        for (caller = 0; caller < originalStack.length; ++caller) {
            StackTraceElement current = originalStack[caller];
            if (!calledFromFound) {
                if (!current.getClassName().startsWith(calledFromName)) continue;
                calledFromFound = true;
                continue;
            }
            if (!current.getClassName().startsWith(calledFromName)) break;
        }
        while (caller < originalStack.length) {
            StackTraceElement stackTraceElement = originalStack[caller];
            if (!FeatureUsage.isSystemStackFrame(stackTraceElement.getClassName())) {
                result2.add(stackTraceElement);
            }
            ++caller;
        }
        return result2;
    }

    private static boolean isSystemStackFrame(String className) {
        return className.startsWith("jdk.internal.") || className.startsWith("sun.") || className.startsWith("com.sun.") || className.startsWith("org.codehaus.groovy.") || className.startsWith("org.gradle.internal.metaobject.") || className.startsWith("org.gradle.kotlin.dsl.execution.");
    }

    public String formattedMessage() {
        return this.summary;
    }
}

