/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.nativeintegration;

import java.lang.reflect.Field;
import java.util.Map;
import org.gradle.internal.nativeintegration.NativeIntegrationException;
import org.gradle.internal.os.OperatingSystem;

public class ReflectiveEnvironment {
    public void unsetenv(String name) {
        Map<String, String> map = this.getEnv();
        map.remove(name);
        if (OperatingSystem.current().isWindows()) {
            Map<String, String> env2 = this.getWindowsEnv();
            env2.remove(name);
        }
    }

    public void setenv(String name, String value) {
        Map<String, String> map = this.getEnv();
        map.put(name, value);
        if (OperatingSystem.current().isWindows()) {
            Map<String, String> env2 = this.getWindowsEnv();
            env2.put(name, value);
        }
    }

    private Map<String, String> getWindowsEnv() {
        try {
            Class<?> sc = Class.forName("java.lang.ProcessEnvironment");
            Field caseinsensitive = sc.getDeclaredField("theCaseInsensitiveEnvironment");
            caseinsensitive.setAccessible(true);
            Map result2 = (Map)caseinsensitive.get(null);
            return result2;
        }
        catch (Exception e) {
            throw new NativeIntegrationException("Unable to get mutable windows case insensitive environment map", e);
        }
    }

    private Map<String, String> getEnv() {
        try {
            Map<String, String> theUnmodifiableEnvironment = System.getenv();
            Class<?> cu = theUnmodifiableEnvironment.getClass();
            Field m = cu.getDeclaredField("m");
            m.setAccessible(true);
            Map result2 = (Map)m.get(theUnmodifiableEnvironment);
            return result2;
        }
        catch (Exception e) {
            throw new NativeIntegrationException("Unable to get mutable environment map", e);
        }
    }
}

