/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.gradle.internal.Cast;
import org.gradle.internal.Factory;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.resources.LockCache;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.resources.ResourceLockContainer;
import org.gradle.internal.resources.ResourceLockCoordinationService;
import org.gradle.internal.resources.ResourceLockRegistry;

public abstract class AbstractResourceLockRegistry<K, T extends ResourceLock>
implements ResourceLockRegistry,
ResourceLockContainer {
    private final LockCache<K, T> resourceLocks;
    private final ConcurrentMap<Long, ThreadLockDetails<T>> threadLocks = new ConcurrentHashMap<Long, ThreadLockDetails<T>>();

    public AbstractResourceLockRegistry(ResourceLockCoordinationService coordinationService) {
        this.resourceLocks = new LockCache(coordinationService, this);
    }

    protected T getOrRegisterResourceLock(K key, ResourceLockProducer<K, T> producer) {
        return this.resourceLocks.getOrRegisterResourceLock(key, producer);
    }

    public List<T> getResourceLocksByCurrentThread() {
        return ImmutableList.copyOf((Collection)((ThreadLockDetails)this.detailsForCurrentThread()).locks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S> S whileDisallowingLockChanges(Factory<S> action) {
        ThreadLockDetails<T> lockDetails = this.detailsForCurrentThread();
        boolean previous = ((ThreadLockDetails)lockDetails).mayChange;
        ((ThreadLockDetails)lockDetails).mayChange = false;
        try {
            S s = action.create();
            return s;
        }
        finally {
            ((ThreadLockDetails)lockDetails).mayChange = previous;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S> S allowUncontrolledAccessToAnyResource(Factory<S> factory) {
        ThreadLockDetails<T> lockDetails = this.detailsForCurrentThread();
        boolean previous = ((ThreadLockDetails)lockDetails).canAccessAnything;
        ((ThreadLockDetails)lockDetails).canAccessAnything = true;
        try {
            S s = factory.create();
            return s;
        }
        finally {
            ((ThreadLockDetails)lockDetails).canAccessAnything = previous;
        }
    }

    @Override
    public boolean hasOpenLocks() {
        for (ResourceLock resourceLock : this.resourceLocks.values()) {
            if (!resourceLock.isLocked()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void lockAcquired(ResourceLock resourceLock) {
        ThreadLockDetails<T> lockDetails = this.detailsForCurrentThread();
        if (!((ThreadLockDetails)lockDetails).mayChange) {
            throw new IllegalStateException("This thread may not acquire more locks.");
        }
        ((ThreadLockDetails)lockDetails).locks.add(Cast.uncheckedCast(resourceLock));
    }

    public boolean holdsLock() {
        ThreadLockDetails<T> details = this.detailsForCurrentThread();
        return !((ThreadLockDetails)details).locks.isEmpty();
    }

    private ThreadLockDetails<T> detailsForCurrentThread() {
        long id = Thread.currentThread().getId();
        ThreadLockDetails lockDetails = (ThreadLockDetails)this.threadLocks.get(id);
        if (lockDetails == null) {
            lockDetails = new ThreadLockDetails();
            this.threadLocks.put(id, lockDetails);
        }
        return lockDetails;
    }

    @Override
    public void lockReleased(ResourceLock resourceLock) {
        ThreadLockDetails lockDetails = (ThreadLockDetails)this.threadLocks.get(Thread.currentThread().getId());
        if (!lockDetails.mayChange) {
            throw new IllegalStateException("This thread may not release any locks.");
        }
        lockDetails.locks.remove(resourceLock);
    }

    public boolean mayAttemptToChangeLocks() {
        ThreadLockDetails<T> details = this.detailsForCurrentThread();
        return ((ThreadLockDetails)details).mayChange && !((ThreadLockDetails)details).canAccessAnything;
    }

    public boolean isAllowedUncontrolledAccessToAnyResource() {
        return ((ThreadLockDetails)this.detailsForCurrentThread()).canAccessAnything;
    }

    private static class ThreadLockDetails<T extends ResourceLock> {
        private boolean mayChange = true;
        private boolean canAccessAnything = false;
        private final List<T> locks = new ArrayList<T>();

        private ThreadLockDetails() {
        }
    }

    public static interface ResourceLockProducer<K, T extends ResourceLock> {
        public T create(K var1, ResourceLockCoordinationService var2, ResourceLockContainer var3);
    }
}

