/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.vfs.impl;

import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.MetadataSnapshot;
import org.gradle.internal.snapshot.SnapshotHierarchy;
import org.gradle.internal.vfs.VirtualFileSystem;
import org.gradle.internal.vfs.impl.VersionHierarchyRoot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractVirtualFileSystem
implements VirtualFileSystem {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractVirtualFileSystem.class);
    private final ReentrantLock updateLock = new ReentrantLock();
    protected volatile SnapshotHierarchy root;
    private volatile VersionHierarchyRoot versionHierarchyRoot;

    protected AbstractVirtualFileSystem(SnapshotHierarchy root) {
        this.root = root;
        this.versionHierarchyRoot = VersionHierarchyRoot.empty(0L, root.getCaseSensitivity());
    }

    protected void underLock(Runnable runnable) {
        this.updateLock.lock();
        try {
            runnable.run();
        }
        finally {
            this.updateLock.unlock();
        }
    }

    protected void updateRootUnderLock(UnaryOperator<SnapshotHierarchy> updateFunction) {
        this.underLock(() -> {
            SnapshotHierarchy currentRoot = this.root;
            this.root = (SnapshotHierarchy)updateFunction.apply(currentRoot);
        });
    }

    @Override
    public Optional<FileSystemLocationSnapshot> findSnapshot(String absolutePath) {
        return this.root.findSnapshot(absolutePath);
    }

    @Override
    public Optional<MetadataSnapshot> findMetadata(String absolutePath) {
        return this.root.findMetadata(absolutePath);
    }

    @Override
    public FileSystemLocationSnapshot store(String absolutePath, Supplier<FileSystemLocationSnapshot> snapshotSupplier) {
        long versionBefore = this.versionHierarchyRoot.getVersion(absolutePath);
        FileSystemLocationSnapshot snapshot = snapshotSupplier.get();
        this.storeIfUnchanged(absolutePath, versionBefore, snapshot);
        return snapshot;
    }

    @Override
    public <T> T store(String baseLocation, VirtualFileSystem.StoringAction<T> storingAction) {
        long versionBefore = this.versionHierarchyRoot.getVersion(baseLocation);
        return storingAction.snapshot(snapshot -> {
            this.storeIfUnchanged(snapshot.getAbsolutePath(), versionBefore, snapshot);
            return snapshot;
        });
    }

    private void storeIfUnchanged(String absolutePath, long versionBefore, FileSystemLocationSnapshot snapshot) {
        long versionAfter = this.versionHierarchyRoot.getVersion(absolutePath);
        if (versionBefore >= versionAfter) {
            this.updateRootUnderLock(root -> this.updateNotifyingListeners(diffListener -> root.store(absolutePath, snapshot, diffListener)));
        } else {
            LOGGER.debug("Changes to the virtual file system happened while snapshotting '{}', not storing resulting snapshot", (Object)absolutePath);
        }
    }

    @Override
    public void invalidate(Iterable<String> locations) {
        LOGGER.debug("Invalidating VFS paths: {}", locations);
        this.updateRootUnderLock(root -> {
            SnapshotHierarchy result2 = root;
            VersionHierarchyRoot newVersionHierarchyRoot = this.versionHierarchyRoot;
            for (String location : locations) {
                SnapshotHierarchy currentRoot = result2;
                result2 = this.updateNotifyingListeners(diffListener -> currentRoot.invalidate(location, diffListener));
                newVersionHierarchyRoot = newVersionHierarchyRoot.updateVersion(location);
            }
            this.versionHierarchyRoot = newVersionHierarchyRoot;
            return result2;
        });
    }

    @Override
    public void invalidateAll() {
        LOGGER.debug("Invalidating the whole VFS");
        this.invalidate(Collections.singletonList(""));
    }

    protected abstract SnapshotHierarchy updateNotifyingListeners(UpdateFunction var1);

    public static interface UpdateFunction {
        public SnapshotHierarchy update(SnapshotHierarchy.NodeDiffListener var1);
    }
}

