/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import org.gradle.internal.jvm.inspection.JvmInstallationMetadata;
import org.gradle.jvm.toolchain.JavaCompiler;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavadocTool;
import org.gradle.jvm.toolchain.internal.operations.JavaToolchainUsageProgressDetails;

public class DefaultJavaToolchainUsageProgressDetails
implements JavaToolchainUsageProgressDetails {
    private final JavaTool toolName;
    private final JvmInstallationMetadata toolchainMetadata;

    public DefaultJavaToolchainUsageProgressDetails(JavaTool toolName, JvmInstallationMetadata toolchainMetadata) {
        this.toolName = toolName;
        this.toolchainMetadata = toolchainMetadata;
    }

    @Override
    public String getToolName() {
        return this.toolName.getToolName();
    }

    @Override
    public JavaToolchainUsageProgressDetails.JavaToolchain getToolchain() {
        final JvmInstallationMetadata metadata = this.toolchainMetadata;
        return new JavaToolchainUsageProgressDetails.JavaToolchain(){

            @Override
            public String getJavaVersion() {
                return metadata.getJavaVersion();
            }

            @Override
            public String getJavaVendor() {
                return metadata.getVendor().getDisplayName();
            }

            @Override
            public String getRuntimeName() {
                return metadata.getRuntimeName();
            }

            @Override
            public String getRuntimeVersion() {
                return metadata.getRuntimeVersion();
            }

            @Override
            public String getJvmName() {
                return metadata.getJvmName();
            }

            @Override
            public String getJvmVersion() {
                return metadata.getJvmVersion();
            }

            @Override
            public String getJvmVendor() {
                return metadata.getJvmVendor();
            }

            @Override
            public String getArchitecture() {
                return metadata.getArchitecture();
            }
        };
    }

    public static enum JavaTool {
        COMPILER(JavaCompiler.class.getSimpleName()),
        LAUNCHER(JavaLauncher.class.getSimpleName()),
        JAVADOC(JavadocTool.class.getSimpleName());

        private final String toolName;

        private JavaTool(String toolName) {
            this.toolName = toolName;
        }

        public String getToolName() {
            return this.toolName;
        }
    }
}

