/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal.modulemap;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.specs.Spec;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.io.Files;
import org.gradle.internal.impldep.org.apache.commons.io.FileUtils;
import org.gradle.util.internal.CollectionUtils;

public class GenerateModuleMapFile {
    public static void generateFile(File moduleMapFile, String moduleName, List<String> publicHeaderDirs) {
        ArrayList lines = Lists.newArrayList((Object[])new String[]{"module " + moduleName + " {"});
        List<String> validHeaderDirs = CollectionUtils.filter(publicHeaderDirs, new Spec<String>(){

            @Override
            public boolean isSatisfiedBy(String path) {
                return new File(path).exists();
            }
        });
        lines.addAll(CollectionUtils.collect(validHeaderDirs, path -> "\tumbrella \"" + path + "\""));
        lines.add("\texport *");
        lines.add("}");
        try {
            Files.createParentDirs((File)moduleMapFile);
            FileUtils.writeLines((File)moduleMapFile, (Collection)lines);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not generate a module map for " + moduleName, e);
        }
    }
}

