/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.resolve.internal;

import javax.annotation.Nullable;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.plugins.DefaultPluginRegistry;
import org.gradle.api.internal.plugins.PluginImplementation;
import org.gradle.api.internal.plugins.PluginInspector;
import org.gradle.api.plugins.UnknownPluginException;
import org.gradle.plugin.use.PluginId;
import org.gradle.plugin.use.resolve.internal.PluginResolution;
import org.gradle.plugin.use.resolve.internal.PluginResolveContext;

public class ClassPathPluginResolution
implements PluginResolution {
    private final PluginId pluginId;
    private final String pluginVersion;
    private final ClassLoaderScope parent;
    private final PluginInspector pluginInspector;

    public ClassPathPluginResolution(PluginId pluginId, String pluginVersion, ClassLoaderScope parent, PluginInspector pluginInspector) {
        this.pluginId = pluginId;
        this.pluginVersion = pluginVersion;
        this.parent = parent;
        this.pluginInspector = pluginInspector;
    }

    @Override
    public PluginId getPluginId() {
        return this.pluginId;
    }

    @Override
    @Nullable
    public String getPluginVersion() {
        return this.pluginVersion;
    }

    @Override
    public void execute(PluginResolveContext pluginResolveContext) {
        DefaultPluginRegistry pluginRegistry = new DefaultPluginRegistry(this.pluginInspector, this.parent);
        PluginImplementation<?> plugin = pluginRegistry.lookup(this.pluginId);
        if (plugin == null) {
            throw new UnknownPluginException("Plugin with id '" + this.pluginId + "' not found.");
        }
        pluginResolveContext.add(plugin);
    }
}

