/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.resolve.service.internal;

import java.io.File;
import java.util.Collection;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.plugins.DefaultPluginRegistry;
import org.gradle.api.internal.plugins.PluginImplementation;
import org.gradle.api.internal.plugins.PluginInspector;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.internal.classpath.CachedClasspathTransformer;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.impldep.com.google.common.base.Function;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.plugin.management.internal.InvalidPluginRequestException;
import org.gradle.plugin.management.internal.PluginRequestInternal;
import org.gradle.plugin.use.PluginId;
import org.gradle.plugin.use.resolve.internal.PluginResolution;
import org.gradle.plugin.use.resolve.internal.PluginResolutionResult;
import org.gradle.plugin.use.resolve.internal.PluginResolveContext;
import org.gradle.plugin.use.resolve.internal.PluginResolver;
import org.gradle.plugin.use.resolve.service.internal.ClientInjectedClasspathPluginResolver;
import org.gradle.plugin.use.resolve.service.internal.InjectedClasspathInstrumentationStrategy;

public class DefaultInjectedClasspathPluginResolver
implements ClientInjectedClasspathPluginResolver,
PluginResolver {
    private final ClassPath injectedClasspath;
    private final PluginRegistry pluginRegistry;

    public DefaultInjectedClasspathPluginResolver(ClassLoaderScope parentScope, CachedClasspathTransformer classpathTransformer, PluginInspector pluginInspector, ClassPath injectedClasspath, InjectedClasspathInstrumentationStrategy instrumentationStrategy) {
        this.injectedClasspath = injectedClasspath;
        ClassPath cachedClassPath = classpathTransformer.transform(injectedClasspath, instrumentationStrategy.getTransform());
        this.pluginRegistry = new DefaultPluginRegistry(pluginInspector, parentScope.createChild("injected-plugin", null).local(cachedClassPath).lock());
    }

    @Override
    public void collectResolversInto(Collection<? super PluginResolver> dest) {
        dest.add(this);
    }

    @Override
    public void resolve(PluginRequestInternal pluginRequest, PluginResolutionResult result2) throws InvalidPluginRequestException {
        PluginImplementation<?> plugin = this.pluginRegistry.lookup(pluginRequest.getId());
        if (plugin == null) {
            String classpathStr = Joiner.on((String)File.pathSeparator).join(Iterables.transform(this.injectedClasspath.getAsFiles(), (Function)new Function<File, String>(){

                public String apply(File input) {
                    return input.getAbsolutePath();
                }
            }));
            result2.notFound(this.getDescription(), "classpath: " + classpathStr);
        } else {
            result2.found(this.getDescription(), new InjectedClasspathPluginResolution(plugin));
        }
    }

    public String getDescription() {
        return "Gradle TestKit";
    }

    public boolean isClasspathEmpty() {
        return this.injectedClasspath.isEmpty();
    }

    private static class InjectedClasspathPluginResolution
    implements PluginResolution {
        private final PluginImplementation<?> plugin;

        public InjectedClasspathPluginResolution(PluginImplementation<?> plugin) {
            this.plugin = plugin;
        }

        @Override
        public PluginId getPluginId() {
            return this.plugin.getPluginId();
        }

        @Override
        public void execute(PluginResolveContext pluginResolveContext) {
            pluginResolveContext.addFromDifferentLoader(this.plugin);
        }
    }
}

