/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.model.internal;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.plugins.ide.eclipse.model.FileReference;
import org.gradle.plugins.ide.eclipse.model.internal.PathUtil;

public class FileReferenceFactory {
    private final Map<String, File> variables = Maps.newHashMap();

    public void addPathVariable(String name, File dir) {
        this.variables.put(name, dir);
    }

    public FileReference fromFile(File file) {
        if (file == null) {
            return null;
        }
        String path = null;
        boolean usedVar = false;
        for (Map.Entry<String, File> entry : this.variables.entrySet()) {
            String rootDirPath = entry.getValue().getAbsolutePath();
            String filePath = file.getAbsolutePath();
            if (filePath.equals(rootDirPath)) {
                path = entry.getKey();
                usedVar = true;
                break;
            }
            if (!filePath.startsWith(rootDirPath + File.separator)) continue;
            int len = rootDirPath.length();
            path = entry.getKey() + filePath.substring(len);
            usedVar = true;
            break;
        }
        path = PathUtil.normalizePath(path != null ? path : file.getAbsolutePath());
        return new FileReferenceImpl(file, path, usedVar);
    }

    public FileReference fromPath(String path) {
        if (path == null) {
            return null;
        }
        return new FileReferenceImpl(new File(path), path, false);
    }

    public FileReference fromJarURI(String jarURI) {
        if (jarURI == null) {
            return null;
        }
        URI fileURI = null;
        try {
            fileURI = new URI(jarURI.replace("jar:", "").replace("!/", ""));
        }
        catch (URISyntaxException e) {
            UncheckedException.throwAsUncheckedException(e);
        }
        File file = new File(fileURI);
        String path = PathUtil.normalizePath(file.getAbsolutePath());
        return new FileReferenceImpl(file, path, false);
    }

    public FileReference fromVariablePath(String path) {
        if (path == null) {
            return null;
        }
        for (Map.Entry<String, File> entry : this.variables.entrySet()) {
            String prefix = entry.getKey() + "/";
            if (!path.startsWith(prefix)) continue;
            File file = new File(entry.getValue(), path.substring(prefix.length()));
            return new FileReferenceImpl(file, path, true);
        }
        return this.fromPath(path);
    }

    private static class FileReferenceImpl
    implements FileReference {
        final File file;
        final String path;
        final boolean relativeToPathVariable;

        FileReferenceImpl(File file, String path, boolean relativeToPathVariable) {
            this.file = file;
            this.path = path;
            this.relativeToPathVariable = relativeToPathVariable;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            FileReference ref = (FileReference)obj;
            return this.file.equals(ref.getFile());
        }

        @Override
        public File getFile() {
            return this.file;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public String getJarURL() {
            return "jar:" + this.file.toURI() + "!/";
        }

        @Override
        public boolean isRelativeToPathVariable() {
            return this.relativeToPathVariable;
        }

        public String toString() {
            return "{file='" + this.file + "', path='" + this.path + "', jarUrl='" + this.getJarURL() + "'}";
        }

        public int hashCode() {
            return this.file.hashCode();
        }
    }
}

