/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.generator;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.gradle.api.Action;
import org.gradle.api.internal.PropertiesTransformer;
import org.gradle.plugins.ide.internal.generator.AbstractPersistableConfigurationObject;
import org.gradle.util.internal.ConfigureUtil;

public abstract class PropertiesPersistableConfigurationObject
extends AbstractPersistableConfigurationObject {
    private final PropertiesTransformer transformer;
    private Properties properties;

    protected PropertiesPersistableConfigurationObject(PropertiesTransformer transformer) {
        this.transformer = transformer;
    }

    @Override
    public void load(InputStream inputStream) throws Exception {
        this.properties = new Properties();
        this.properties.load(inputStream);
        this.load(this.properties);
    }

    @Override
    public void store(OutputStream outputStream) {
        this.store(this.properties);
        this.transformer.transform(this.properties, outputStream);
    }

    protected abstract void store(Properties var1);

    protected abstract void load(Properties var1);

    public void transformAction(@DelegatesTo(value=Properties.class) Closure action) {
        this.transformAction(ConfigureUtil.configureUsing(action));
    }

    public void transformAction(Action<? super Properties> action) {
        this.transformer.addAction(action);
    }
}

