/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.worker;

import java.io.File;
import java.util.Set;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.Cast;
import org.gradle.internal.classloader.ClasspathUtil;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.remote.ObjectConnection;
import org.gradle.process.internal.JavaExecHandleBuilder;
import org.gradle.process.internal.worker.DefaultWorkerProcessBuilder;
import org.gradle.process.internal.worker.RequestHandler;
import org.gradle.process.internal.worker.SingleRequestWorkerProcessBuilder;
import org.gradle.process.internal.worker.WorkerProcess;
import org.gradle.process.internal.worker.WorkerProcessException;
import org.gradle.process.internal.worker.WorkerProcessSettings;
import org.gradle.process.internal.worker.request.Receiver;
import org.gradle.process.internal.worker.request.Request;
import org.gradle.process.internal.worker.request.RequestArgumentSerializers;
import org.gradle.process.internal.worker.request.RequestProtocol;
import org.gradle.process.internal.worker.request.RequestSerializerRegistry;
import org.gradle.process.internal.worker.request.ResponseProtocol;
import org.gradle.process.internal.worker.request.WorkerAction;

class DefaultSingleRequestWorkerProcessBuilder<IN, OUT>
implements SingleRequestWorkerProcessBuilder<IN, OUT> {
    private final Class<?> workerImplementation;
    private final DefaultWorkerProcessBuilder builder;
    private final RequestArgumentSerializers argumentSerializers = new RequestArgumentSerializers();
    private final OutputEventListener outputEventListener;

    public DefaultSingleRequestWorkerProcessBuilder(Class<?> workerImplementation, DefaultWorkerProcessBuilder builder, OutputEventListener outputEventListener) {
        this.workerImplementation = workerImplementation;
        this.builder = builder;
        this.outputEventListener = outputEventListener;
        builder.worker(new WorkerAction(workerImplementation));
        builder.setImplementationClasspath(ClasspathUtil.getClasspath(workerImplementation.getClassLoader()).getAsURLs());
    }

    @Override
    public WorkerProcessSettings setBaseName(String baseName) {
        this.builder.setBaseName(baseName);
        return this;
    }

    @Override
    public String getBaseName() {
        return this.builder.getBaseName();
    }

    @Override
    public WorkerProcessSettings applicationClasspath(Iterable<File> files) {
        this.builder.applicationClasspath((Iterable)files);
        return this;
    }

    @Override
    public Set<File> getApplicationClasspath() {
        return this.builder.getApplicationClasspath();
    }

    @Override
    public WorkerProcessSettings applicationModulePath(Iterable<File> files) {
        this.builder.applicationModulePath((Iterable)files);
        return this;
    }

    @Override
    public Set<File> getApplicationModulePath() {
        return this.builder.getApplicationModulePath();
    }

    @Override
    public WorkerProcessSettings sharedPackages(String ... packages) {
        this.builder.sharedPackages(packages);
        return this;
    }

    @Override
    public WorkerProcessSettings sharedPackages(Iterable<String> packages) {
        this.builder.sharedPackages((Iterable)packages);
        return this;
    }

    @Override
    public Set<String> getSharedPackages() {
        return this.builder.getSharedPackages();
    }

    @Override
    public JavaExecHandleBuilder getJavaCommand() {
        return this.builder.getJavaCommand();
    }

    @Override
    public LogLevel getLogLevel() {
        return this.builder.getLogLevel();
    }

    @Override
    public WorkerProcessSettings setLogLevel(LogLevel logLevel) {
        this.builder.setLogLevel(logLevel);
        return this;
    }

    @Override
    public RequestHandler<IN, OUT> build() {
        return new RequestHandler<IN, OUT>(){

            @Override
            public OUT run(IN request) {
                Receiver receiver = new Receiver(DefaultSingleRequestWorkerProcessBuilder.this.getBaseName(), DefaultSingleRequestWorkerProcessBuilder.this.outputEventListener);
                try {
                    WorkerProcess workerProcess = DefaultSingleRequestWorkerProcessBuilder.this.builder.build();
                    workerProcess.start();
                    ObjectConnection connection = workerProcess.getConnection();
                    RequestProtocol requestProtocol = connection.addOutgoing(RequestProtocol.class);
                    connection.addIncoming(ResponseProtocol.class, receiver);
                    connection.useJavaSerializationForParameters(DefaultSingleRequestWorkerProcessBuilder.this.workerImplementation.getClassLoader());
                    connection.useParameterSerializers(RequestSerializerRegistry.create(DefaultSingleRequestWorkerProcessBuilder.this.workerImplementation.getClassLoader(), DefaultSingleRequestWorkerProcessBuilder.this.argumentSerializers));
                    connection.connect();
                    requestProtocol.runThenStop(new Request(request, CurrentBuildOperationRef.instance().get()));
                    boolean hasResult = receiver.awaitNextResult();
                    workerProcess.waitForStop();
                    if (!hasResult) {
                        throw new IllegalStateException(String.format("No response was received from %s but the worker process has finished.", DefaultSingleRequestWorkerProcessBuilder.this.getBaseName()));
                    }
                }
                catch (Exception e) {
                    throw WorkerProcessException.runFailed(DefaultSingleRequestWorkerProcessBuilder.this.getBaseName(), e);
                }
                return Cast.uncheckedNonnullCast(receiver.getNextResult());
            }
        };
    }
}

