/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import java.util.ArrayList;
import java.util.List;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.internal.build.event.BuildEventListenerFactory;
import org.gradle.internal.build.event.BuildEventSubscriptions;
import org.gradle.internal.buildtree.BuildActionRunner;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.BuildOperationListenerManager;
import org.gradle.internal.session.BuildSessionActionExecutor;
import org.gradle.internal.session.BuildSessionContext;
import org.gradle.tooling.internal.provider.action.SubscribableBuildAction;

public class SubscribableBuildActionExecutor
implements BuildSessionActionExecutor {
    private final BuildEventConsumer eventConsumer;
    private final BuildSessionActionExecutor delegate;
    private final ListenerManager listenerManager;
    private final BuildOperationListenerManager buildOperationListenerManager;
    private final List<Object> listeners = new ArrayList<Object>();
    private final BuildEventListenerFactory factory;

    public SubscribableBuildActionExecutor(ListenerManager listenerManager, BuildOperationListenerManager buildOperationListenerManager, BuildEventListenerFactory factory, BuildEventConsumer eventConsumer, BuildSessionActionExecutor delegate) {
        this.listenerManager = listenerManager;
        this.buildOperationListenerManager = buildOperationListenerManager;
        this.factory = factory;
        this.eventConsumer = eventConsumer;
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BuildActionRunner.Result execute(BuildAction action, BuildSessionContext buildSession) {
        if (action instanceof SubscribableBuildAction) {
            SubscribableBuildAction subscribableBuildAction = (SubscribableBuildAction)action;
            this.registerListenersForClientSubscriptions(subscribableBuildAction.getClientSubscriptions(), this.eventConsumer);
        }
        try {
            BuildActionRunner.Result result2 = this.delegate.execute(action, buildSession);
            return result2;
        }
        finally {
            for (Object listener2 : this.listeners) {
                this.listenerManager.removeListener(listener2);
                if (!(listener2 instanceof BuildOperationListener)) continue;
                this.buildOperationListenerManager.removeListener((BuildOperationListener)listener2);
            }
            this.listeners.clear();
        }
    }

    private void registerListenersForClientSubscriptions(BuildEventSubscriptions clientSubscriptions, BuildEventConsumer eventConsumer) {
        for (Object listener2 : this.factory.createListeners(clientSubscriptions, eventConsumer)) {
            this.registerListener(listener2);
        }
    }

    private void registerListener(Object listener2) {
        this.listeners.add(listener2);
        this.listenerManager.addListener(listener2);
        if (listener2 instanceof BuildOperationListener) {
            this.buildOperationListenerManager.addListener((BuildOperationListener)listener2);
        }
    }
}

