/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class MavenExplicitProfiles
implements Serializable {
    public static final MavenExplicitProfiles NONE = new MavenExplicitProfiles(Collections.emptySet());
    private final Collection<String> myEnabledProfiles;
    private final Collection<String> myDisabledProfiles;

    public MavenExplicitProfiles(Collection<String> enabledProfiles, Collection<String> disabledProfiles) {
        this.myEnabledProfiles = enabledProfiles;
        this.myDisabledProfiles = disabledProfiles;
    }

    public MavenExplicitProfiles(Collection<String> enabledProfiles) {
        this(enabledProfiles, Collections.emptySet());
    }

    public Collection<String> getEnabledProfiles() {
        return this.myEnabledProfiles;
    }

    public Collection<String> getDisabledProfiles() {
        return this.myDisabledProfiles;
    }

    public MavenExplicitProfiles clone() {
        return new MavenExplicitProfiles(new HashSet<String>(this.myEnabledProfiles), new HashSet<String>(this.myDisabledProfiles));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenExplicitProfiles that = (MavenExplicitProfiles)o;
        if (!this.myEnabledProfiles.equals(that.myEnabledProfiles)) {
            return false;
        }
        return this.myDisabledProfiles.equals(that.myDisabledProfiles);
    }

    public int hashCode() {
        int result = this.myEnabledProfiles.hashCode();
        result = 31 * result + this.myDisabledProfiles.hashCode();
        return result;
    }

    public String toString() {
        return "MavenExplicitProfiles{myEnabledProfiles=" + this.myEnabledProfiles + ", myDisabledProfiles=" + this.myDisabledProfiles + '}';
    }
}

