/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class ParallelRunner {
    @NotNull
    private static <T> Consumer<T> toThrowingConsumer(@NotNull ThrowingConsumer<T> consumer) {
        if (consumer == null) {
            ParallelRunner.$$$reportNull$$$0(0);
        }
        ThrowingConsumer<T> throwingConsumer = consumer;
        if (throwingConsumer == null) {
            ParallelRunner.$$$reportNull$$$0(1);
        }
        return throwingConsumer;
    }

    private static <E extends Throwable> void sneakyThrow(@NotNull Throwable ex) throws E {
        if (ex == null) {
            ParallelRunner.$$$reportNull$$$0(2);
        }
        throw ex;
    }

    public static <T> void runInParallel(@NotNull Collection<T> collection, @NotNull Consumer<T> method) {
        if (collection == null) {
            ParallelRunner.$$$reportNull$$$0(3);
        }
        if (method == null) {
            ParallelRunner.$$$reportNull$$$0(4);
        }
        collection.parallelStream().flatMap(item -> {
            try {
                method.accept(item);
                return null;
            }
            catch (RuntimeException ex) {
                return Stream.of(ex);
            }
        }).reduce((ex1, ex2) -> {
            ex1.addSuppressed((Throwable)ex2);
            return ex1;
        }).ifPresent(ex -> {
            throw ex;
        });
    }

    public static <T, E extends Throwable> void runInParallelRethrow(@NotNull Collection<T> collection, @NotNull ThrowingConsumer<T> method) throws E {
        if (collection == null) {
            ParallelRunner.$$$reportNull$$$0(5);
        }
        if (method == null) {
            ParallelRunner.$$$reportNull$$$0(6);
        }
        collection.parallelStream().forEach(ParallelRunner.toThrowingConsumer(item -> method.accept(item)));
    }

    public static <T> void runSequentially(@NotNull Collection<T> collection, @NotNull Consumer<T> method) {
        if (collection == null) {
            ParallelRunner.$$$reportNull$$$0(7);
        }
        if (method == null) {
            ParallelRunner.$$$reportNull$$$0(8);
        }
        collection.forEach(method);
    }

    public static <T, E extends Throwable> void runSequentiallyRethrow(@NotNull Collection<T> collection, @NotNull ThrowingConsumer<T> method) throws E {
        if (collection == null) {
            ParallelRunner.$$$reportNull$$$0(9);
        }
        if (method == null) {
            ParallelRunner.$$$reportNull$$$0(10);
        }
        collection.forEach(method);
    }

    public static <T, R, E extends Exception> List<R> executeSequentially(@NotNull Collection<T> collection, @NotNull CheckedFunction<T, R, E> method) throws E {
        if (collection == null) {
            ParallelRunner.$$$reportNull$$$0(11);
        }
        if (method == null) {
            ParallelRunner.$$$reportNull$$$0(12);
        }
        ArrayList<R> result = new ArrayList<R>();
        for (T item : collection) {
            result.add(method.apply(item));
        }
        return result;
    }

    public static <T, R, E extends Exception> List<R> executeInParallel(@NotNull Collection<T> collection, @NotNull CheckedFunction<T, R, E> method) throws E {
        if (collection == null) {
            ParallelRunner.$$$reportNull$$$0(13);
        }
        if (method == null) {
            ParallelRunner.$$$reportNull$$$0(14);
        }
        ConcurrentHashMap.KeySetView runtimeExceptions = ConcurrentHashMap.newKeySet();
        ConcurrentHashMap.KeySetView checkedExceptions = ConcurrentHashMap.newKeySet();
        List result = collection.parallelStream().map(item -> {
            try {
                return new Pair((Object)true, method.apply(item));
            }
            catch (RuntimeException ex) {
                runtimeExceptions.add(ex);
            }
            catch (Exception ex) {
                checkedExceptions.add(ex);
            }
            return new Pair((Object)false, null);
        }).filter(pair -> (Boolean)pair.getFirst()).map(pair -> pair.second).collect(Collectors.toList());
        if (!runtimeExceptions.isEmpty()) {
            throw (RuntimeException)runtimeExceptions.stream().reduce((ex1, ex2) -> {
                ex1.addSuppressed((Throwable)ex2);
                return ex1;
            }).get();
        }
        if (!checkedExceptions.isEmpty()) {
            throw (Exception)checkedExceptions.stream().reduce((ex1, ex2) -> {
                ex1.addSuppressed((Throwable)ex2);
                return ex1;
            }).get();
        }
        return result;
    }

    public static <T, R, E extends Exception> List<R> execute(boolean inParallel, @NotNull Collection<T> collection, @NotNull CheckedFunction<T, R, E> method) throws E {
        if (collection == null) {
            ParallelRunner.$$$reportNull$$$0(15);
        }
        if (method == null) {
            ParallelRunner.$$$reportNull$$$0(16);
        }
        return inParallel ? ParallelRunner.executeInParallel(collection, method) : ParallelRunner.executeSequentially(collection, method);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/server/ParallelRunner";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ex";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/server/ParallelRunner";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "toThrowingConsumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toThrowingConsumer";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "sneakyThrow";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "runInParallel";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "runInParallelRethrow";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "runSequentially";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "runSequentiallyRethrow";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "executeSequentially";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "executeInParallel";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    public static interface ThrowingConsumer<T>
    extends Consumer<T> {
        @Override
        default public void accept(T e) {
            try {
                this.accept0(e);
            }
            catch (Throwable ex) {
                ParallelRunner.sneakyThrow(ex);
            }
        }

        public void accept0(T var1) throws Throwable;
    }

    @FunctionalInterface
    public static interface CheckedFunction<T, R, E extends Exception> {
        public R apply(T var1) throws E;
    }
}

