/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.psi.text;

import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.psi.file.KtDecompiledFile;
import org.jetbrains.kotlin.analysis.decompiler.psi.text.BuildDecompiledTextKt;
import org.jetbrains.kotlin.analysis.decompiler.psi.text.ByDescriptorIndexerKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtClassOrObjectKt;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtDeclarationModifierList;
import org.jetbrains.kotlin.psi.KtDeclarationStub;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeConstraint;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.AbbreviatedType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001c\u0010\u0018\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u0016H\u0002J\u0018\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u0016H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/psi/text/ByDescriptorIndexer;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "areTypesTheSame", "", "kotlinType", "Lorg/jetbrains/kotlin/types/KotlinType;", "ktTypeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "getDeclarationForDescriptor", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "file", "Lorg/jetbrains/kotlin/analysis/decompiler/psi/file/KtDecompiledFile;", "isSameCallable", "declaration", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "original", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "parametersMatch", "receiverTypesMatch", "receiverParameter", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "returnTypesMatch", "typeParametersMatch", "decompiler-to-psi"})
@SourceDebugExtension(value={"SMAP\nByDescriptorIndexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByDescriptorIndexer.kt\norg/jetbrains/kotlin/analysis/decompiler/psi/text/ByDescriptorIndexer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,210:1\n766#2:211\n857#2,2:212\n288#2,2:214\n1477#2:216\n1502#2,3:217\n1505#2,3:227\n3433#2,5:230\n1855#2,2:235\n766#2:237\n857#2,2:238\n3433#2,7:240\n3439#2:247\n1855#2,2:248\n372#3,7:220\n12474#4,2:250\n*S KotlinDebug\n*F\n+ 1 ByDescriptorIndexer.kt\norg/jetbrains/kotlin/analysis/decompiler/psi/text/ByDescriptorIndexer\n*L\n77#1:211\n77#1:212,2\n80#1:214,2\n115#1:216\n115#1:217,3\n115#1:227,3\n116#1:230,5\n120#1:235,2\n123#1:237\n123#1:238,2\n125#1:240,7\n116#1:247\n141#1:248,2\n115#1:220,7\n173#1:250,2\n*E\n"})
public final class ByDescriptorIndexer {
    @NotNull
    public static final ByDescriptorIndexer INSTANCE = new ByDescriptorIndexer();
    @NotNull
    private static final Logger LOG;

    private ByDescriptorIndexer() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final KtDeclaration getDeclarationForDescriptor(@NotNull DeclarationDescriptor descriptor, @NotNull KtDecompiledFile file) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        DeclarationDescriptor declarationDescriptor = descriptor.getOriginal();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getOriginal(...)");
        DeclarationDescriptor original = declarationDescriptor;
        if (original instanceof TypeAliasConstructorDescriptor) {
            return this.getDeclarationForDescriptor((DeclarationDescriptor)((TypeAliasConstructorDescriptor)original).getTypeAliasDescriptor(), file);
        }
        if (original instanceof ValueParameterDescriptor) {
            CallableDescriptor callable = ((ValueParameterDescriptor)original).getContainingDeclaration();
            KtDeclaration ktDeclaration = this.getDeclarationForDescriptor((DeclarationDescriptor)callable, file);
            KtCallableDeclaration ktCallableDeclaration = ktDeclaration instanceof KtCallableDeclaration ? (KtCallableDeclaration)ktDeclaration : null;
            if (ktCallableDeclaration == null) {
                return null;
            }
            KtCallableDeclaration callableDeclaration = ktCallableDeclaration;
            if (((ValueParameterDescriptor)original).getIndex() >= callableDeclaration.getValueParameters().size()) {
                KtParameterList ktParameterList = callableDeclaration.getValueParameterList();
                LOG.error("Parameter count mismatch for " + DescriptorRenderer.DEBUG_TEXT.render((DeclarationDescriptor)callable) + '[' + ((ValueParameterDescriptor)original).getIndex() + "] vs " + (ktParameterList != null ? ktParameterList.getText() : null));
                return null;
            }
            return callableDeclaration.getValueParameters().get(((ValueParameterDescriptor)original).getIndex());
        }
        if (original instanceof ConstructorDescriptor && ((ConstructorDescriptor)original).isPrimary()) {
            ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = ((ConstructorDescriptor)original).getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)classifierDescriptorWithTypeParameters, (String)"getContainingDeclaration(...)");
            KtDeclaration callableDeclaration = this.getDeclarationForDescriptor((DeclarationDescriptor)classifierDescriptorWithTypeParameters, file);
            KtClassOrObject classOrObject = callableDeclaration instanceof KtClassOrObject ? (KtClassOrObject)callableDeclaration : null;
            KtDeclarationStub ktDeclarationStub = classOrObject;
            return ktDeclarationStub != null && (ktDeclarationStub = ktDeclarationStub.getPrimaryConstructor()) != null ? (KtDeclaration)ktDeclarationStub : (KtDeclaration)classOrObject;
        }
        CallableMemberDescriptor callableMemberDescriptor = original instanceof CallableMemberDescriptor ? (CallableMemberDescriptor)original : null;
        boolean bl = callableMemberDescriptor != null ? BuildDecompiledTextKt.mustNotBeWrittenToDecompiledText(callableMemberDescriptor) : false;
        if (bl && ((CallableMemberDescriptor)original).getContainingDeclaration() instanceof ClassDescriptor) {
            DeclarationDescriptor declarationDescriptor2 = ((CallableMemberDescriptor)original).getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor2, (String)"getContainingDeclaration(...)");
            return this.getDeclarationForDescriptor(declarationDescriptor2, file);
        }
        if (original instanceof FakeCallableDescriptorForObject) {
            return this.getDeclarationForDescriptor((DeclarationDescriptor)((FakeCallableDescriptorForObject)original).getClassDescriptor(), file);
        }
        if (original instanceof MemberDescriptor) {
            KtDeclarationContainer ktDeclarationContainer;
            if (DescriptorUtils.isTopLevelDeclaration((DeclarationDescriptor)original)) {
                ktDeclarationContainer = file;
            } else if (((MemberDescriptor)original).getContainingDeclaration() instanceof ClassDescriptor) {
                DeclarationDescriptor declarationDescriptor3 = ((MemberDescriptor)original).getContainingDeclaration();
                Intrinsics.checkNotNull((Object)declarationDescriptor3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                KtDeclaration callableDeclaration = this.getDeclarationForDescriptor((DeclarationDescriptor)((ClassDescriptor)declarationDescriptor3), file);
                ktDeclarationContainer = callableDeclaration instanceof KtClassOrObject ? (KtClassOrObject)callableDeclaration : null;
            } else {
                throw new IllegalStateException(("Unexpected " + original + " with container: " + ((MemberDescriptor)original).getContainingDeclaration()).toString());
            }
            KtDeclarationContainer declarationContainer = ktDeclarationContainer;
            if (declarationContainer != null) {
                Object v14;
                block17: {
                    void $this$firstOrNull$iv;
                    Iterable $this$filter$iv;
                    List list;
                    String string = ((MemberDescriptor)original).getName().asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                    String descriptorName = string;
                    if (original instanceof ConstructorDescriptor && declarationContainer instanceof KtClass) {
                        list = KtClassOrObjectKt.getAllConstructors((KtClassOrObject)declarationContainer);
                    } else {
                        void $this$filterTo$iv$iv;
                        List<KtDeclaration> list2 = declarationContainer.getDeclarations();
                        Intrinsics.checkNotNullExpressionValue(list2, (String)"getDeclarations(...)");
                        $this$filter$iv = list2;
                        boolean $i$f$filter = false;
                        Iterable iterable = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            KtDeclaration it = (KtDeclaration)element$iv$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)descriptorName)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        list = (List)destination$iv$iv;
                    }
                    List declarations = list;
                    $this$filter$iv = declarations;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        KtDeclaration declaration = (KtDeclaration)element$iv;
                        boolean bl3 = false;
                        boolean bl4 = original instanceof CallableDescriptor ? declaration instanceof KtCallableDeclaration && INSTANCE.isSameCallable((KtCallableDeclaration)declaration, (CallableDescriptor)original) : !(declaration instanceof KtCallableDeclaration);
                        if (!bl4) continue;
                        v14 = element$iv;
                        break block17;
                    }
                    v14 = null;
                }
                return v14;
            }
        }
        throw new IllegalStateException(("Should not be reachable: " + descriptor).toString());
    }

    public final boolean isSameCallable(@NotNull KtCallableDeclaration declaration, @NotNull CallableDescriptor original) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        if (!this.receiverTypesMatch(declaration.getReceiverTypeReference(), original.getExtensionReceiverParameter())) {
            return false;
        }
        if (!this.returnTypesMatch(declaration, original)) {
            return false;
        }
        if (!this.typeParametersMatch(declaration, original)) {
            return false;
        }
        return this.parametersMatch(declaration, original);
    }

    private final boolean returnTypesMatch(KtCallableDeclaration declaration, CallableDescriptor descriptor) {
        if (declaration instanceof KtConstructor) {
            return true;
        }
        KtTypeReference ktTypeReference = declaration.getTypeReference();
        if (ktTypeReference == null) {
            return true;
        }
        KtTypeReference typeReference = ktTypeReference;
        KotlinType kotlinType = descriptor.getReturnType();
        Intrinsics.checkNotNull((Object)kotlinType);
        return this.areTypesTheSame(kotlinType, typeReference);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean typeParametersMatch(KtCallableDeclaration declaration, CallableDescriptor descriptor) {
        void $this$zip$iv;
        List list$iv$iv;
        Object value$iv$iv$iv;
        void $this$groupByTo$iv$iv;
        if (declaration.getTypeParameters().size() != declaration.getTypeParameters().size()) {
            return false;
        }
        List list = declaration.getTypeConstraints();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTypeConstraints(...)");
        Iterable $this$groupBy$iv = list;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            KtTypeConstraint it = (KtTypeConstraint)element$iv$iv;
            boolean bl = false;
            KtSimpleNameExpression ktSimpleNameExpression = it.getSubjectTypeParameterName();
            String key$iv$iv = ktSimpleNameExpression != null ? ktSimpleNameExpression.getReferencedName() : null;
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map boundsByName = destination$iv$iv;
        List list2 = descriptor.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getTypeParameters(...)");
        $this$groupBy$iv = list2;
        List list3 = declaration.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getTypeParameters(...)");
        Iterable other$iv = list3;
        boolean $i$f$zip = false;
        Iterator first$iv = $this$zip$iv.iterator();
        Iterator second$iv = other$iv.iterator();
        ArrayList<List> list$iv = new ArrayList<List>(Math.min(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$zip$iv, (int)10), kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)other$iv, (int)10)));
        while (first$iv.hasNext() && second$iv.hasNext()) {
            void $this$filterTo$iv$iv;
            void psiTypeParameter;
            void descriptorTypeParam;
            Object element$iv$iv;
            element$iv$iv = (KtTypeParameter)second$iv.next();
            list$iv$iv = (TypeParameterDescriptor)first$iv.next();
            ArrayList<List> arrayList = list$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)descriptorTypeParam.getName().toString(), (Object)psiTypeParameter.getName())) {
                return false;
            }
            List psiBounds = new ArrayList();
            CollectionsKt.addIfNotNull(psiBounds, psiTypeParameter.getExtendsBound());
            List list4 = (List)boundsByName.get(psiTypeParameter.getName());
            if (list4 != null) {
                Iterable $this$forEach$iv = list4;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    KtTypeConstraint it = (KtTypeConstraint)element$iv;
                    boolean bl3 = false;
                    CollectionsKt.addIfNotNull(psiBounds, it.getBoundTypeReference());
                }
            }
            List list5 = descriptorTypeParam.getUpperBounds();
            Intrinsics.checkNotNullExpressionValue((Object)list5, (String)"getUpperBounds(...)");
            Iterable $this$filter$iv = list5;
            boolean $i$f$filter = false;
            value$iv$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                KotlinType it = (KotlinType)element$iv$iv2;
                boolean bl4 = false;
                Intrinsics.checkNotNull((Object)it);
                if (!(!TypeUtilsKt.isNullableAny((KotlinType)it))) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            List expectedBounds = (List)destination$iv$iv2;
            if (psiBounds.size() != expectedBounds.size()) {
                return false;
            }
            Iterable $this$zip$iv2 = expectedBounds;
            boolean $i$f$zip2 = false;
            Iterator first$iv2 = $this$zip$iv2.iterator();
            Iterator second$iv2 = ((Iterable)psiBounds).iterator();
            ArrayList<Unit> list$iv2 = new ArrayList<Unit>(Math.min(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$zip$iv2, (int)10), kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)psiBounds, (int)10)));
            while (first$iv2.hasNext() && second$iv2.hasNext()) {
                void candidateBound;
                void expectedBound;
                Object element$iv$iv2;
                KtTypeReference bl3 = (KtTypeReference)second$iv2.next();
                element$iv$iv2 = (KotlinType)first$iv2.next();
                ArrayList<Unit> arrayList2 = list$iv2;
                boolean bl5 = false;
                Intrinsics.checkNotNull((Object)expectedBound);
                if (!INSTANCE.areTypesTheSame((KotlinType)expectedBound, (KtTypeReference)candidateBound)) {
                    return false;
                }
                arrayList2.add(Unit.INSTANCE);
            }
            arrayList.add(list$iv2);
        }
        return true;
    }

    private final boolean parametersMatch(KtCallableDeclaration declaration, CallableDescriptor original) {
        if (declaration.getValueParameters().size() != original.getValueParameters().size()) {
            return false;
        }
        List<KtParameter> list = declaration.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getValueParameters(...)");
        Iterable iterable = list;
        List list2 = original.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueParameters(...)");
        Iterable $this$forEach$iv = kotlin.collections.CollectionsKt.zip((Iterable)iterable, (Iterable)list2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinType kotlinType;
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            KtParameter ktParam = (KtParameter)pair.component1();
            ValueParameterDescriptor paramDesc = (ValueParameterDescriptor)pair.component2();
            boolean isVarargs = ktParam.isVarArg();
            if (isVarargs != (paramDesc.getVarargElementType() != null)) {
                return false;
            }
            if (isVarargs) {
                KotlinType kotlinType2 = paramDesc.getVarargElementType();
                kotlinType = kotlinType2;
                Intrinsics.checkNotNull((Object)kotlinType2);
            } else {
                KotlinType kotlinType3 = paramDesc.getType();
                kotlinType = kotlinType3;
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType3, (String)"getType(...)");
            }
            KtTypeReference ktTypeReference = ktParam.getTypeReference();
            Intrinsics.checkNotNull((Object)ktTypeReference);
            if (INSTANCE.areTypesTheSame(kotlinType, ktTypeReference)) continue;
            return false;
        }
        return true;
    }

    private final boolean receiverTypesMatch(KtTypeReference ktTypeReference, ReceiverParameterDescriptor receiverParameter) {
        if (ktTypeReference != null) {
            if (receiverParameter == null) {
                return false;
            }
            KotlinType kotlinType = receiverParameter.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            KotlinType receiverType = kotlinType;
            if (!this.areTypesTheSame(receiverType, ktTypeReference)) {
                return false;
            }
        } else if (receiverParameter != null) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean areTypesTheSame(KotlinType kotlinType, KtTypeReference ktTypeReference) {
        boolean bl;
        KtTypeElement ktTypeElement;
        block4: {
            void $this$any$iv;
            KtDeclarationModifierList[] ktDeclarationModifierListArray = ByDescriptorIndexerKt.getAllModifierLists(ktTypeReference);
            ktTypeElement = ktTypeReference.getTypeElement();
            boolean $i$f$any = false;
            int n = ((void)$this$any$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv;
                void it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!PsiUtilsKt.hasSuspendModifier((KtModifierList)it)) continue;
                bl = true;
                break block4;
            }
            bl = false;
        }
        boolean bl3 = bl;
        String string = ByDescriptorIndexerKt.getQualifiedName(ktTypeElement, bl3);
        if (string == null) {
            return false;
        }
        String qualifiedName = string;
        AbbreviatedType abbreviatedType = kotlinType instanceof AbbreviatedType ? (AbbreviatedType)kotlinType : null;
        ClassifierDescriptor classifierDescriptor = (abbreviatedType != null && (abbreviatedType = abbreviatedType.getAbbreviation()) != null ? (KotlinType)abbreviatedType : kotlinType).getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return false;
        }
        ClassifierDescriptor declarationDescriptor = classifierDescriptor;
        if (declarationDescriptor instanceof TypeParameterDescriptor) {
            return Intrinsics.areEqual((Object)((TypeParameterDescriptor)declarationDescriptor).getName().asString(), (Object)qualifiedName);
        }
        return Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)declarationDescriptor)).asString(), (Object)qualifiedName);
    }

    static {
        Logger logger = Logger.getInstance(INSTANCE.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

