/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.stub;

import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.io.StringRef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.stub.AnnotationWithArgs;
import org.jetbrains.kotlin.analysis.decompiler.stub.AnnotationWithTarget;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuilderContext;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuildingKt;
import org.jetbrains.kotlin.analysis.decompiler.stub.ContextReceiversListStubBuilder;
import org.jetbrains.kotlin.analysis.decompiler.stub.TypeClsStubBuilder;
import org.jetbrains.kotlin.analysis.decompiler.stub.TypeClsStubBuilderKt;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.constant.StringValue;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.metadata.deserialization.ProtoTypeTableUtilKt;
import org.jetbrains.kotlin.metadata.jvm.JvmProtoBuf;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.protobuf.MessageLite;
import org.jetbrains.kotlin.psi.KtProjectionKind;
import org.jetbrains.kotlin.psi.stubs.KotlinUserTypeStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinClassTypeBean;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinFlexibleTypeBean;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinModifierListStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinNameReferenceExpressionStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinParameterStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinPlaceHolderStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinStubBaseImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinTypeArgumentBean;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinTypeBean;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinTypeParameterStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinTypeParameterTypeBean;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinTypeProjectionStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinUserTypeStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.ModifierMaskUtils;
import org.jetbrains.kotlin.serialization.deserialization.AnnotatedCallableKind;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverUtilKt;
import org.jetbrains.kotlin.serialization.deserialization.ProtoContainer;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.utils.FunctionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J&\u0010\u000e\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J8\u0010\u0013\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00122\b\u0010\t\u001a\u0004\u0018\u00010\nJ*\u0010\u001c\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u001e\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\fH\u0002J0\u0010\"\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u00142\u0018\u0010#\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\n0$0\fJ6\u0010&\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\n0$0\f2\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u00142\f\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\fJ\u0018\u0010)\u001a\u00020\u00062\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020(H\u0002J2\u0010-\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010.\u001a\u00020%2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002JP\u0010/\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u00142\u0006\u0010\t\u001a\u00020\n2\u0014\b\u0002\u00100\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f012\u001a\b\u0002\u00102\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u0002040\f03J>\u00105\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u00142\u0006\u00106\u001a\u0002072\f\u00108\u001a\b\u0012\u0004\u0012\u0002090\f2\u0006\u0010:\u001a\u00020;2\b\b\u0002\u0010<\u001a\u00020=J\u0016\u0010>\u001a\b\u0012\u0004\u0012\u00020@0?2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010A\u001a\u0006\u0012\u0002\b\u00030\b2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\f\u0010B\u001a\u00020\u0017*\u00020\nH\u0002J\f\u0010C\u001a\u00020D*\u00020EH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/TypeClsStubBuilder;", "", "c", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/ClsStubBuilderContext;", "(Lorg/jetbrains/kotlin/analysis/decompiler/stub/ClsStubBuilderContext;)V", "createClassReferenceTypeStub", "", "parent", "Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinStubBaseImpl;", "type", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type;", "annotations", "", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/AnnotationWithTarget;", "createDefinitelyNotNullTypeStub", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "upperBoundType", "Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinTypeBean;", "createFunctionTypeStub", "Lcom/intellij/psi/stubs/StubElement;", "Lcom/intellij/psi/PsiElement;", "isExtensionFunctionType", "", "isSuspend", "numContextReceivers", "", "createKotlinTypeBean", "createTypeAnnotationStubs", "createTypeArgumentListStub", "typeStub", "Lorg/jetbrains/kotlin/psi/stubs/KotlinUserTypeStub;", "typeArgumentProtoList", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type$Argument;", "createTypeConstraintListStub", "protosForTypeConstraintList", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/name/Name;", "createTypeParameterListStub", "typeParameterProtoList", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$TypeParameter;", "createTypeParameterModifierListStub", "typeParameterStub", "Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinTypeParameterStubImpl;", "typeParameterProto", "createTypeParameterStub", "name", "createTypeReferenceStub", "additionalAnnotations", "Lkotlin/Function0;", "loadTypeAnnotations", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/AnnotationWithArgs;", "createValueParameterListStub", "callableProto", "Lorg/jetbrains/kotlin/protobuf/MessageLite;", "parameters", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$ValueParameter;", "container", "Lorg/jetbrains/kotlin/serialization/deserialization/ProtoContainer;", "callableKind", "Lorg/jetbrains/kotlin/serialization/deserialization/AnnotatedCallableKind;", "getTypeModifiersAsWritten", "", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "nullableTypeParent", "isDefaultUpperBound", "toProjectionKind", "Lorg/jetbrains/kotlin/psi/KtProjectionKind;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type$Argument$Projection;", "decompiler-to-stubs"})
@SourceDebugExtension(value={"SMAP\nTypeClsStubBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeClsStubBuilder.kt\norg/jetbrains/kotlin/analysis/decompiler/stub/TypeClsStubBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,456:1\n819#2:457\n847#2,2:458\n1549#2:460\n1620#2,3:461\n2624#2,3:464\n3190#2,10:467\n3190#2,10:477\n1549#2:488\n1620#2,3:489\n1855#2,2:492\n1549#2:494\n1620#2,3:495\n1549#2:498\n1620#2,3:499\n1#3:487\n*S KotlinDebug\n*F\n+ 1 TypeClsStubBuilder.kt\norg/jetbrains/kotlin/analysis/decompiler/stub/TypeClsStubBuilder\n*L\n51#1:457\n51#1:458,2\n56#1:460\n56#1:461,3\n115#1:464,3\n117#1:467,10\n121#1:477,10\n183#1:488\n183#1:489,3\n224#1:492,2\n259#1:494\n259#1:495,3\n401#1:498\n401#1:499,3\n*E\n"})
public final class TypeClsStubBuilder {
    @NotNull
    private final ClsStubBuilderContext c;

    public TypeClsStubBuilder(@NotNull ClsStubBuilderContext c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        this.c = c;
    }

    /*
     * WARNING - void declaration
     */
    public final void createTypeReferenceStub(@NotNull StubElement<? extends PsiElement> parent, @NotNull ProtoBuf.Type type, @NotNull Function0<? extends List<AnnotationWithTarget>> additionalAnnotations, @NotNull Function1<? super ProtoBuf.Type, ? extends List<AnnotationWithArgs>> loadTypeAnnotations) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter(parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(additionalAnnotations, (String)"additionalAnnotations");
        Intrinsics.checkNotNullParameter(loadTypeAnnotations, (String)"loadTypeAnnotations");
        ProtoBuf.Type abbreviatedType = ProtoTypeTableUtilKt.abbreviatedType(type, this.c.getTypeTable());
        if (abbreviatedType != null) {
            TypeClsStubBuilder.createTypeReferenceStub$default(this, parent, abbreviatedType, additionalAnnotations, null, 8, null);
            return;
        }
        KotlinPlaceHolderStubImpl typeReference = new KotlinPlaceHolderStubImpl((StubElement)parent, KtStubElementTypes.TYPE_REFERENCE);
        List allAnnotationsInType = (List)loadTypeAnnotations.invoke((Object)type);
        Iterable $this$filterNot$iv = allAnnotationsInType;
        boolean $i$f$filterNot22 = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            AnnotationWithArgs it = (AnnotationWithArgs)element$iv$iv;
            boolean bl = false;
            boolean isTopLevelClass = !it.getClassId().isNestedClass();
            if (isTopLevelClass && TypeClsStubBuilderKt.access$getANNOTATIONS_NOT_LOADED_FOR_TYPES$p().contains(it.getClassId().asSingleFqName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List annotations = (List)destination$iv$iv;
        Iterable $i$f$filterNot22 = annotations;
        Collection collection = (Collection)additionalAnnotations.invoke();
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AnnotationWithArgs bl = (AnnotationWithArgs)item$iv$iv;
            Collection collection2 = destination$iv$iv2;
            boolean bl2 = false;
            collection2.add(new AnnotationWithTarget((AnnotationWithArgs)it, null));
        }
        List allAnnotations = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv2));
        if (type.hasClassName() || type.hasTypeAliasName()) {
            this.createClassReferenceTypeStub(typeReference, type, allAnnotations);
        } else if (type.hasTypeParameter()) {
            this.createTypeParameterStub(typeReference, type, this.c.getTypeParameters().get(type.getTypeParameter()), allAnnotations);
        } else if (type.hasTypeParameterName()) {
            this.createTypeParameterStub(typeReference, type, NameResolverUtilKt.getName(this.c.getNameResolver(), type.getTypeParameterName()), allAnnotations);
        } else {
            FunctionsKt.doNothing();
        }
    }

    public static /* synthetic */ void createTypeReferenceStub$default(TypeClsStubBuilder typeClsStubBuilder, StubElement stubElement, ProtoBuf.Type type, Function0 function0, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function0 = createTypeReferenceStub.1.INSTANCE;
        }
        if ((n & 8) != 0) {
            function1 = (Function1)new Function1<ProtoBuf.Type, List<? extends AnnotationWithArgs>>(typeClsStubBuilder){
                final /* synthetic */ TypeClsStubBuilder this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final List<AnnotationWithArgs> invoke(@NotNull ProtoBuf.Type it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return TypeClsStubBuilder.access$getC$p(this.this$0).getComponents().getAnnotationLoader().loadTypeAnnotations(it, TypeClsStubBuilder.access$getC$p(this.this$0).getNameResolver());
                }
            };
        }
        typeClsStubBuilder.createTypeReferenceStub((StubElement<? extends PsiElement>)stubElement, type, (Function0<? extends List<AnnotationWithTarget>>)function0, (Function1<? super ProtoBuf.Type, ? extends List<AnnotationWithArgs>>)function1);
    }

    private final KotlinStubBaseImpl<?> nullableTypeParent(KotlinStubBaseImpl<?> parent, ProtoBuf.Type type) {
        return type.getNullable() ? (KotlinStubBaseImpl)new KotlinPlaceHolderStubImpl((StubElement)parent, KtStubElementTypes.NULLABLE_TYPE) : parent;
    }

    private final void createTypeParameterStub(KotlinStubBaseImpl<?> parent, ProtoBuf.Type type, Name name, List<AnnotationWithTarget> annotations) {
        KotlinTypeBean kotlinTypeBean;
        this.createTypeAnnotationStubs(parent, type, annotations);
        if (type.hasFlexibleTypeCapabilitiesId()) {
            ProtoBuf.Type type2 = ProtoTypeTableUtilKt.flexibleUpperBound(type, this.c.getTypeTable());
            Intrinsics.checkNotNull((Object)type2);
            kotlinTypeBean = this.createKotlinTypeBean(type2);
        } else {
            kotlinTypeBean = null;
        }
        KotlinTypeBean upperBoundType = kotlinTypeBean;
        ClassId classId = ClassId.topLevel(FqName.topLevel(name));
        Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"topLevel(...)");
        ClassId typeParameterClassId = classId;
        Boolean bl = Flags.DEFINITELY_NOT_NULL_TYPE.get(type.getFlags());
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
        if (bl.booleanValue()) {
            this.createDefinitelyNotNullTypeStub(parent, typeParameterClassId, upperBoundType);
        } else {
            KotlinStubBaseImpl<?> nullableParentWrapper = this.nullableTypeParent(parent, type);
            ClsStubBuildingKt.createStubForTypeName$default(typeParameterClassId, (StubElement)nullableParentWrapper, (Function1)new Function1<Integer, KotlinTypeBean>(upperBoundType){
                final /* synthetic */ KotlinTypeBean $upperBoundType;
                {
                    this.$upperBoundType = $upperBoundType;
                    super(1);
                }

                @Nullable
                public final KotlinTypeBean invoke(int it) {
                    return this.$upperBoundType;
                }
            }, null, 8, null);
        }
    }

    private final void createDefinitelyNotNullTypeStub(KotlinStubBaseImpl<?> parent, ClassId classId, KotlinTypeBean upperBoundType) {
        KotlinPlaceHolderStubImpl intersectionType = new KotlinPlaceHolderStubImpl((StubElement)parent, KtStubElementTypes.INTERSECTION_TYPE);
        KotlinPlaceHolderStubImpl leftReference = new KotlinPlaceHolderStubImpl(intersectionType, KtStubElementTypes.TYPE_REFERENCE);
        ClsStubBuildingKt.createStubForTypeName$default(classId, leftReference, (Function1)new Function1<Integer, KotlinTypeBean>(upperBoundType){
            final /* synthetic */ KotlinTypeBean $upperBoundType;
            {
                this.$upperBoundType = $upperBoundType;
                super(1);
            }

            @Nullable
            public final KotlinTypeBean invoke(int it) {
                return this.$upperBoundType;
            }
        }, null, 8, null);
        KotlinPlaceHolderStubImpl rightReference = new KotlinPlaceHolderStubImpl(intersectionType, KtStubElementTypes.TYPE_REFERENCE);
        KotlinUserTypeStubImpl userType = new KotlinUserTypeStubImpl(rightReference, null, 2, null);
        StubElement stubElement = userType;
        Name name = StandardNames.FqNames.any.shortName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"shortName(...)");
        new KotlinNameReferenceExpressionStubImpl(stubElement, ClsStubBuildingKt.ref(name), true);
    }

    /*
     * Unable to fully structure code
     */
    private final void createClassReferenceTypeStub(KotlinStubBaseImpl<?> parent, ProtoBuf.Type type, List<AnnotationWithTarget> annotations) {
        block17: {
            if (type.hasFlexibleTypeCapabilitiesId() && Intrinsics.areEqual((Object)(id = this.c.getNameResolver().getString(type.getFlexibleTypeCapabilitiesId())), (Object)"kotlin.DynamicType")) {
                new KotlinPlaceHolderStubImpl<T>((StubElement)this.nullableTypeParent(parent, type), KtStubElementTypes.DYNAMIC_TYPE);
                return;
            }
            v0 = id = type.hasClassName() != false || type.hasTypeAliasName() != false;
            if (_Assertions.ENABLED && !id) {
                $i$a$-assert-TypeClsStubBuilder$createClassReferenceTypeStub$1 = false;
                $i$a$-assert-TypeClsStubBuilder$createClassReferenceTypeStub$1 = "Class reference stub must have either class or type alias name";
                throw new AssertionError((Object)$i$a$-assert-TypeClsStubBuilder$createClassReferenceTypeStub$1);
            }
            classId = NameResolverUtilKt.getClassId(this.c.getNameResolver(), type.hasClassName() != false ? type.getClassName() : type.getTypeAliasName());
            if (!FunctionTypesKt.isBuiltinFunctionClass((ClassId)classId)) ** GOTO lbl-1000
            v1 = type.getArgumentList();
            Intrinsics.checkNotNullExpressionValue(v1, (String)"getArgumentList(...)");
            $this$none$iv = v1;
            $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                v2 = true;
            } else {
                for (T element$iv : $this$none$iv) {
                    it = (ProtoBuf.Type.Argument)element$iv;
                    $i$a$-none-TypeClsStubBuilder$createClassReferenceTypeStub$shouldBuildAsFunctionType$1 = false;
                    if (!(it.getProjection() == ProtoBuf.Type.Argument.Projection.STAR)) continue;
                    v2 = false;
                    break block17;
                }
                v2 = true;
            }
        }
        if (v2) {
            v3 = true;
        } else lbl-1000:
        // 2 sources

        {
            v3 = shouldBuildAsFunctionType = false;
        }
        if (shouldBuildAsFunctionType) {
            $this$partition$iv = annotations;
            $i$f$partition = false;
            first$iv = new ArrayList<T>();
            second$iv = new ArrayList<T>();
            for (T element$iv : $this$partition$iv) {
                it = (AnnotationWithTarget)element$iv;
                $i$a$-partition-TypeClsStubBuilder$createClassReferenceTypeStub$2 = false;
                if (Intrinsics.areEqual((Object)it.getAnnotationWithArgs().getClassId().asSingleFqName(), (Object)StandardNames.FqNames.extensionFunctionType)) {
                    first$iv.add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            $this$none$iv = new Pair(first$iv, second$iv);
            extensionAnnotations = (List)$this$none$iv.component1();
            notExtensionAnnotations = (List)$this$none$iv.component2();
            $this$partition$iv = notExtensionAnnotations;
            $i$f$partition = false;
            first$iv = new ArrayList<T>();
            second$iv = new ArrayList<T>();
            for (T element$iv : $this$partition$iv) {
                it = (AnnotationWithTarget)element$iv;
                $i$a$-partition-TypeClsStubBuilder$createClassReferenceTypeStub$3 = false;
                if (Intrinsics.areEqual((Object)it.getAnnotationWithArgs().getClassId().asSingleFqName(), (Object)StandardNames.FqNames.contextFunctionTypeParams)) {
                    first$iv.add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            var9_16 = new Pair(first$iv, second$iv);
            contextReceiverAnnotations = (List)var9_16.component1();
            otherAnnotations = (List)var9_16.component2();
            isExtension = ((Collection)extensionAnnotations).isEmpty() == false;
            v4 = Flags.SUSPEND_TYPE.get(type.getFlags());
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"get(...)");
            isSuspend = v4;
            if (isSuspend) {
                wrapper = this.nullableTypeParent(parent, type);
                this.createTypeAnnotationStubs(wrapper, type, otherAnnotations);
                v5 = wrapper;
            } else {
                this.createTypeAnnotationStubs(parent, type, otherAnnotations);
                v5 = nullableWrapper = this.nullableTypeParent(parent, type);
            }
            if (contextReceiverAnnotations.isEmpty()) {
                v6 = 0;
            } else {
                block18: {
                    v7 = type.getExtension(JvmProtoBuf.typeAnnotation);
                    Intrinsics.checkNotNullExpressionValue(v7, (String)"getExtension(...)");
                    var18_32 = v7;
                    for (T var20_34 : var18_32) {
                        it = (ProtoBuf.Annotation)var20_34;
                        $i$a$-find-TypeClsStubBuilder$createClassReferenceTypeStub$numContextReceivers$argument$1 = false;
                        if (!Intrinsics.areEqual((Object)NameResolverUtilKt.getClassId(this.c.getNameResolver(), it.getId()).asSingleFqName(), (Object)StandardNames.FqNames.contextFunctionTypeParams)) continue;
                        v8 = var20_34;
                        break block18;
                    }
                    v8 = null;
                }
                Intrinsics.checkNotNull(v8);
                argument = ((ProtoBuf.Annotation)v8).getArgument(0);
                v6 = (int)argument.getValue().getIntValue();
            }
            numContextReceivers = v6;
            this.createFunctionTypeStub((StubElement<? extends PsiElement>)((StubElement)nullableWrapper), type, isExtension, isSuspend, numContextReceivers);
            return;
        }
        this.createTypeAnnotationStubs(parent, type, annotations);
        outerTypeChain = SequencesKt.toList((Sequence)SequencesKt.generateSequence((Object)type, (Function1)((Function1)new Function1<ProtoBuf.Type, ProtoBuf.Type>(this){
            final /* synthetic */ TypeClsStubBuilder this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final ProtoBuf.Type invoke(@NotNull ProtoBuf.Type it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return ProtoTypeTableUtilKt.outerType(it, TypeClsStubBuilder.access$getC$p(this.this$0).getTypeTable());
            }
        })));
        ClsStubBuildingKt.createStubForTypeName(classId, (StubElement<? extends PsiElement>)((StubElement)this.nullableTypeParent(parent, type)), (Function1<? super Integer, ? extends KotlinTypeBean>)((Function1)new Function1<Integer, KotlinTypeBean>(this, type, (List<ProtoBuf.Type>)outerTypeChain){
            final /* synthetic */ TypeClsStubBuilder this$0;
            final /* synthetic */ ProtoBuf.Type $type;
            final /* synthetic */ List<ProtoBuf.Type> $outerTypeChain;
            {
                this.this$0 = $receiver;
                this.$type = $type;
                this.$outerTypeChain = $outerTypeChain;
                super(1);
            }

            @Nullable
            public final KotlinTypeBean invoke(int level) {
                KotlinTypeBean kotlinTypeBean;
                if (level == 0) {
                    kotlinTypeBean = this.this$0.createKotlinTypeBean(ProtoTypeTableUtilKt.flexibleUpperBound(this.$type, TypeClsStubBuilder.access$getC$p(this.this$0).getTypeTable()));
                } else {
                    ProtoBuf.Type type = (ProtoBuf.Type)CollectionsKt.getOrNull(this.$outerTypeChain, (int)level);
                    kotlinTypeBean = this.this$0.createKotlinTypeBean(type != null ? ProtoTypeTableUtilKt.flexibleUpperBound(type, TypeClsStubBuilder.access$getC$p(this.this$0).getTypeTable()) : null);
                }
                return kotlinTypeBean;
            }
        }), (Function2<? super KotlinUserTypeStub, ? super Integer, Unit>)((Function2)new Function2<KotlinUserTypeStub, Integer, Unit>((List<ProtoBuf.Type>)outerTypeChain, this){
            final /* synthetic */ List<ProtoBuf.Type> $outerTypeChain;
            final /* synthetic */ TypeClsStubBuilder this$0;
            {
                this.$outerTypeChain = $outerTypeChain;
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull KotlinUserTypeStub userTypeStub, int index) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)userTypeStub, (String)"userTypeStub");
                    ProtoBuf.Type type = (ProtoBuf.Type)CollectionsKt.getOrNull(this.$outerTypeChain, (int)index);
                    if (type == null) break block0;
                    ProtoBuf.Type type2 = type;
                    TypeClsStubBuilder typeClsStubBuilder = this.this$0;
                    ProtoBuf.Type it = type2;
                    boolean bl = false;
                    List<ProtoBuf.Type.Argument> list = it.getArgumentList();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getArgumentList(...)");
                    TypeClsStubBuilder.access$createTypeArgumentListStub(typeClsStubBuilder, userTypeStub, list);
                }
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final KotlinTypeBean createKotlinTypeBean(@Nullable ProtoBuf.Type type) {
        KotlinTypeMarker kotlinTypeMarker;
        if (type == null) {
            return null;
        }
        Boolean bl = Flags.DEFINITELY_NOT_NULL_TYPE.get(type.getFlags());
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
        boolean definitelyNotNull = bl;
        if (type.hasTypeParameter()) {
            String string = this.c.getTypeParameters().get(type.getTypeParameter()).asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            KotlinTypeParameterTypeBean lowerBound = new KotlinTypeParameterTypeBean(string, type.getNullable(), definitelyNotNull);
            kotlinTypeMarker = lowerBound;
        } else if (type.hasTypeParameterName()) {
            kotlinTypeMarker = new KotlinTypeParameterTypeBean(this.c.getNameResolver().getString(type.getTypeParameterName()), type.getNullable(), definitelyNotNull);
        } else {
            void $this$mapTo$iv$iv;
            ClassId classId = NameResolverUtilKt.getClassId(this.c.getNameResolver(), type.hasClassName() ? type.getClassName() : type.getTypeAliasName());
            List<ProtoBuf.Type.Argument> list = type.getArgumentList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getArgumentList(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                KotlinTypeBean kotlinTypeBean;
                void argument2;
                ProtoBuf.Type.Argument argument3 = (ProtoBuf.Type.Argument)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                ProtoBuf.Type.Argument.Projection projection = argument2.getProjection();
                Intrinsics.checkNotNullExpressionValue((Object)projection, (String)"getProjection(...)");
                KtProjectionKind kind = this.toProjectionKind(projection);
                if (kind == KtProjectionKind.STAR) {
                    kotlinTypeBean = null;
                } else {
                    Intrinsics.checkNotNull((Object)argument2);
                    kotlinTypeBean = this.createKotlinTypeBean(ProtoTypeTableUtilKt.type((ProtoBuf.Type.Argument)argument2, this.c.getTypeTable()));
                }
                collection.add(new KotlinTypeArgumentBean(kind, kotlinTypeBean));
            }
            List arguments = (List)destination$iv$iv;
            kotlinTypeMarker = new KotlinClassTypeBean(classId, arguments, type.getNullable());
        }
        KotlinTypeMarker lowerBound = kotlinTypeMarker;
        KotlinTypeBean upperBoundBean = this.createKotlinTypeBean(ProtoTypeTableUtilKt.flexibleUpperBound(type, this.c.getTypeTable()));
        return upperBoundBean != null ? (KotlinTypeBean)new KotlinFlexibleTypeBean((KotlinTypeBean)lowerBound, upperBoundBean) : (KotlinTypeBean)lowerBound;
    }

    private final void createTypeAnnotationStubs(KotlinStubBaseImpl<?> parent, ProtoBuf.Type type, List<AnnotationWithTarget> annotations) {
        Set<KtModifierKeywordToken> typeModifiers = this.getTypeModifiersAsWritten(type);
        if (annotations.isEmpty() && typeModifiers.isEmpty()) {
            return;
        }
        long typeModifiersMask2 = ModifierMaskUtils.computeMask((Function1<? super KtModifierKeywordToken, Boolean>)((Function1)new Function1<KtModifierKeywordToken, Boolean>(typeModifiers){
            final /* synthetic */ Set<KtModifierKeywordToken> $typeModifiers;
            {
                this.$typeModifiers = $typeModifiers;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull KtModifierKeywordToken it) {
                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                return this.$typeModifiers.contains((Object)((Object)it));
            }
        }));
        KotlinModifierListStubImpl modifiersList = new KotlinModifierListStubImpl((StubElement)parent, typeModifiersMask2, KtStubElementTypes.MODIFIER_LIST);
        ClsStubBuildingKt.createTargetedAnnotationStubs(annotations, modifiersList);
    }

    private final Set<KtModifierKeywordToken> getTypeModifiersAsWritten(ProtoBuf.Type type) {
        if (!type.hasClassName() && !type.hasTypeAliasName()) {
            return SetsKt.emptySet();
        }
        HashSet<KtModifierKeywordToken> result2 = new HashSet<KtModifierKeywordToken>();
        Boolean bl = Flags.SUSPEND_TYPE.get(type.getFlags());
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
        if (bl.booleanValue()) {
            result2.add(KtTokens.SUSPEND_KEYWORD);
        }
        return result2;
    }

    private final void createTypeArgumentListStub(KotlinUserTypeStub typeStub, List<ProtoBuf.Type.Argument> typeArgumentProtoList) {
        if (typeArgumentProtoList.isEmpty()) {
            return;
        }
        KotlinPlaceHolderStubImpl typeArgumentsListStub = new KotlinPlaceHolderStubImpl(typeStub, KtStubElementTypes.TYPE_ARGUMENT_LIST);
        Iterable $this$forEach$iv = typeArgumentProtoList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProtoBuf.Type.Argument typeArgumentProto = (ProtoBuf.Type.Argument)element$iv;
            boolean bl = false;
            ProtoBuf.Type.Argument.Projection projection = typeArgumentProto.getProjection();
            Intrinsics.checkNotNullExpressionValue((Object)projection, (String)"getProjection(...)");
            KtProjectionKind projectionKind = this.toProjectionKind(projection);
            KotlinTypeProjectionStubImpl typeProjection = new KotlinTypeProjectionStubImpl(typeArgumentsListStub, projectionKind.ordinal());
            if (projectionKind == KtProjectionKind.STAR) continue;
            KtSingleValueToken ktSingleValueToken = projectionKind.getToken();
            KtModifierKeywordToken modifierKeywordToken = ktSingleValueToken instanceof KtModifierKeywordToken ? (KtModifierKeywordToken)ktSingleValueToken : null;
            ClsStubBuildingKt.createModifierListStub((StubElement<? extends PsiElement>)((StubElement)typeProjection), CollectionsKt.listOfNotNull((Object)((Object)modifierKeywordToken)));
            StubElement stubElement = typeProjection;
            ProtoBuf.Type type = ProtoTypeTableUtilKt.type(typeArgumentProto, this.c.getTypeTable());
            Intrinsics.checkNotNull((Object)type);
            TypeClsStubBuilder.createTypeReferenceStub$default(this, stubElement, type, null, null, 12, null);
        }
    }

    private final KtProjectionKind toProjectionKind(ProtoBuf.Type.Argument.Projection $this$toProjectionKind) {
        KtProjectionKind ktProjectionKind;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toProjectionKind.ordinal()]) {
            case 1: {
                ktProjectionKind = KtProjectionKind.IN;
                break;
            }
            case 2: {
                ktProjectionKind = KtProjectionKind.OUT;
                break;
            }
            case 3: {
                ktProjectionKind = KtProjectionKind.NONE;
                break;
            }
            case 4: {
                ktProjectionKind = KtProjectionKind.STAR;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return ktProjectionKind;
    }

    /*
     * WARNING - void declaration
     */
    private final void createFunctionTypeStub(StubElement<? extends PsiElement> parent, ProtoBuf.Type type, boolean isExtensionFunctionType, boolean isSuspend, int numContextReceivers) {
        Object destination$iv$iv;
        List<ProtoBuf.Type.Argument> typeArgumentList = type.getArgumentList();
        KotlinPlaceHolderStubImpl functionType = new KotlinPlaceHolderStubImpl((StubElement)parent, KtStubElementTypes.FUNCTION_TYPE);
        int processedTypes = 0;
        if (numContextReceivers != 0) {
            Object object;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = typeArgumentList.subList(processedTypes, processedTypes + numContextReceivers);
            StubElement stubElement = functionType;
            ContextReceiversListStubBuilder contextReceiversListStubBuilder = new ContextReceiversListStubBuilder(this.c);
            boolean $i$f$map = false;
            void var11_15 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ProtoBuf.Type.Argument argument2 = (ProtoBuf.Type.Argument)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                ProtoBuf.Type type2 = ProtoTypeTableUtilKt.type((ProtoBuf.Type.Argument)it, this.c.getTypeTable());
                Intrinsics.checkNotNull((Object)type2);
                object.add(type2);
            }
            object = (List)destination$iv$iv;
            contextReceiversListStubBuilder.createContextReceiverStubs(stubElement, (List<ProtoBuf.Type>)object);
            processedTypes += numContextReceivers;
        }
        if (isExtensionFunctionType) {
            KotlinPlaceHolderStubImpl functionTypeReceiverStub = new KotlinPlaceHolderStubImpl(functionType, KtStubElementTypes.FUNCTION_TYPE_RECEIVER);
            ProtoBuf.Type.Argument argument3 = typeArgumentList.get(processedTypes);
            Intrinsics.checkNotNullExpressionValue((Object)argument3, (String)"get(...)");
            ProtoBuf.Type type3 = ProtoTypeTableUtilKt.type(argument3, this.c.getTypeTable());
            Intrinsics.checkNotNull((Object)type3);
            ProtoBuf.Type receiverTypeProto = type3;
            TypeClsStubBuilder.createTypeReferenceStub$default(this, functionTypeReceiverStub, receiverTypeProto, null, null, 12, null);
            ++processedTypes;
        }
        KotlinPlaceHolderStubImpl parameterList2 = new KotlinPlaceHolderStubImpl(functionType, KtStubElementTypes.VALUE_PARAMETER_LIST);
        List<ProtoBuf.Type.Argument> typeArgumentsWithoutReceiverAndReturnType = typeArgumentList.subList(processedTypes, typeArgumentList.size() - 1);
        ProtoBuf.Type suspendParameterType = null;
        destination$iv$iv = typeArgumentsWithoutReceiverAndReturnType.iterator();
        int n = 0;
        while (destination$iv$iv.hasNext()) {
            ProtoBuf.Type parameterType;
            int index = n++;
            ProtoBuf.Type.Argument argument4 = (ProtoBuf.Type.Argument)destination$iv$iv.next();
            Intrinsics.checkNotNull((Object)argument4);
            Intrinsics.checkNotNull((Object)ProtoTypeTableUtilKt.type(argument4, this.c.getTypeTable()));
            if (isSuspend && index == typeArgumentsWithoutReceiverAndReturnType.size() - 1 && parameterType.hasClassName() && parameterType.getArgumentCount() == 1) {
                FqName fqName;
                boolean bl;
                ClassId classId = NameResolverUtilKt.getClassId(this.c.getNameResolver(), parameterType.getClassName());
                Intrinsics.checkNotNullExpressionValue((Object)classId.asSingleFqName(), (String)"asSingleFqName(...)");
                boolean bl2 = bl = Intrinsics.areEqual((Object)fqName, (Object)new FqName("kotlin.coroutines.Continuation")) || Intrinsics.areEqual((Object)fqName, (Object)new FqName("kotlin.coroutines.experimental.Continuation"));
                if (_Assertions.ENABLED && !bl) {
                    boolean bl3 = false;
                    String string = "Last parameter type of suspend function must be Continuation, but it is " + fqName;
                    throw new AssertionError((Object)string);
                }
                suspendParameterType = parameterType;
                continue;
            }
            List<AnnotationWithArgs> annotations = this.c.getComponents().getAnnotationLoader().loadTypeAnnotations(parameterType, this.c.getNameResolver());
            KotlinParameterStubImpl parameter = new KotlinParameterStubImpl(parameterList2, null, null, false, false, false, TypeClsStubBuilder.createFunctionTypeStub$getFunctionTypeParameterName(annotations));
            TypeClsStubBuilder.createTypeReferenceStub$default(this, (StubElement)parameter, parameterType, null, (Function1)new Function1<ProtoBuf.Type, List<? extends AnnotationWithArgs>>(annotations){
                final /* synthetic */ List<AnnotationWithArgs> $annotations;
                {
                    this.$annotations = $annotations;
                    super(1);
                }

                @NotNull
                public final List<AnnotationWithArgs> invoke(@NotNull ProtoBuf.Type it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$annotations;
                }
            }, 4, null);
        }
        if (suspendParameterType == null) {
            Intrinsics.checkNotNull(typeArgumentList);
            Object object = CollectionsKt.last(typeArgumentList);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"last(...)");
            ProtoBuf.Type type4 = ProtoTypeTableUtilKt.type((ProtoBuf.Type.Argument)object, this.c.getTypeTable());
            Intrinsics.checkNotNull((Object)type4);
            ProtoBuf.Type returnType = type4;
            TypeClsStubBuilder.createTypeReferenceStub$default(this, functionType, returnType, null, null, 12, null);
        } else {
            ProtoBuf.Type.Argument argument5 = suspendParameterType.getArgument(0);
            Intrinsics.checkNotNullExpressionValue((Object)argument5, (String)"getArgument(...)");
            ProtoBuf.Type type5 = ProtoTypeTableUtilKt.type(argument5, this.c.getTypeTable());
            Intrinsics.checkNotNull((Object)type5);
            ProtoBuf.Type continuationArgumentType = type5;
            TypeClsStubBuilder.createTypeReferenceStub$default(this, functionType, continuationArgumentType, null, null, 12, null);
        }
    }

    public final void createValueParameterListStub(@NotNull StubElement<? extends PsiElement> parent, @NotNull MessageLite callableProto, @NotNull List<ProtoBuf.ValueParameter> parameters, @NotNull ProtoContainer container, @NotNull AnnotatedCallableKind callableKind) {
        Intrinsics.checkNotNullParameter(parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)callableProto, (String)"callableProto");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)((Object)callableKind), (String)"callableKind");
        KotlinPlaceHolderStubImpl parameterListStub = new KotlinPlaceHolderStubImpl((StubElement)parent, KtStubElementTypes.VALUE_PARAMETER_LIST);
        Iterator<ProtoBuf.ValueParameter> iterator2 = parameters.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            List<AnnotationWithArgs> parameterAnnotations;
            int index = n++;
            ProtoBuf.ValueParameter valueParameterProto = iterator2.next();
            Name name = NameResolverUtilKt.getName(this.c.getNameResolver(), valueParameterProto.getName());
            Name paramName = Intrinsics.areEqual((Object)name, (Object)SpecialNames.IMPLICIT_SET_PARAMETER) ? StandardNames.DEFAULT_VALUE_PARAMETER : name;
            Boolean bl = Flags.DECLARES_DEFAULT_VALUE.get(valueParameterProto.getFlags());
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
            boolean hasDefaultValue = bl;
            StringRef stringRef = ClsStubBuildingKt.ref(paramName);
            KotlinParameterStubImpl parameterStub = new KotlinParameterStubImpl(parameterListStub, null, stringRef, false, false, hasDefaultValue, null, 64, null);
            ProtoBuf.Type varargElementType = ProtoTypeTableUtilKt.varargElementType(valueParameterProto, this.c.getTypeTable());
            ProtoBuf.Type type = varargElementType;
            if (type == null) {
                type = ProtoTypeTableUtilKt.type(valueParameterProto, this.c.getTypeTable());
            }
            ProtoBuf.Type typeProto = type;
            ArrayList<KtModifierKeywordToken> modifiers = new ArrayList<KtModifierKeywordToken>();
            if (varargElementType != null) {
                modifiers.add(KtTokens.VARARG_KEYWORD);
            }
            Boolean bl2 = Flags.IS_CROSSINLINE.get(valueParameterProto.getFlags());
            Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"get(...)");
            if (bl2.booleanValue()) {
                modifiers.add(KtTokens.CROSSINLINE_KEYWORD);
            }
            Boolean bl3 = Flags.IS_NOINLINE.get(valueParameterProto.getFlags());
            Intrinsics.checkNotNullExpressionValue((Object)bl3, (String)"get(...)");
            if (bl3.booleanValue()) {
                modifiers.add(KtTokens.NOINLINE_KEYWORD);
            }
            KotlinModifierListStubImpl modifierList2 = ClsStubBuildingKt.createModifierListStub((StubElement<? extends PsiElement>)((StubElement)parameterStub), (Collection<KtModifierKeywordToken>)modifiers);
            Boolean bl4 = Flags.HAS_ANNOTATIONS.get(valueParameterProto.getFlags());
            Intrinsics.checkNotNullExpressionValue((Object)bl4, (String)"get(...)");
            if (bl4.booleanValue() && !((Collection)(parameterAnnotations = this.c.getComponents().getAnnotationLoader().loadValueParameterAnnotations(container, callableProto, callableKind, index, valueParameterProto))).isEmpty()) {
                KotlinModifierListStubImpl kotlinModifierListStubImpl = modifierList2;
                if (kotlinModifierListStubImpl == null) {
                    kotlinModifierListStubImpl = ClsStubBuildingKt.createEmptyModifierListStub(parameterStub);
                }
                ClsStubBuildingKt.createAnnotationStubs(parameterAnnotations, kotlinModifierListStubImpl);
            }
            TypeClsStubBuilder.createTypeReferenceStub$default(this, (StubElement)parameterStub, typeProto, null, null, 12, null);
            if (!hasDefaultValue) continue;
            new KotlinNameReferenceExpressionStubImpl((StubElement)parameterStub, StringRef.fromString((String)"COMPILED_CODE"));
        }
    }

    public static /* synthetic */ void createValueParameterListStub$default(TypeClsStubBuilder typeClsStubBuilder, StubElement stubElement, MessageLite messageLite, List list, ProtoContainer protoContainer, AnnotatedCallableKind annotatedCallableKind, int n, Object object) {
        if ((n & 0x10) != 0) {
            annotatedCallableKind = ClsStubBuildingKt.getAnnotatedCallableKind(messageLite);
        }
        typeClsStubBuilder.createValueParameterListStub((StubElement<? extends PsiElement>)stubElement, messageLite, list, protoContainer, annotatedCallableKind);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<Name, ProtoBuf.Type>> createTypeParameterListStub(@NotNull StubElement<? extends PsiElement> parent, @NotNull List<ProtoBuf.TypeParameter> typeParameterProtoList) {
        Intrinsics.checkNotNullParameter(parent, (String)"parent");
        Intrinsics.checkNotNullParameter(typeParameterProtoList, (String)"typeParameterProtoList");
        if (typeParameterProtoList.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        KotlinPlaceHolderStubImpl typeParameterListStub = new KotlinPlaceHolderStubImpl((StubElement)parent, KtStubElementTypes.TYPE_PARAMETER_LIST);
        ArrayList protosForTypeConstraintList = new ArrayList();
        for (ProtoBuf.TypeParameter proto : typeParameterProtoList) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Name name = NameResolverUtilKt.getName(this.c.getNameResolver(), proto.getName());
            KotlinTypeParameterStubImpl typeParameterStub = new KotlinTypeParameterStubImpl(typeParameterListStub, ClsStubBuildingKt.ref(name), proto.getVariance() == ProtoBuf.TypeParameter.Variance.IN, proto.getVariance() == ProtoBuf.TypeParameter.Variance.OUT);
            this.createTypeParameterModifierListStub(typeParameterStub, proto);
            List<ProtoBuf.Type> upperBoundProtos = ProtoTypeTableUtilKt.upperBounds(proto, this.c.getTypeTable());
            if (!(!((Collection)upperBoundProtos).isEmpty())) continue;
            ProtoBuf.Type upperBound = (ProtoBuf.Type)CollectionsKt.first(upperBoundProtos);
            if (!this.isDefaultUpperBound(upperBound)) {
                TypeClsStubBuilder.createTypeReferenceStub$default(this, (StubElement)typeParameterStub, upperBound, null, null, 12, null);
            }
            Iterable iterable = CollectionsKt.drop((Iterable)upperBoundProtos, (int)1);
            ArrayList arrayList = protosForTypeConstraintList;
            boolean $i$f$map = false;
            void var13_13 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ProtoBuf.Type type = (ProtoBuf.Type)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new Pair((Object)name, (Object)it));
            }
            arrayList.addAll((List)destination$iv$iv);
        }
        return protosForTypeConstraintList;
    }

    public final void createTypeConstraintListStub(@NotNull StubElement<? extends PsiElement> parent, @NotNull List<Pair<Name, ProtoBuf.Type>> protosForTypeConstraintList) {
        Intrinsics.checkNotNullParameter(parent, (String)"parent");
        Intrinsics.checkNotNullParameter(protosForTypeConstraintList, (String)"protosForTypeConstraintList");
        if (protosForTypeConstraintList.isEmpty()) {
            return;
        }
        KotlinPlaceHolderStubImpl typeConstraintListStub = new KotlinPlaceHolderStubImpl((StubElement)parent, KtStubElementTypes.TYPE_CONSTRAINT_LIST);
        for (Pair<Name, ProtoBuf.Type> pair : protosForTypeConstraintList) {
            Name name = (Name)pair.component1();
            ProtoBuf.Type type = (ProtoBuf.Type)pair.component2();
            KotlinPlaceHolderStubImpl typeConstraintStub = new KotlinPlaceHolderStubImpl(typeConstraintListStub, KtStubElementTypes.TYPE_CONSTRAINT);
            new KotlinNameReferenceExpressionStubImpl(typeConstraintStub, ClsStubBuildingKt.ref(name));
            TypeClsStubBuilder.createTypeReferenceStub$default(this, typeConstraintStub, type, null, null, 12, null);
        }
    }

    private final void createTypeParameterModifierListStub(KotlinTypeParameterStubImpl typeParameterStub, ProtoBuf.TypeParameter typeParameterProto) {
        ArrayList<KtModifierKeywordToken> modifiers = new ArrayList<KtModifierKeywordToken>();
        ProtoBuf.TypeParameter.Variance variance = typeParameterProto.getVariance();
        switch (variance == null ? -1 : WhenMappings.$EnumSwitchMapping$1[variance.ordinal()]) {
            case 1: {
                modifiers.add(KtTokens.IN_KEYWORD);
                break;
            }
            case 2: {
                modifiers.add(KtTokens.OUT_KEYWORD);
            }
        }
        if (typeParameterProto.getReified()) {
            modifiers.add(KtTokens.REIFIED_KEYWORD);
        }
        KotlinModifierListStubImpl modifierList2 = ClsStubBuildingKt.createModifierListStub((StubElement<? extends PsiElement>)((StubElement)typeParameterStub), (Collection<KtModifierKeywordToken>)modifiers);
        List<AnnotationWithArgs> annotations = this.c.getComponents().getAnnotationLoader().loadTypeParameterAnnotations(typeParameterProto, this.c.getNameResolver());
        if (!((Collection)annotations).isEmpty()) {
            KotlinModifierListStubImpl kotlinModifierListStubImpl = modifierList2;
            if (kotlinModifierListStubImpl == null) {
                kotlinModifierListStubImpl = ClsStubBuildingKt.createEmptyModifierListStub(typeParameterStub);
            }
            ClsStubBuildingKt.createAnnotationStubs(annotations, kotlinModifierListStubImpl);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isDefaultUpperBound(ProtoBuf.Type $this$isDefaultUpperBound) {
        if (!$this$isDefaultUpperBound.hasClassName()) return false;
        ClassId it = NameResolverUtilKt.getClassId(this.c.getNameResolver(), $this$isDefaultUpperBound.getClassName());
        boolean bl = false;
        if (!Intrinsics.areEqual((Object)StandardNames.FqNames.any, (Object)it.asSingleFqName().toUnsafe())) return false;
        if (!$this$isDefaultUpperBound.getNullable()) return false;
        return true;
    }

    private static final String createFunctionTypeStub$getFunctionTypeParameterName(List<AnnotationWithArgs> annotations) {
        for (AnnotationWithArgs annotationWithArgs : annotations) {
            if (!Intrinsics.areEqual((Object)annotationWithArgs.getClassId().asSingleFqName(), (Object)StandardNames.FqNames.parameterName)) continue;
            Object object = CollectionsKt.firstOrNull((Iterable)annotationWithArgs.getArgs().values());
            StringValue stringValue = object instanceof StringValue ? (StringValue)object : null;
            return stringValue != null ? (String)stringValue.getValue() : null;
        }
        return null;
    }

    public static final /* synthetic */ ClsStubBuilderContext access$getC$p(TypeClsStubBuilder $this) {
        return $this.c;
    }

    public static final /* synthetic */ void access$createTypeArgumentListStub(TypeClsStubBuilder $this, KotlinUserTypeStub typeStub, List typeArgumentProtoList) {
        $this.createTypeArgumentListStub(typeStub, typeArgumentProtoList);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ProtoBuf.Type.Argument.Projection.values().length];
            try {
                nArray[ProtoBuf.Type.Argument.Projection.IN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Type.Argument.Projection.OUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Type.Argument.Projection.INV.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Type.Argument.Projection.STAR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ProtoBuf.TypeParameter.Variance.values().length];
            try {
                nArray[ProtoBuf.TypeParameter.Variance.IN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.TypeParameter.Variance.OUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.TypeParameter.Variance.INV.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

