/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.incremental.storage.FileToPathConverter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0016\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0006H\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0003H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/IncrementalFileToPathConverter;", "Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;", "rootProjectDir", "Ljava/io/File;", "(Ljava/io/File;)V", "projectDirPath", "", "getRootProjectDir", "()Ljava/io/File;", "toFile", "path", "toPath", "file", "Companion", "kotlin-build-common"})
public class IncrementalFileToPathConverter
implements FileToPathConverter {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Nullable
    private final File rootProjectDir;
    @Nullable
    private final String projectDirPath;
    @NotNull
    private static final String PROJECT_DIR_PLACEHOLDER = "$PROJECT_DIR$";
    @NotNull
    private static final String PATH_PREFIX = "$PROJECT_DIR$/";

    public IncrementalFileToPathConverter(@Nullable File rootProjectDir) {
        this.rootProjectDir = rootProjectDir;
        File file = this.rootProjectDir;
        this.projectDirPath = file != null && (file = FilesKt.normalize((File)file)) != null ? file.getAbsolutePath() : null;
    }

    @Nullable
    public final File getRootProjectDir() {
        return this.rootProjectDir;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String toPath(@NotNull File file) {
        String string;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String path = FilesKt.normalize((File)file).getAbsolutePath();
        if (this.projectDirPath != null) {
            Intrinsics.checkNotNull((Object)path);
            if (StringsKt.startsWith$default((String)path, (String)this.projectDirPath, (boolean)false, (int)2, null)) {
                StringBuilder stringBuilder = new StringBuilder().append(PROJECT_DIR_PLACEHOLDER);
                String string2 = path.substring(this.projectDirPath.length());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                string = stringBuilder.append(string2).toString();
                return string;
            }
        }
        Intrinsics.checkNotNull((Object)path);
        string = path;
        return string;
    }

    @Override
    @NotNull
    public File toFile(@NotNull String path) {
        File file;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (this.rootProjectDir != null && StringsKt.startsWith$default((String)path, (String)PROJECT_DIR_PLACEHOLDER, (boolean)false, (int)2, null)) {
            String string = path.substring(14);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            file = FilesKt.resolve((File)this.rootProjectDir, (String)string);
        } else {
            file = new File(path);
        }
        return file;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/IncrementalFileToPathConverter$Companion;", "", "()V", "PATH_PREFIX", "", "PROJECT_DIR_PLACEHOLDER", "kotlin-build-common"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

