/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.builder;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.UnknownConfigurationException;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.initialization.dsl.VersionCatalogBuilder;
import org.gradle.api.initialization.resolve.MutableVersionCatalogContainer;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.artifacts.DependencyResolutionServices;
import org.gradle.api.internal.catalog.DefaultVersionCatalogBuilder;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.VersionCatalogsModel;
import org.jetbrains.plugins.gradle.tooling.AbstractModelBuilderService;
import org.jetbrains.plugins.gradle.tooling.ErrorMessageBuilder;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderContext;
import org.jetbrains.plugins.gradle.tooling.internal.VersionCatalogsModelImpl;

public class VersionCatalogsModelBuilder
extends AbstractModelBuilderService {
    public Object buildAll(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext context) {
        if (modelName == null) {
            VersionCatalogsModelBuilder.$$$reportNull$$$0(0);
        }
        if (project == null) {
            VersionCatalogsModelBuilder.$$$reportNull$$$0(1);
        }
        if (context == null) {
            VersionCatalogsModelBuilder.$$$reportNull$$$0(2);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        SettingsInternal settings = ((GradleInternal)project.getGradle()).getSettings();
        MutableVersionCatalogContainer catalogs = settings.getDependencyResolutionManagement().getVersionCatalogs();
        for (VersionCatalogBuilder builder : catalogs) {
            if (!(builder instanceof DefaultVersionCatalogBuilder)) continue;
            DefaultVersionCatalogBuilder catalogBuilder = (DefaultVersionCatalogBuilder)builder;
            catalogBuilder.build();
            String name = catalogBuilder.getName();
            DependencyResolutionServices service = VersionCatalogsModelBuilder.extractDependencyResolutionService(catalogBuilder);
            if (service == null) continue;
            try {
                Configuration catalogImportConf = service.getConfigurationContainer().getByName("incomingCatalogFor" + StringGroovyMethods.capitalize((CharSequence)name) + "0");
                for (ResolvedArtifactResult artifact : catalogImportConf.getIncoming().getArtifacts().getArtifacts()) {
                    result.put(name, artifact.getFile().getAbsolutePath().replace('\\', '/'));
                }
            }
            catch (UnknownConfigurationException unknownConfigurationException) {
            }
        }
        return new VersionCatalogsModelImpl(result);
    }

    private static DependencyResolutionServices extractDependencyResolutionService(DefaultVersionCatalogBuilder builder) {
        try {
            Field supplierField = DefaultVersionCatalogBuilder.class.getDeclaredField("dependencyResolutionServicesSupplier");
            supplierField.setAccessible(true);
            Object supplier = supplierField.get(builder);
            Method getMethod = supplier.getClass().getMethod("get", new Class[0]);
            getMethod.setAccessible(true);
            Object result = getMethod.invoke(supplier, new Object[0]);
            if (result instanceof DependencyResolutionServices) {
                return (DependencyResolutionServices)result;
            }
            return null;
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }

    public boolean canBuild(String modelName) {
        return VersionCatalogsModel.class.getName().equals(modelName) && GradleVersion.current().compareTo(GradleVersion.version((String)"7.0")) >= 0;
    }

    @NotNull
    public ErrorMessageBuilder getErrorMessageBuilder(@NotNull Project project, @NotNull Exception e) {
        if (project == null) {
            VersionCatalogsModelBuilder.$$$reportNull$$$0(3);
        }
        if (e == null) {
            VersionCatalogsModelBuilder.$$$reportNull$$$0(4);
        }
        ErrorMessageBuilder errorMessageBuilder = ErrorMessageBuilder.create((Project)project, (Exception)e, (String)"Project version catalogs inspection errors").withDescription("Unable to obtain version catalogs sources.");
        if (errorMessageBuilder == null) {
            VersionCatalogsModelBuilder.$$$reportNull$$$0(5);
        }
        return errorMessageBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelName";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/tooling/builder/VersionCatalogsModelBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/tooling/builder/VersionCatalogsModelBuilder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessageBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildAll";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessageBuilder";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

