/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.util;

import java.lang.reflect.Method;

public final class ReflectionUtil {
    public static <T> T reflectiveGetProperty(Object target, String propertyName, Class<T> aClass) {
        try {
            Method getProperty = target.getClass().getMethod(propertyName, new Class[0]);
            Object property = getProperty.invoke(target, new Object[0]);
            Method get = property.getClass().getMethod("get", new Class[0]);
            Object value = get.invoke(property, new Object[0]);
            return aClass.cast(value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T reflectiveCall(Object target, String methodName, Class<T> aClass) {
        try {
            Method getProperty = target.getClass().getMethod(methodName, new Class[0]);
            Object value = getProperty.invoke(target, new Object[0]);
            return aClass.cast(value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean dynamicCheckInstanceOf(Object object, String ... classNames) {
        boolean result = false;
        for (String className : classNames) {
            try {
                Class<?> clazz = Class.forName(className);
                result = result || clazz.isInstance(object);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return result;
    }
}

