/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.server.core.convert.toAwt;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.projector.common.protocol.toServer.ClientKeyEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientKeyPressEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientRawKeyEvent;
import org.jetbrains.projector.common.protocol.toServer.KeyModifier;
import org.jetbrains.projector.server.core.convert.toAwt.CodesMapKt;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\bH\u0002\u001a\u001a\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u001a\u0010\t\u001a\u00020\n*\u00020\u00102\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u001a\u0010\t\u001a\u00020\n*\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\f\u0010\u0012\u001a\u00020\u0003*\u00020\u0013H\u0002\u001a\f\u0010\u0012\u001a\u00020\u0003*\u00020\u0014H\u0002\u001a\u0012\u0010\u0015\u001a\u00020\u0003*\b\u0012\u0004\u0012\u00020\u00020\bH\u0002\u001a\f\u0010\u0016\u001a\u00020\u0003*\u00020\u0017H\u0002\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"keyModifierMask", "", "Lorg/jetbrains/projector/common/protocol/toServer/KeyModifier;", "", "createAwtChar", "", "char", "modifiers", "", "toAwtKeyEvent", "Ljava/awt/event/KeyEvent;", "Lorg/jetbrains/projector/common/protocol/toServer/ClientKeyEvent;", "connectionMillis", "", "target", "Ljava/awt/Component;", "Lorg/jetbrains/projector/common/protocol/toServer/ClientKeyPressEvent;", "Lorg/jetbrains/projector/common/protocol/toServer/ClientRawKeyEvent;", "toAwtKeyEventId", "Lorg/jetbrains/projector/common/protocol/toServer/ClientKeyEvent$KeyEventType;", "Lorg/jetbrains/projector/common/protocol/toServer/ClientRawKeyEvent$RawKeyEventType;", "toInt", "toJavaLocation", "Lorg/jetbrains/projector/common/protocol/toServer/ClientKeyEvent$KeyLocation;", "projector-server-core"})
public final class KeyKt {
    @NotNull
    private static final Map<KeyModifier, Integer> keyModifierMask;

    @NotNull
    public static final KeyEvent toAwtKeyEvent(@NotNull ClientRawKeyEvent $this$toAwtKeyEvent, long connectionMillis, @NotNull Component target) {
        Intrinsics.checkNotNullParameter((Object)$this$toAwtKeyEvent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return new KeyEvent(target, KeyKt.toAwtKeyEventId($this$toAwtKeyEvent.getKeyEventType()), (long)$this$toAwtKeyEvent.getTimeStamp() + connectionMillis, $this$toAwtKeyEvent.getModifiers(), $this$toAwtKeyEvent.getCode(), $this$toAwtKeyEvent.getChar(), $this$toAwtKeyEvent.getLocation());
    }

    private static final char createAwtChar(char n, Set<? extends KeyModifier> modifiers) {
        int n2;
        boolean bl = modifiers.contains((Object)KeyModifier.CTRL_KEY);
        if (bl) {
            Character c = CodesMapKt.getControlCharMap().get(Character.toUpperCase((char)n));
            n2 = c == null ? 65535 : c.charValue();
        } else if (!bl) {
            n2 = n;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return (char)n2;
    }

    @NotNull
    public static final KeyEvent toAwtKeyEvent(@NotNull ClientKeyPressEvent $this$toAwtKeyEvent, long connectionMillis, @NotNull Component target) {
        Intrinsics.checkNotNullParameter((Object)$this$toAwtKeyEvent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        char c = KeyKt.createAwtChar($this$toAwtKeyEvent.getChar(), $this$toAwtKeyEvent.getModifiers());
        return new KeyEvent(target, 400, (long)$this$toAwtKeyEvent.getTimeStamp() + connectionMillis, KeyKt.toInt($this$toAwtKeyEvent.getModifiers()), 0, c, 0);
    }

    @NotNull
    public static final KeyEvent toAwtKeyEvent(@NotNull ClientKeyEvent $this$toAwtKeyEvent, long connectionMillis, @NotNull Component target) {
        Intrinsics.checkNotNullParameter((Object)$this$toAwtKeyEvent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        char c = KeyKt.createAwtChar($this$toAwtKeyEvent.getChar(), $this$toAwtKeyEvent.getModifiers());
        return new KeyEvent(target, KeyKt.toAwtKeyEventId($this$toAwtKeyEvent.getKeyEventType()), (long)$this$toAwtKeyEvent.getTimeStamp() + connectionMillis, KeyKt.toInt($this$toAwtKeyEvent.getModifiers()), ((Number)MapsKt.getValue(CodesMapKt.getCodesMap(), (Object)((Object)$this$toAwtKeyEvent.getCode()))).intValue(), c, KeyKt.toJavaLocation($this$toAwtKeyEvent.getLocation()));
    }

    /*
     * WARNING - void declaration
     */
    private static final int toInt(Set<? extends KeyModifier> $this$toInt) {
        void $this$fold$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable iterable = $this$toInt;
        Map<KeyModifier, Integer> map = keyModifierMask;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            KeyModifier keyModifier = (KeyModifier)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Number)MapsKt.getValue(map, (Object)p0)).intValue());
        }
        $this$map$iv = (List)destination$iv$iv;
        int initial$iv = 0;
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void p1;
            int n = ((Number)element$iv).intValue();
            int p0 = accumulator$iv;
            boolean bl = false;
            accumulator$iv = p0 | p1;
        }
        return accumulator$iv;
    }

    private static final int toAwtKeyEventId(ClientKeyEvent.KeyEventType $this$toAwtKeyEventId) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toAwtKeyEventId.ordinal()]) {
            case 1: {
                n = 401;
                break;
            }
            case 2: {
                n = 402;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    private static final int toAwtKeyEventId(ClientRawKeyEvent.RawKeyEventType $this$toAwtKeyEventId) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$1[$this$toAwtKeyEventId.ordinal()]) {
            case 1: {
                n = 401;
                break;
            }
            case 2: {
                n = 402;
                break;
            }
            case 3: {
                n = 400;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    private static final int toJavaLocation(ClientKeyEvent.KeyLocation $this$toJavaLocation) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$2[$this$toJavaLocation.ordinal()]) {
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            case 3: {
                n = 3;
                break;
            }
            case 4: {
                n = 4;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)KeyModifier.ALT_KEY), (Object)512), TuplesKt.to((Object)((Object)KeyModifier.CTRL_KEY), (Object)128), TuplesKt.to((Object)((Object)KeyModifier.SHIFT_KEY), (Object)64), TuplesKt.to((Object)((Object)KeyModifier.META_KEY), (Object)256), TuplesKt.to((Object)((Object)KeyModifier.REPEAT), (Object)0)};
        keyModifierMask = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[ClientKeyEvent.KeyEventType.values().length];
            nArray[ClientKeyEvent.KeyEventType.DOWN.ordinal()] = 1;
            nArray[ClientKeyEvent.KeyEventType.UP.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ClientRawKeyEvent.RawKeyEventType.values().length];
            nArray[ClientRawKeyEvent.RawKeyEventType.DOWN.ordinal()] = 1;
            nArray[ClientRawKeyEvent.RawKeyEventType.UP.ordinal()] = 2;
            nArray[ClientRawKeyEvent.RawKeyEventType.TYPED.ordinal()] = 3;
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[ClientKeyEvent.KeyLocation.values().length];
            nArray[ClientKeyEvent.KeyLocation.STANDARD.ordinal()] = 1;
            nArray[ClientKeyEvent.KeyLocation.LEFT.ordinal()] = 2;
            nArray[ClientKeyEvent.KeyLocation.RIGHT.ordinal()] = 3;
            nArray[ClientKeyEvent.KeyLocation.NUMPAD.ordinal()] = 4;
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

