/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.server.core.ij.md;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.server.core.ij.md.CssProcessor;
import org.jetbrains.projector.server.core.ij.md.LocalImagesInliner;
import org.jetbrains.projector.server.core.ij.md.PanelComponent;
import org.jetbrains.projector.server.core.ij.md.PanelUpdater;
import org.jetbrains.projector.util.logging.Logger;
import org.jetbrains.projector.util.logging.LoggerKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u0011\n\u0002\b\u0006\b\u0000\u0018\u0000 D2\u00020\u0001:\u0001DB\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u00102\u001a\u000203H\u0002J\b\u00104\u001a\u000203H\u0002J\b\u00105\u001a\u000203H\u0002J\b\u00106\u001a\u000203H\u0002J\u0006\u00107\u001a\u000203J\u0006\u00108\u001a\u00020\u0003J\u0006\u00109\u001a\u000203J\u000e\u0010:\u001a\u0002032\u0006\u0010;\u001a\u00020\u000bJ-\u0010<\u001a\u0002032\b\u0010=\u001a\u0004\u0018\u00010\u00172\u0016\u0010>\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00170?\"\u0004\u0018\u00010\u0017\u00a2\u0006\u0002\u0010@J\u000e\u0010A\u001a\u0002032\u0006\u0010B\u001a\u00020\u0017J\u0016\u0010A\u001a\u0002032\u0006\u0010B\u001a\u00020\u00172\u0006\u0010C\u001a\u00020\u000bR\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000eR\u001e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001d\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001aR\u000e\u0010\u001f\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010!\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u000eR\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010&\u001a\u0004\u0018\u00010%2\b\u0010\n\u001a\u0004\u0018\u00010%@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u001e\u0010)\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u001e\u0010,\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u000eR\u001e\u0010.\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u000eR\u001e\u00100\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\u000e\u00a8\u0006E"}, d2={"Lorg/jetbrains/projector/server/core/ij/md/PanelDelegate;", "", "agentComponent", "Ljavax/swing/JComponent;", "(Ljavax/swing/JComponent;)V", "backingComponent", "disposed", "", "headlessBackingComponent", "Lorg/jetbrains/projector/server/core/ij/md/PanelComponent;", "<set-?>", "", "height", "getHeight", "()I", "helperThreadOnceLaunched", "helperThreadRunnable", "Ljava/lang/Runnable;", "helperThreadRunnableGetter", "getHelperThreadRunnableGetter", "()Ljava/lang/Runnable;", "id", "getId", "", "lastChangedHtml", "getLastChangedHtml", "()Ljava/lang/String;", "lastCssFileUrls", "", "lastCssString", "getLastCssString", "lastHtml", "lastInlineCss", "lastScrollOffset", "getLastScrollOffset", "logger", "Lorg/jetbrains/projector/util/logging/Logger;", "Ljava/awt/Component;", "rootComponent", "getRootComponent", "()Ljava/awt/Component;", "shown", "getShown", "()Z", "width", "getWidth", "x", "getX", "y", "getY", "checkComponentMoved", "", "checkComponentResized", "checkComponentShown", "checkRootChanged", "dispose", "getComponent", "render", "scrollToMarkdownSrcOffset", "offset", "setCSS", "inlineCss", "fileUris", "", "(Ljava/lang/String;[Ljava/lang/String;)V", "setHtml", "html", "initialScrollOffset", "Companion", "projector-server-core"})
public final class PanelDelegate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    private final int id;
    private boolean shown;
    private int width;
    private int height;
    private int x;
    private int y;
    @NotNull
    private String lastChangedHtml;
    @Nullable
    private Component rootComponent;
    @NotNull
    private String lastCssString;
    private int lastScrollOffset;
    @NotNull
    private final PanelComponent headlessBackingComponent;
    @NotNull
    private final JComponent backingComponent;
    @Nullable
    private String lastInlineCss;
    @NotNull
    private List<String> lastCssFileUrls;
    @NotNull
    private String lastHtml;
    private boolean disposed;
    private boolean helperThreadOnceLaunched;
    @NotNull
    private final Runnable helperThreadRunnable;
    @NotNull
    private static final AtomicInteger NEXT_ID = new AtomicInteger();

    public PanelDelegate(@Nullable JComponent agentComponent) {
        boolean $i$f$Logger = false;
        String string = Reflection.getOrCreateKotlinClass(PanelDelegate.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        this.logger = LoggerKt.Logger(string);
        this.id = NEXT_ID.incrementAndGet();
        PanelUpdater.INSTANCE.put$projector_server_core(this);
        this.lastChangedHtml = "";
        this.lastCssString = "";
        this.headlessBackingComponent = new PanelComponent();
        JComponent jComponent = agentComponent;
        if (jComponent == null) {
            jComponent = this.headlessBackingComponent;
        }
        this.backingComponent = jComponent;
        this.lastCssFileUrls = CollectionsKt.emptyList();
        this.lastHtml = "";
        this.helperThreadRunnable = () -> PanelDelegate.helperThreadRunnable$lambda-1(this);
    }

    public final int getId() {
        return this.id;
    }

    public final boolean getShown() {
        return this.shown;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    @NotNull
    public final String getLastChangedHtml() {
        return this.lastChangedHtml;
    }

    @Nullable
    public final Component getRootComponent() {
        return this.rootComponent;
    }

    @NotNull
    public final String getLastCssString() {
        return this.lastCssString;
    }

    public final int getLastScrollOffset() {
        return this.lastScrollOffset;
    }

    private final Runnable getHelperThreadRunnableGetter() {
        return this.helperThreadRunnable;
    }

    public final void render() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        StringBuilder stringBuilder3;
        StringBuilder stringBuilder4;
        if (!this.helperThreadOnceLaunched) {
            new Thread(this.helperThreadRunnable).start();
        }
        StringBuilder $this$render_u24lambda_u2d2 = stringBuilder4 = new StringBuilder();
        boolean bl = false;
        if (this.disposed) {
            stringBuilder3 = $this$render_u24lambda_u2d2.append("DISPOSED");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
            stringBuilder2 = stringBuilder3.append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append('\\n')");
            stringBuilder = $this$render_u24lambda_u2d2.append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append('\\n')");
        }
        stringBuilder3 = $this$render_u24lambda_u2d2.append("inlineCss:");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        stringBuilder2 = stringBuilder3.append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append('\\n')");
        stringBuilder3 = $this$render_u24lambda_u2d2.append(this.lastInlineCss);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        stringBuilder2 = stringBuilder3.append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append('\\n')");
        stringBuilder = $this$render_u24lambda_u2d2.append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append('\\n')");
        stringBuilder3 = $this$render_u24lambda_u2d2.append("cssFileUrls:");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        stringBuilder2 = stringBuilder3.append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append('\\n')");
        stringBuilder3 = $this$render_u24lambda_u2d2.append(CollectionsKt.joinToString$default((Iterable)this.lastCssFileUrls, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        stringBuilder2 = stringBuilder3.append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append('\\n')");
        stringBuilder = $this$render_u24lambda_u2d2.append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append('\\n')");
        stringBuilder3 = $this$render_u24lambda_u2d2.append("html:");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        stringBuilder2 = stringBuilder3.append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append('\\n')");
        stringBuilder3 = $this$render_u24lambda_u2d2.append(StringsKt.replace$default((String)this.lastHtml, (String)">", (String)">\n", (boolean)false, (int)4, null));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        stringBuilder2 = stringBuilder3.append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append('\\n')");
        String string = stringBuilder4.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String componentText = string;
        this.headlessBackingComponent.setText(componentText);
    }

    public final void setCSS(@Nullable String inlineCss, String ... fileUris) {
        Intrinsics.checkNotNullParameter((Object)fileUris, (String)"fileUris");
        this.lastInlineCss = inlineCss;
        this.lastCssFileUrls = ArraysKt.toList((Object[])fileUris);
        this.lastCssString = CssProcessor.INSTANCE.makeCss(this.lastInlineCss, this.lastCssFileUrls);
        PanelUpdater.INSTANCE.setCss$projector_server_core(this.id);
    }

    public final void setHtml(@NotNull String html) {
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        try {
            String changedHtml = html;
            if (((CharSequence)html).length() > 0) {
                changedHtml = LocalImagesInliner.INSTANCE.inlineLocalImages(changedHtml);
            }
            this.lastChangedHtml = changedHtml;
            this.lastHtml = html;
            PanelUpdater.INSTANCE.setHtml$projector_server_core(this.id);
        }
        catch (Throwable t) {
            Logger.DefaultImpls.error$default(this.logger, null, (Function0)new Function0<String>(this){
                final /* synthetic */ PanelDelegate this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Can't set HTML in Panel #" + this.this$0.getId() + "...";
                }
            }, 1, null);
        }
    }

    public final void setHtml(@NotNull String html, int initialScrollOffset) {
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        this.setHtml(html);
        this.scrollToMarkdownSrcOffset(initialScrollOffset);
    }

    @NotNull
    public final JComponent getComponent() {
        return this.backingComponent;
    }

    public final void scrollToMarkdownSrcOffset(int offset) {
        this.lastScrollOffset = offset;
        PanelUpdater.INSTANCE.scroll$projector_server_core(this.id);
    }

    public final void dispose() {
        this.disposed = true;
        PanelUpdater.INSTANCE.dispose$projector_server_core(this.id);
    }

    private final void checkComponentMoved() {
        if (!this.backingComponent.isShowing()) {
            return;
        }
        Point it = this.backingComponent.getLocationOnScreen();
        boolean bl = false;
        if (this.getX() != it.x || this.getY() != it.y) {
            this.x = it.x;
            this.y = it.y;
            PanelUpdater.INSTANCE.move$projector_server_core(this.getId());
        }
    }

    private final void checkComponentResized() {
        Dimension it = this.backingComponent.getSize();
        boolean bl = false;
        if (this.getWidth() != it.width || this.getHeight() != it.height) {
            this.width = it.width;
            this.height = it.height;
            PanelUpdater.INSTANCE.resize$projector_server_core(this.getId());
        }
    }

    private final void checkComponentShown() {
        boolean it = this.backingComponent.isShowing();
        boolean bl = false;
        if (it != this.getShown()) {
            this.shown = it;
            PanelUpdater.INSTANCE.show$projector_server_core(this.getId());
        }
    }

    private final void checkRootChanged() {
        if (!this.backingComponent.isShowing()) {
            return;
        }
        Component it = SwingUtilities.getRoot(this.backingComponent);
        boolean bl = false;
        if (!Intrinsics.areEqual((Object)it, (Object)this.getRootComponent())) {
            this.rootComponent = it;
            PanelUpdater.INSTANCE.placeToWindow$projector_server_core(this.getId());
        }
    }

    private static final void helperThreadRunnable$lambda-1$lambda-0(PanelDelegate this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.checkComponentMoved();
        this$0.checkComponentResized();
        this$0.checkComponentShown();
        this$0.checkRootChanged();
        new Thread(this$0.getHelperThreadRunnableGetter()).start();
    }

    private static final void helperThreadRunnable$lambda-1(PanelDelegate this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Thread.sleep(1000L);
        if (this$0.disposed) {
            return;
        }
        SwingUtilities.invokeLater(() -> PanelDelegate.helperThreadRunnable$lambda-1$lambda-0(this$0));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/projector/server/core/ij/md/PanelDelegate$Companion;", "", "()V", "NEXT_ID", "Ljava/util/concurrent/atomic/AtomicInteger;", "projector-server-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

