/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.server.core.ij.md;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.Disposer;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Charsets;
import org.intellij.plugins.markdown.extensions.MarkdownBrowserPreviewExtension;
import org.intellij.plugins.markdown.extensions.MarkdownConfigurableExtension;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanel;
import org.intellij.plugins.markdown.ui.preview.ResourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.ij.md.MarkdownKt;
import org.jetbrains.projector.server.core.ij.md.PanelDelegate;
import org.jetbrains.projector.server.core.ij.md.ProjectorMarkdownPanel;
import org.jetbrains.projector.util.logging.Logger;
import org.jetbrains.projector.util.logging.LoggerKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 &2\u00020\u0001:\u0001&B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u000eH\u0002J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0012\u0010\u0018\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0006\u0010\u0019\u001a\u00020\u000eJ\u000e\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017J\u0018\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0003H\u0016J-\u0010\u001c\u001a\u00020\u000e2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u001e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00050\u001f\"\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010 J\u000e\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u0005J\u0018\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u0017H\u0016J\"\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u00172\b\u0010$\u001a\u0004\u0018\u00010%H\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/projector/server/core/ij/md/ProjectorMarkdownPanel;", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel;", "isAgent", "", "agentDelegateClass", "", "(ZLjava/lang/String;)V", "agentDelegate", "clientDelegate", "Lorg/jetbrains/projector/server/core/ij/md/PanelDelegate;", "currentExtensions", "", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension;", "addScrollListener", "", "listener", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel$ScrollListener;", "dispose", "getComponent", "Ljavax/swing/JComponent;", "reloadExtensions", "reloadWithOffset", "offset", "", "removeScrollListener", "render", "scrollToMarkdownSrcOffset", "smooth", "setCSS", "inlineCss", "fileUris", "", "(Ljava/lang/String;[Ljava/lang/String;)V", "setHtml", "html", "initialScrollOffset", "documentPath", "Ljava/nio/file/Path;", "Companion", "projector-server-core"})
public final class ProjectorMarkdownPanel
implements MarkdownHtmlPanel {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private final boolean isAgent;
    @Nullable
    private final MarkdownHtmlPanel agentDelegate;
    @NotNull
    private final PanelDelegate clientDelegate;
    @NotNull
    private List<? extends MarkdownBrowserPreviewExtension> currentExtensions;
    @Deprecated
    @NotNull
    private static final Logger logger;
    @Deprecated
    @NotNull
    private static final Lazy<Boolean> isRenderMethodRemoved$delegate;
    @Deprecated
    @NotNull
    private static final Lazy<Boolean> isNewExtensionsHandling$delegate;
    @Deprecated
    @NotNull
    private static final Lazy<Method> setHtmlMethod$delegate;
    @Deprecated
    @NotNull
    private static final Lazy<Method> setCSSMethod$delegate;
    @Deprecated
    @NotNull
    private static final Lazy<Method> renderMethod$delegate;
    @Deprecated
    @NotNull
    private static final Lazy<Method> oldAllExtensionsMethod$delegate;

    public ProjectorMarkdownPanel(boolean isAgent, @NotNull String agentDelegateClass) {
        JComponent jComponent;
        Intrinsics.checkNotNullParameter((Object)agentDelegateClass, (String)"agentDelegateClass");
        this.isAgent = isAgent;
        MarkdownHtmlPanel markdownHtmlPanel = this.agentDelegate = this.isAgent ? ProjectorMarkdownPanel.Companion.createNativeMarkdownPanel(agentDelegateClass) : null;
        if (this.isAgent) {
            MarkdownHtmlPanel markdownHtmlPanel2 = this.agentDelegate;
            jComponent = markdownHtmlPanel2 == null ? null : markdownHtmlPanel2.getComponent();
        } else {
            jComponent = null;
        }
        this.clientDelegate = new PanelDelegate(jComponent);
        this.currentExtensions = CollectionsKt.emptyList();
        this.reloadExtensions();
    }

    /*
     * WARNING - void declaration
     */
    private final void reloadExtensions() {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        if (!ProjectorMarkdownPanel.Companion.isNewExtensionsHandling()) {
            return;
        }
        Iterable $this$forEach$iv = this.currentExtensions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Disposable p0 = (Disposable)element$iv;
            boolean bl = false;
            Disposer.dispose((Disposable)p0);
        }
        $this$forEach$iv = MarkdownBrowserPreviewExtension.Provider.Companion.getAll();
        Companion companion = Companion;
        ProjectorMarkdownPanel projectorMarkdownPanel = this;
        boolean $i$f$mapNotNull = false;
        Iterator iterator = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            MarkdownBrowserPreviewExtension it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            MarkdownBrowserPreviewExtension.Provider it = (MarkdownBrowserPreviewExtension.Provider)element$iv$iv;
            boolean bl2 = false;
            if (it.createBrowserExtension((MarkdownHtmlPanel)this) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list = (List)destination$iv$iv;
        projectorMarkdownPanel.currentExtensions = companion.prepared(list);
    }

    public void dispose() {
        MarkdownHtmlPanel markdownHtmlPanel = this.agentDelegate;
        if (markdownHtmlPanel != null) {
            markdownHtmlPanel.dispose();
        }
        this.clientDelegate.dispose();
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent;
        if (this.isAgent) {
            MarkdownHtmlPanel markdownHtmlPanel = this.agentDelegate;
            Intrinsics.checkNotNull((Object)markdownHtmlPanel);
            JComponent jComponent2 = markdownHtmlPanel.getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent2, (String)"agentDelegate!!.component");
            jComponent = jComponent2;
        } else {
            jComponent = this.clientDelegate.getComponent();
        }
        return jComponent;
    }

    public final void setHtml(@NotNull String html) {
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        MarkdownHtmlPanel markdownHtmlPanel = this.agentDelegate;
        if (markdownHtmlPanel != null) {
            ProjectorMarkdownPanel.Companion.setHtml(markdownHtmlPanel, html);
        }
        this.clientDelegate.setHtml(html);
    }

    public final void setCSS(@Nullable String inlineCss, String ... fileUris) {
        Intrinsics.checkNotNullParameter((Object)fileUris, (String)"fileUris");
        MarkdownHtmlPanel markdownHtmlPanel = this.agentDelegate;
        if (markdownHtmlPanel != null) {
            ProjectorMarkdownPanel.Companion.setCSS(markdownHtmlPanel, inlineCss, Arrays.copyOf(fileUris, fileUris.length));
        }
        this.clientDelegate.setCSS(inlineCss, Arrays.copyOf(fileUris, fileUris.length));
    }

    public final void render() {
        MarkdownHtmlPanel markdownHtmlPanel = this.agentDelegate;
        if (markdownHtmlPanel != null) {
            ProjectorMarkdownPanel.Companion.render(markdownHtmlPanel);
        }
        this.clientDelegate.render();
    }

    public void setHtml(@NotNull String html, int initialScrollOffset) {
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        MarkdownHtmlPanel markdownHtmlPanel = this.agentDelegate;
        if (markdownHtmlPanel != null) {
            markdownHtmlPanel.setHtml(html, initialScrollOffset);
        }
        this.clientDelegate.setHtml(html, initialScrollOffset);
        if (ProjectorMarkdownPanel.Companion.isRenderMethodRemoved()) {
            Iterable iterable = ProjectorMarkdownPanel.Companion.getStyleUrls(this);
            String string = System.lineSeparator();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator()");
            this.clientDelegate.setCSS(CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, null, (int)62, null), new String[0]);
            this.clientDelegate.render();
        }
    }

    public void setHtml(@NotNull String html, int initialScrollOffset, @Nullable Path documentPath) {
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        this.setHtml(html, initialScrollOffset);
    }

    public void reloadWithOffset(int offset) {
        this.reloadExtensions();
        MarkdownHtmlPanel markdownHtmlPanel = this.agentDelegate;
        if (markdownHtmlPanel != null) {
            markdownHtmlPanel.reloadWithOffset(offset);
        }
    }

    public void scrollToMarkdownSrcOffset(int offset, boolean smooth) {
        MarkdownHtmlPanel markdownHtmlPanel = this.agentDelegate;
        if (markdownHtmlPanel != null) {
            markdownHtmlPanel.scrollToMarkdownSrcOffset(offset, smooth);
        }
        this.clientDelegate.scrollToMarkdownSrcOffset(offset);
    }

    public final void scrollToMarkdownSrcOffset(int offset) {
        MarkdownHtmlPanel markdownHtmlPanel = this.agentDelegate;
        if (markdownHtmlPanel != null) {
            markdownHtmlPanel.scrollToMarkdownSrcOffset(offset, false);
        }
        this.clientDelegate.scrollToMarkdownSrcOffset(offset);
    }

    public void addScrollListener(@Nullable MarkdownHtmlPanel.ScrollListener listener2) {
        MarkdownHtmlPanel markdownHtmlPanel = this.agentDelegate;
        if (markdownHtmlPanel != null) {
            markdownHtmlPanel.addScrollListener(listener2);
        }
    }

    public void removeScrollListener(@Nullable MarkdownHtmlPanel.ScrollListener listener2) {
        MarkdownHtmlPanel markdownHtmlPanel = this.agentDelegate;
        if (markdownHtmlPanel != null) {
            markdownHtmlPanel.removeScrollListener(listener2);
        }
    }

    public static final /* synthetic */ Companion access$getCompanion$p() {
        return Companion;
    }

    static {
        boolean $i$f$Logger = false;
        String string = Reflection.getOrCreateKotlinClass(ProjectorMarkdownPanel.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        logger = LoggerKt.Logger(string);
        isRenderMethodRemoved$delegate = LazyKt.lazy((Function0)Companion.isRenderMethodRemoved.2.INSTANCE);
        isNewExtensionsHandling$delegate = LazyKt.lazy((Function0)Companion.isNewExtensionsHandling.2.INSTANCE);
        setHtmlMethod$delegate = LazyKt.lazy((Function0)Companion.setHtmlMethod.2.INSTANCE);
        setCSSMethod$delegate = LazyKt.lazy((Function0)Companion.setCSSMethod.2.INSTANCE);
        renderMethod$delegate = LazyKt.lazy((Function0)Companion.renderMethod.2.INSTANCE);
        oldAllExtensionsMethod$delegate = LazyKt.lazy((Function0)Companion.oldAllExtensionsMethod.2.INSTANCE);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020'H\u0002J\u0010\u0010,\u001a\u00020\u00042\u0006\u0010-\u001a\u00020'H\u0002J\u0018\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015*\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\f\u0010/\u001a\u000200*\u00020*H\u0002J3\u00101\u001a\u000200*\u00020*2\b\u00102\u001a\u0004\u0018\u00010'2\u0016\u00103\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010'04\"\u0004\u0018\u00010'H\u0002\u00a2\u0006\u0002\u00105J\u0014\u00106\u001a\u000200*\u00020*2\u0006\u00107\u001a\u00020'H\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\u0003\u0010\u0005R\u001b\u0010\b\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\u0007\u001a\u0004\b\b\u0010\u0005R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR#\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0007\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R#\u0010\u0019\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0007\u001a\u0004\b\u001a\u0010\u0012R#\u0010\u001c\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u0007\u001a\u0004\b\u001d\u0010\u0012R#\u0010\u001f\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u0007\u001a\u0004\b \u0010\u0012R\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015*\u00020#8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u001e\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u0015*\u00020#8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010%\u00a8\u00068"}, d2={"Lorg/jetbrains/projector/server/core/ij/md/ProjectorMarkdownPanel$Companion;", "", "()V", "isNewExtensionsHandling", "", "()Z", "isNewExtensionsHandling$delegate", "Lkotlin/Lazy;", "isRenderMethodRemoved", "isRenderMethodRemoved$delegate", "logger", "Lorg/jetbrains/projector/util/logging/Logger;", "getLogger", "()Lorg/jetbrains/projector/util/logging/Logger;", "oldAllExtensionsMethod", "Ljava/lang/reflect/Method;", "kotlin.jvm.PlatformType", "getOldAllExtensionsMethod", "()Ljava/lang/reflect/Method;", "oldAllExtensionsMethod$delegate", "oldMarkdownExtensions", "", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension;", "getOldMarkdownExtensions", "()Ljava/util/List;", "renderMethod", "getRenderMethod", "renderMethod$delegate", "setCSSMethod", "getSetCSSMethod", "setCSSMethod$delegate", "setHtmlMethod", "getSetHtmlMethod", "setHtmlMethod$delegate", "markdownExtensions", "Lorg/jetbrains/projector/server/core/ij/md/ProjectorMarkdownPanel;", "getMarkdownExtensions", "(Lorg/jetbrains/projector/server/core/ij/md/ProjectorMarkdownPanel;)Ljava/util/List;", "styleUrls", "", "getStyleUrls", "createNativeMarkdownPanel", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel;", "className", "isMarkdownVersionAtLeast", "version", "prepared", "render", "", "setCSS", "inlineCss", "fileUris", "", "(Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel;Ljava/lang/String;[Ljava/lang/String;)V", "setHtml", "html", "projector-server-core"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        private final List<MarkdownBrowserPreviewExtension> getOldMarkdownExtensions() {
            Object object = this.getOldAllExtensionsMethod().invoke(null, new Object[0]);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<org.intellij.plugins.markdown.extensions.MarkdownBrowserPreviewExtension>");
            }
            return this.prepared((List)object);
        }

        private final List<MarkdownBrowserPreviewExtension> getMarkdownExtensions(ProjectorMarkdownPanel $this$markdownExtensions) {
            return this.isNewExtensionsHandling() ? $this$markdownExtensions.currentExtensions : this.getOldMarkdownExtensions();
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> getStyleUrls(ProjectorMarkdownPanel $this$styleUrls) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = this.getMarkdownExtensions($this$styleUrls);
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapNotNullTo$iv$iv;
                MarkdownBrowserPreviewExtension extension = (MarkdownBrowserPreviewExtension)element$iv$iv;
                boolean bl = false;
                Iterable $this$mapNotNull$iv = extension.getStyles();
                boolean $i$f$mapNotNull = false;
                Iterable iterable2 = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    String string;
                    Object element$iv$iv$iv;
                    Object element$iv$iv2 = element$iv$iv$iv = iterator.next();
                    boolean bl2 = false;
                    String style = (String)element$iv$iv2;
                    boolean bl3 = false;
                    ResourceProvider.Resource resource = extension.getResourceProvider().loadResource(style);
                    if (resource == null) {
                        string = null;
                    } else if (resource.getContent() == null) {
                        string = null;
                    } else {
                        byte[] it;
                        boolean bl4 = false;
                        string = new String(it, Charsets.UTF_8);
                    }
                    if (string == null) continue;
                    String it$iv$iv = string;
                    boolean bl5 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final boolean isRenderMethodRemoved() {
            Lazy lazy = isRenderMethodRemoved$delegate;
            return (Boolean)lazy.getValue();
        }

        private final boolean isNewExtensionsHandling() {
            Lazy lazy = isNewExtensionsHandling$delegate;
            return (Boolean)lazy.getValue();
        }

        private final boolean isMarkdownVersionAtLeast(String version) {
            BuildNumber buildNumber = BuildNumber.fromString((String)version);
            Intrinsics.checkNotNull((Object)buildNumber);
            BuildNumber buildNumber2 = buildNumber;
            Intrinsics.checkNotNullExpressionValue((Object)buildNumber2, (String)"fromString(version)!!");
            BuildNumber buildNumber3 = buildNumber2;
            IdeaPluginDescriptor ideaPluginDescriptor = MarkdownKt.getMarkdownPlugin();
            Intrinsics.checkNotNull((Object)ideaPluginDescriptor);
            BuildNumber buildNumber4 = BuildNumber.fromString((String)ideaPluginDescriptor.getVersion());
            Intrinsics.checkNotNull((Object)buildNumber4);
            BuildNumber buildNumber5 = buildNumber4;
            Intrinsics.checkNotNullExpressionValue((Object)buildNumber5, (String)"fromString(markdownPlugin!!.version)!!");
            BuildNumber markdownBuildNumber = buildNumber5;
            return markdownBuildNumber.compareTo(buildNumber3) >= 0;
        }

        private final Method getSetHtmlMethod() {
            Lazy lazy = setHtmlMethod$delegate;
            return (Method)lazy.getValue();
        }

        private final Method getSetCSSMethod() {
            Lazy lazy = setCSSMethod$delegate;
            return (Method)lazy.getValue();
        }

        private final Method getRenderMethod() {
            Lazy lazy = renderMethod$delegate;
            return (Method)lazy.getValue();
        }

        private final Method getOldAllExtensionsMethod() {
            Lazy lazy = oldAllExtensionsMethod$delegate;
            return (Method)lazy.getValue();
        }

        private final void setHtml(MarkdownHtmlPanel $this$setHtml, String html) {
            Object[] objectArray = new Object[]{html};
            this.getSetHtmlMethod().invoke((Object)$this$setHtml, objectArray);
        }

        private final void setCSS(MarkdownHtmlPanel $this$setCSS, String inlineCss, String ... fileUris) {
            Object[] objectArray = new Object[]{inlineCss, fileUris};
            this.getSetCSSMethod().invoke((Object)$this$setCSS, objectArray);
        }

        private final void render(MarkdownHtmlPanel $this$render) {
            this.getRenderMethod().invoke((Object)$this$render, new Object[0]);
        }

        /*
         * WARNING - void declaration
         */
        private final List<MarkdownBrowserPreviewExtension> prepared(List<? extends MarkdownBrowserPreviewExtension> $this$prepared) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = $this$prepared;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl;
                MarkdownBrowserPreviewExtension it = (MarkdownBrowserPreviewExtension)element$iv$iv;
                boolean bl2 = false;
                MarkdownConfigurableExtension markdownConfigurableExtension = it instanceof MarkdownConfigurableExtension ? (MarkdownConfigurableExtension)it : null;
                if (!(markdownConfigurableExtension == null ? true : (bl = markdownConfigurableExtension.isEnabled()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
        }

        private final MarkdownHtmlPanel createNativeMarkdownPanel(String className) {
            Object object;
            try {
                object = Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                object = object instanceof MarkdownHtmlPanel ? (MarkdownHtmlPanel)object : null;
            }
            catch (Exception e) {
                this.getLogger().error(e, (Function0<String>)((Function0)new Function0<String>(className){
                    final /* synthetic */ String $className;
                    {
                        this.$className = $className;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Exception during instantiating MarkdownHtmlPanel of type " + this.$className;
                    }
                }));
                object = null;
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ boolean access$isMarkdownVersionAtLeast(Companion $this, String version) {
            return $this.isMarkdownVersionAtLeast(version);
        }
    }
}

