/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.server.service;

import java.awt.Font;
import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.projector.awt.font.PFontManager;
import org.jetbrains.projector.awt.service.FontProvider;
import org.jetbrains.projector.server.service.ProjectorFontProvider;
import sun.font.CompositeFont;
import sun.font.Font2D;
import sun.font.PhysicalFont;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u0011\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\b7\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0092\u0001\u001a\u0002032\u0007\u0010\u0093\u0001\u001a\u00020\u00042\u0007\u0010\u0094\u0001\u001a\u00020\u00042\u0007\u0010\u0095\u0001\u001a\u00020)H\u0002J\u001b\u0010\u0096\u0001\u001a\u00020)2\u0007\u0010\u0093\u0001\u001a\u00020\u00042\u0007\u0010\u0097\u0001\u001a\u00020\u0004H\u0002J%\u0010\u0098\u0001\u001a\u00030\u0099\u00012\u0007\u0010\u009a\u0001\u001a\u00020\u00042\u0007\u0010\u0094\u0001\u001a\u00020\u00112\u0007\u0010\u009b\u0001\u001a\u00020\u0011H\u0016J\u0012\u0010\u009c\u0001\u001a\u00020a2\u0007\u0010\u009a\u0001\u001a\u00020\u0004H\u0002J\u0012\u0010\u009d\u0001\u001a\u00020.2\u0007\u0010\u0095\u0001\u001a\u00020)H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R!\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\u001e\u0010\u001fR)\u0010\"\u001a\u0010\u0012\f\u0012\n $*\u0004\u0018\u00010\u00040\u00040#8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010!\u001a\u0004\b%\u0010&R\u001b\u0010(\u001a\u00020)8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010!\u001a\u0004\b*\u0010+R\u001b\u0010-\u001a\u00020.8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b1\u0010!\u001a\u0004\b/\u00100R\u001b\u00102\u001a\u0002038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b6\u0010!\u001a\u0004\b4\u00105R\u001b\u00107\u001a\u00020)8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b9\u0010!\u001a\u0004\b8\u0010+R\u001b\u0010:\u001a\u00020.8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b<\u0010!\u001a\u0004\b;\u00100R\u001b\u0010=\u001a\u0002038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b?\u0010!\u001a\u0004\b>\u00105R\u001b\u0010@\u001a\u00020)8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bB\u0010!\u001a\u0004\bA\u0010+R\u001b\u0010C\u001a\u00020.8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bE\u0010!\u001a\u0004\bD\u00100R\u0014\u0010F\u001a\u00020.8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bG\u00100R\u001a\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00040I8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bJ\u0010KR\u001b\u0010L\u001a\u0002038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bN\u0010!\u001a\u0004\bM\u00105R\u001b\u0010O\u001a\u00020)8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bQ\u0010!\u001a\u0004\bP\u0010+R\u001b\u0010R\u001a\u00020.8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bT\u0010!\u001a\u0004\bS\u00100R\u001b\u0010U\u001a\u0002038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bW\u0010!\u001a\u0004\bV\u00105R\u001b\u0010X\u001a\u00020)8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bZ\u0010!\u001a\u0004\bY\u0010+R\u001b\u0010[\u001a\u00020.8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b]\u0010!\u001a\u0004\b\\\u00100R\u001a\u0010^\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b_\u0010\u001fR+\u0010b\u001a\u00020a2\u0006\u0010`\u001a\u00020a8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\bf\u0010g\u001a\u0004\bb\u0010c\"\u0004\bd\u0010eR\u001b\u0010h\u001a\u0002038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bj\u0010!\u001a\u0004\bi\u00105R\u001b\u0010k\u001a\u00020)8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bm\u0010!\u001a\u0004\bl\u0010+R\u001b\u0010n\u001a\u00020.8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bp\u0010!\u001a\u0004\bo\u00100R\u001b\u0010q\u001a\u0002038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bs\u0010!\u001a\u0004\br\u00105R\u001b\u0010t\u001a\u00020)8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bv\u0010!\u001a\u0004\bu\u0010+R\u001b\u0010w\u001a\u00020.8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\by\u0010!\u001a\u0004\bx\u00100R\u001b\u0010z\u001a\u0002038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b|\u0010!\u001a\u0004\b{\u00105R\u001b\u0010}\u001a\u00020)8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u007f\u0010!\u001a\u0004\b~\u0010+R\u001e\u0010\u0080\u0001\u001a\u00020.8BX\u0082\u0084\u0002\u00a2\u0006\u000e\n\u0005\b\u0082\u0001\u0010!\u001a\u0005\b\u0081\u0001\u00100R\u001e\u0010\u0083\u0001\u001a\u0002038BX\u0082\u0084\u0002\u00a2\u0006\u000e\n\u0005\b\u0085\u0001\u0010!\u001a\u0005\b\u0084\u0001\u00105R\u001e\u0010\u0086\u0001\u001a\u00020)8BX\u0082\u0084\u0002\u00a2\u0006\u000e\n\u0005\b\u0088\u0001\u0010!\u001a\u0005\b\u0087\u0001\u0010+R\u001e\u0010\u0089\u0001\u001a\u00020.8BX\u0082\u0084\u0002\u00a2\u0006\u000e\n\u0005\b\u008b\u0001\u0010!\u001a\u0005\b\u008a\u0001\u00100R\u001e\u0010\u008c\u0001\u001a\u00020)8BX\u0082\u0084\u0002\u00a2\u0006\u000e\n\u0005\b\u008e\u0001\u0010!\u001a\u0005\b\u008d\u0001\u0010+R\u001e\u0010\u008f\u0001\u001a\u00020.8BX\u0082\u0084\u0002\u00a2\u0006\u000e\n\u0005\b\u0091\u0001\u0010!\u001a\u0005\b\u0090\u0001\u00100\u00a8\u0006\u009e\u0001"}, d2={"Lorg/jetbrains/projector/server/service/ProjectorFontProvider;", "Lorg/jetbrains/projector/awt/service/FontProvider;", "()V", "CJK_R_NAME", "", "CJK_R_PATH", "DEFAULT_BI_NAME", "DEFAULT_BI_PATH", "DEFAULT_B_NAME", "DEFAULT_B_PATH", "DEFAULT_FONT_NAME", "DEFAULT_FONT_PATH", "DEFAULT_RI_NAME", "DEFAULT_RI_PATH", "DEFAULT_R_NAME", "DEFAULT_R_PATH", "DEFAULT_SIZE", "", "MONO_BI_NAME", "MONO_BI_PATH", "MONO_B_NAME", "MONO_B_PATH", "MONO_RI_NAME", "MONO_RI_PATH", "MONO_R_NAME", "MONO_R_PATH", "SYMBOLS_R_NAME", "allInstalledFonts", "", "Ljava/awt/Font;", "getAllInstalledFonts", "()Ljava/util/List;", "allInstalledFonts$delegate", "Lkotlin/Lazy;", "allMonoFontNames", "", "kotlin.jvm.PlatformType", "getAllMonoFontNames", "()Ljava/util/Set;", "allMonoFontNames$delegate", "cjkRegularFile", "Ljava/io/File;", "getCjkRegularFile", "()Ljava/io/File;", "cjkRegularFile$delegate", "cjkRegularFont", "Lsun/font/PhysicalFont;", "getCjkRegularFont", "()Lsun/font/PhysicalFont;", "cjkRegularFont$delegate", "defaultBoldComposite", "Lsun/font/CompositeFont;", "getDefaultBoldComposite", "()Lsun/font/CompositeFont;", "defaultBoldComposite$delegate", "defaultBoldFile", "getDefaultBoldFile", "defaultBoldFile$delegate", "defaultBoldFont", "getDefaultBoldFont", "defaultBoldFont$delegate", "defaultBoldItalicComposite", "getDefaultBoldItalicComposite", "defaultBoldItalicComposite$delegate", "defaultBoldItalicFile", "getDefaultBoldItalicFile", "defaultBoldItalicFile$delegate", "defaultBoldItalicFont", "getDefaultBoldItalicFont", "defaultBoldItalicFont$delegate", "defaultPhysicalFont", "getDefaultPhysicalFont", "defaultPlatformFont", "", "getDefaultPlatformFont", "()[Ljava/lang/String;", "defaultRegularComposite", "getDefaultRegularComposite", "defaultRegularComposite$delegate", "defaultRegularFile", "getDefaultRegularFile", "defaultRegularFile$delegate", "defaultRegularFont", "getDefaultRegularFont", "defaultRegularFont$delegate", "defaultRegularItalicComposite", "getDefaultRegularItalicComposite", "defaultRegularItalicComposite$delegate", "defaultRegularItalicFile", "getDefaultRegularItalicFile", "defaultRegularItalicFile$delegate", "defaultRegularItalicFont", "getDefaultRegularItalicFont", "defaultRegularItalicFont$delegate", "installedFonts", "getInstalledFonts", "<set-?>", "", "isAgent", "()Z", "setAgent", "(Z)V", "isAgent$delegate", "Lkotlin/properties/ReadWriteProperty;", "monoBoldComposite", "getMonoBoldComposite", "monoBoldComposite$delegate", "monoBoldFile", "getMonoBoldFile", "monoBoldFile$delegate", "monoBoldFont", "getMonoBoldFont", "monoBoldFont$delegate", "monoBoldItalicComposite", "getMonoBoldItalicComposite", "monoBoldItalicComposite$delegate", "monoBoldItalicFile", "getMonoBoldItalicFile", "monoBoldItalicFile$delegate", "monoBoldItalicFont", "getMonoBoldItalicFont", "monoBoldItalicFont$delegate", "monoRegularComposite", "getMonoRegularComposite", "monoRegularComposite$delegate", "monoRegularFile", "getMonoRegularFile", "monoRegularFile$delegate", "monoRegularFont", "getMonoRegularFont", "monoRegularFont$delegate", "monoRegularItalicComposite", "getMonoRegularItalicComposite", "monoRegularItalicComposite$delegate", "monoRegularItalicFile", "getMonoRegularItalicFile", "monoRegularItalicFile$delegate", "monoRegularItalicFont", "getMonoRegularItalicFont", "monoRegularItalicFont$delegate", "symbolsRegularFile", "getSymbolsRegularFile", "symbolsRegularFile$delegate", "symbolsRegularFont", "getSymbolsRegularFont", "symbolsRegularFont$delegate", "createCompositeFont", "fontName", "style", "tempFile", "createFontFile", "fontPath", "findFont2D", "Lsun/font/Font2D;", "name", "fallback", "isMonospacedFont", "loadPhysicalFont", "projector-server-common"})
public final class ProjectorFontProvider
implements FontProvider {
    @NotNull
    public static final ProjectorFontProvider INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final ReadWriteProperty isAgent$delegate;
    @NotNull
    private static final Lazy cjkRegularFile$delegate;
    @NotNull
    private static final Lazy cjkRegularFont$delegate;
    @NotNull
    private static final Lazy symbolsRegularFile$delegate;
    @NotNull
    private static final Lazy symbolsRegularFont$delegate;
    @NotNull
    private static final Lazy defaultRegularFile$delegate;
    @NotNull
    private static final Lazy defaultRegularFont$delegate;
    @NotNull
    private static final Lazy defaultRegularComposite$delegate;
    @NotNull
    private static final Lazy defaultRegularItalicFile$delegate;
    @NotNull
    private static final Lazy defaultRegularItalicFont$delegate;
    @NotNull
    private static final Lazy defaultRegularItalicComposite$delegate;
    @NotNull
    private static final Lazy defaultBoldFile$delegate;
    @NotNull
    private static final Lazy defaultBoldFont$delegate;
    @NotNull
    private static final Lazy defaultBoldComposite$delegate;
    @NotNull
    private static final Lazy defaultBoldItalicFile$delegate;
    @NotNull
    private static final Lazy defaultBoldItalicFont$delegate;
    @NotNull
    private static final Lazy defaultBoldItalicComposite$delegate;
    @NotNull
    private static final Lazy monoRegularFile$delegate;
    @NotNull
    private static final Lazy monoRegularFont$delegate;
    @NotNull
    private static final Lazy monoRegularComposite$delegate;
    @NotNull
    private static final Lazy monoRegularItalicFile$delegate;
    @NotNull
    private static final Lazy monoRegularItalicFont$delegate;
    @NotNull
    private static final Lazy monoRegularItalicComposite$delegate;
    @NotNull
    private static final Lazy monoBoldFile$delegate;
    @NotNull
    private static final Lazy monoBoldFont$delegate;
    @NotNull
    private static final Lazy monoBoldComposite$delegate;
    @NotNull
    private static final Lazy monoBoldItalicFile$delegate;
    @NotNull
    private static final Lazy monoBoldItalicFont$delegate;
    @NotNull
    private static final Lazy monoBoldItalicComposite$delegate;
    @NotNull
    private static final Lazy allInstalledFonts$delegate;
    @NotNull
    private static final Lazy allMonoFontNames$delegate;
    @NotNull
    private static final String DEFAULT_R_NAME = "Default-R";
    @NotNull
    private static final String DEFAULT_R_PATH = "/fonts/Default-R.ttf";
    @NotNull
    private static final String DEFAULT_RI_NAME = "Default-RI";
    @NotNull
    private static final String DEFAULT_RI_PATH = "/fonts/Default-RI.ttf";
    @NotNull
    private static final String DEFAULT_B_NAME = "Default-B";
    @NotNull
    private static final String DEFAULT_B_PATH = "/fonts/Default-B.ttf";
    @NotNull
    private static final String DEFAULT_BI_NAME = "Default-BI";
    @NotNull
    private static final String DEFAULT_BI_PATH = "/fonts/Default-BI.ttf";
    @NotNull
    private static final String MONO_R_NAME = "Mono-R";
    @NotNull
    private static final String MONO_R_PATH = "/fonts/Mono-R.ttf";
    @NotNull
    private static final String MONO_RI_NAME = "Mono-RI";
    @NotNull
    private static final String MONO_RI_PATH = "/fonts/Mono-RI.ttf";
    @NotNull
    private static final String MONO_B_NAME = "Mono-B";
    @NotNull
    private static final String MONO_B_PATH = "/fonts/Mono-B.ttf";
    @NotNull
    private static final String MONO_BI_NAME = "Mono-BI";
    @NotNull
    private static final String MONO_BI_PATH = "/fonts/Mono-BI.ttf";
    @NotNull
    private static final String CJK_R_NAME = "CJK-R";
    @NotNull
    private static final String CJK_R_PATH = "/fonts/CJK-R.otf";
    @NotNull
    private static final String SYMBOLS_R_NAME = "Symbols-R";
    @NotNull
    private static final String DEFAULT_FONT_NAME = "Default-R";
    @NotNull
    private static final String DEFAULT_FONT_PATH = "/fonts/Default-R.ttf";
    private static final int DEFAULT_SIZE = 12;

    private ProjectorFontProvider() {
    }

    public final boolean isAgent() {
        return (Boolean)isAgent$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    public final void setAgent(boolean bl) {
        isAgent$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)bl);
    }

    private final File getCjkRegularFile() {
        Lazy lazy = cjkRegularFile$delegate;
        return (File)lazy.getValue();
    }

    private final PhysicalFont getCjkRegularFont() {
        Lazy lazy = cjkRegularFont$delegate;
        return (PhysicalFont)lazy.getValue();
    }

    private final File getSymbolsRegularFile() {
        Lazy lazy = symbolsRegularFile$delegate;
        return (File)lazy.getValue();
    }

    private final PhysicalFont getSymbolsRegularFont() {
        Lazy lazy = symbolsRegularFont$delegate;
        return (PhysicalFont)lazy.getValue();
    }

    private final File getDefaultRegularFile() {
        Lazy lazy = defaultRegularFile$delegate;
        return (File)lazy.getValue();
    }

    private final PhysicalFont getDefaultRegularFont() {
        Lazy lazy = defaultRegularFont$delegate;
        return (PhysicalFont)lazy.getValue();
    }

    private final CompositeFont getDefaultRegularComposite() {
        Lazy lazy = defaultRegularComposite$delegate;
        return (CompositeFont)lazy.getValue();
    }

    private final File getDefaultRegularItalicFile() {
        Lazy lazy = defaultRegularItalicFile$delegate;
        return (File)lazy.getValue();
    }

    private final PhysicalFont getDefaultRegularItalicFont() {
        Lazy lazy = defaultRegularItalicFont$delegate;
        return (PhysicalFont)lazy.getValue();
    }

    private final CompositeFont getDefaultRegularItalicComposite() {
        Lazy lazy = defaultRegularItalicComposite$delegate;
        return (CompositeFont)lazy.getValue();
    }

    private final File getDefaultBoldFile() {
        Lazy lazy = defaultBoldFile$delegate;
        return (File)lazy.getValue();
    }

    private final PhysicalFont getDefaultBoldFont() {
        Lazy lazy = defaultBoldFont$delegate;
        return (PhysicalFont)lazy.getValue();
    }

    private final CompositeFont getDefaultBoldComposite() {
        Lazy lazy = defaultBoldComposite$delegate;
        return (CompositeFont)lazy.getValue();
    }

    private final File getDefaultBoldItalicFile() {
        Lazy lazy = defaultBoldItalicFile$delegate;
        return (File)lazy.getValue();
    }

    private final PhysicalFont getDefaultBoldItalicFont() {
        Lazy lazy = defaultBoldItalicFont$delegate;
        return (PhysicalFont)lazy.getValue();
    }

    private final CompositeFont getDefaultBoldItalicComposite() {
        Lazy lazy = defaultBoldItalicComposite$delegate;
        return (CompositeFont)lazy.getValue();
    }

    private final File getMonoRegularFile() {
        Lazy lazy = monoRegularFile$delegate;
        return (File)lazy.getValue();
    }

    private final PhysicalFont getMonoRegularFont() {
        Lazy lazy = monoRegularFont$delegate;
        return (PhysicalFont)lazy.getValue();
    }

    private final CompositeFont getMonoRegularComposite() {
        Lazy lazy = monoRegularComposite$delegate;
        return (CompositeFont)lazy.getValue();
    }

    private final File getMonoRegularItalicFile() {
        Lazy lazy = monoRegularItalicFile$delegate;
        return (File)lazy.getValue();
    }

    private final PhysicalFont getMonoRegularItalicFont() {
        Lazy lazy = monoRegularItalicFont$delegate;
        return (PhysicalFont)lazy.getValue();
    }

    private final CompositeFont getMonoRegularItalicComposite() {
        Lazy lazy = monoRegularItalicComposite$delegate;
        return (CompositeFont)lazy.getValue();
    }

    private final File getMonoBoldFile() {
        Lazy lazy = monoBoldFile$delegate;
        return (File)lazy.getValue();
    }

    private final PhysicalFont getMonoBoldFont() {
        Lazy lazy = monoBoldFont$delegate;
        return (PhysicalFont)lazy.getValue();
    }

    private final CompositeFont getMonoBoldComposite() {
        Lazy lazy = monoBoldComposite$delegate;
        return (CompositeFont)lazy.getValue();
    }

    private final File getMonoBoldItalicFile() {
        Lazy lazy = monoBoldItalicFile$delegate;
        return (File)lazy.getValue();
    }

    private final PhysicalFont getMonoBoldItalicFont() {
        Lazy lazy = monoBoldItalicFont$delegate;
        return (PhysicalFont)lazy.getValue();
    }

    private final CompositeFont getMonoBoldItalicComposite() {
        Lazy lazy = monoBoldItalicComposite$delegate;
        return (CompositeFont)lazy.getValue();
    }

    private final List<Font> getAllInstalledFonts() {
        Lazy lazy = allInstalledFonts$delegate;
        return (List)lazy.getValue();
    }

    private final Set<String> getAllMonoFontNames() {
        Lazy lazy = allMonoFontNames$delegate;
        return (Set)lazy.getValue();
    }

    @Override
    @NotNull
    public List<Font> getInstalledFonts() {
        return this.getAllInstalledFonts();
    }

    @Override
    @NotNull
    public PhysicalFont getDefaultPhysicalFont() {
        return this.getDefaultRegularFont();
    }

    @Override
    @NotNull
    public String[] getDefaultPlatformFont() {
        String[] stringArray = new String[]{"Default-R", "/fonts/Default-R.ttf"};
        return stringArray;
    }

    @Override
    @NotNull
    public Font2D findFont2D(@NotNull String name, int style, int fallback) {
        Font2D font2D;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        switch (name) {
            case "Default-RI": 
            case "Default-BI": 
            case "Default-R": 
            case "Default-B": {
                Font2D font2D2;
                switch (style) {
                    case 3: {
                        font2D2 = this.getDefaultBoldItalicFont();
                        break;
                    }
                    case 1: {
                        font2D2 = this.getDefaultBoldFont();
                        break;
                    }
                    case 2: {
                        font2D2 = this.getDefaultRegularItalicFont();
                        break;
                    }
                    default: {
                        font2D2 = this.getDefaultRegularFont();
                    }
                }
                return font2D2;
            }
            case "Mono-RI": 
            case "Mono-BI": 
            case "Mono-B": 
            case "Mono-R": {
                Font2D font2D3;
                switch (style) {
                    case 3: {
                        font2D3 = this.getMonoBoldItalicFont();
                        break;
                    }
                    case 1: {
                        font2D3 = this.getMonoBoldFont();
                        break;
                    }
                    case 2: {
                        font2D3 = this.getMonoRegularItalicFont();
                        break;
                    }
                    default: {
                        font2D3 = this.getMonoRegularFont();
                    }
                }
                return font2D3;
            }
            case "CJK-R": {
                return this.getCjkRegularFont();
            }
            case "Symbols-R": {
                return this.getSymbolsRegularFont();
            }
        }
        boolean bl = this.isMonospacedFont(name);
        if (bl) {
            switch (style) {
                case 3: {
                    font2D = ProjectorFontProvider.findFont2D$headlessOrAgent(this.getMonoBoldItalicComposite(), this.getMonoBoldItalicFont());
                    break;
                }
                case 1: {
                    font2D = ProjectorFontProvider.findFont2D$headlessOrAgent(this.getMonoBoldComposite(), this.getMonoBoldFont());
                    break;
                }
                case 2: {
                    font2D = ProjectorFontProvider.findFont2D$headlessOrAgent(this.getMonoRegularItalicComposite(), this.getMonoRegularItalicFont());
                    break;
                }
                default: {
                    font2D = ProjectorFontProvider.findFont2D$headlessOrAgent(this.getMonoRegularComposite(), this.getMonoRegularFont());
                    break;
                }
            }
        } else if (!bl) {
            switch (style) {
                case 3: {
                    font2D = ProjectorFontProvider.findFont2D$headlessOrAgent(this.getDefaultBoldItalicComposite(), this.getDefaultBoldItalicFont());
                    break;
                }
                case 1: {
                    font2D = ProjectorFontProvider.findFont2D$headlessOrAgent(this.getDefaultBoldComposite(), this.getDefaultBoldFont());
                    break;
                }
                case 2: {
                    font2D = ProjectorFontProvider.findFont2D$headlessOrAgent(this.getDefaultRegularItalicComposite(), this.getDefaultRegularItalicFont());
                    break;
                }
                default: {
                    font2D = ProjectorFontProvider.findFont2D$headlessOrAgent(this.getDefaultRegularComposite(), this.getDefaultRegularFont());
                    break;
                }
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return font2D;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isMonospacedFont(String name) {
        String string = name.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"mono", (boolean)false, (int)2, null)) return true;
        string = name.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        if (Intrinsics.areEqual((Object)string, (Object)"menlo")) return true;
        if (!this.getAllMonoFontNames().contains(name)) return false;
        return true;
    }

    private final File createFontFile(String fontName, String fontPath) {
        File file;
        File $this$createFontFile_u24lambda_u2d0 = file = File.createTempFile(fontName, ".ttf");
        boolean bl = false;
        $this$createFontFile_u24lambda_u2d0.deleteOnExit();
        File tempFile = file;
        InputStream link = PFontManager.class.getResourceAsStream(fontPath);
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        Files.copy(link, tempFile.getAbsoluteFile().toPath(), copyOptionArray);
        Intrinsics.checkNotNullExpressionValue((Object)tempFile, (String)"tempFile");
        return tempFile;
    }

    private final PhysicalFont loadPhysicalFont(File tempFile) {
        Font2D[] font2DArray = PFontManager.INSTANCE.createFont2D(tempFile, 0, false, false, null);
        Intrinsics.checkNotNullExpressionValue((Object)font2DArray, (String)"PFontManager.createFont2\u2026FONT, false, false, null)");
        Object object = ArraysKt.single((Object[])font2DArray);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type sun.font.PhysicalFont");
        }
        return (PhysicalFont)object;
    }

    private final CompositeFont createCompositeFont(String fontName, String style, File tempFile) {
        String[] stringArray = new String[]{tempFile.getAbsolutePath(), this.getSymbolsRegularFile().getAbsolutePath(), this.getCjkRegularFile().getAbsolutePath()};
        String[] stringArray2 = stringArray;
        stringArray = new String[]{fontName, SYMBOLS_R_NAME, CJK_R_NAME};
        return new CompositeFont(fontName + "." + style, stringArray2, stringArray, 2, null, null, false, PFontManager.INSTANCE);
    }

    private static final Font2D findFont2D$headlessOrAgent(Font2D headless, Font2D agent) {
        Font2D font2D;
        boolean bl = INSTANCE.isAgent();
        if (!bl) {
            font2D = headless;
        } else if (bl) {
            font2D = agent;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return font2D;
    }

    public static final /* synthetic */ File access$createFontFile(ProjectorFontProvider $this, String fontName, String fontPath) {
        return $this.createFontFile(fontName, fontPath);
    }

    public static final /* synthetic */ PhysicalFont access$loadPhysicalFont(ProjectorFontProvider $this, File tempFile) {
        return $this.loadPhysicalFont(tempFile);
    }

    public static final /* synthetic */ File access$getCjkRegularFile(ProjectorFontProvider $this) {
        return $this.getCjkRegularFile();
    }

    public static final /* synthetic */ File access$getSymbolsRegularFile(ProjectorFontProvider $this) {
        return $this.getSymbolsRegularFile();
    }

    public static final /* synthetic */ File access$getDefaultRegularFile(ProjectorFontProvider $this) {
        return $this.getDefaultRegularFile();
    }

    public static final /* synthetic */ CompositeFont access$createCompositeFont(ProjectorFontProvider $this, String fontName, String style, File tempFile) {
        return $this.createCompositeFont(fontName, style, tempFile);
    }

    public static final /* synthetic */ File access$getDefaultRegularItalicFile(ProjectorFontProvider $this) {
        return $this.getDefaultRegularItalicFile();
    }

    public static final /* synthetic */ File access$getDefaultBoldFile(ProjectorFontProvider $this) {
        return $this.getDefaultBoldFile();
    }

    public static final /* synthetic */ File access$getDefaultBoldItalicFile(ProjectorFontProvider $this) {
        return $this.getDefaultBoldItalicFile();
    }

    public static final /* synthetic */ File access$getMonoRegularFile(ProjectorFontProvider $this) {
        return $this.getMonoRegularFile();
    }

    public static final /* synthetic */ File access$getMonoRegularItalicFile(ProjectorFontProvider $this) {
        return $this.getMonoRegularItalicFile();
    }

    public static final /* synthetic */ File access$getMonoBoldFile(ProjectorFontProvider $this) {
        return $this.getMonoBoldFile();
    }

    public static final /* synthetic */ File access$getMonoBoldItalicFile(ProjectorFontProvider $this) {
        return $this.getMonoBoldItalicFile();
    }

    public static final /* synthetic */ PhysicalFont access$getDefaultRegularFont(ProjectorFontProvider $this) {
        return $this.getDefaultRegularFont();
    }

    public static final /* synthetic */ PhysicalFont access$getDefaultRegularItalicFont(ProjectorFontProvider $this) {
        return $this.getDefaultRegularItalicFont();
    }

    public static final /* synthetic */ PhysicalFont access$getDefaultBoldFont(ProjectorFontProvider $this) {
        return $this.getDefaultBoldFont();
    }

    public static final /* synthetic */ PhysicalFont access$getDefaultBoldItalicFont(ProjectorFontProvider $this) {
        return $this.getDefaultBoldItalicFont();
    }

    public static final /* synthetic */ PhysicalFont access$getMonoRegularFont(ProjectorFontProvider $this) {
        return $this.getMonoRegularFont();
    }

    public static final /* synthetic */ PhysicalFont access$getMonoRegularItalicFont(ProjectorFontProvider $this) {
        return $this.getMonoRegularItalicFont();
    }

    public static final /* synthetic */ PhysicalFont access$getMonoBoldFont(ProjectorFontProvider $this) {
        return $this.getMonoBoldFont();
    }

    public static final /* synthetic */ PhysicalFont access$getMonoBoldItalicFont(ProjectorFontProvider $this) {
        return $this.getMonoBoldItalicFont();
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(ProjectorFontProvider.class, "isAgent", "isAgent()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new ProjectorFontProvider();
        isAgent$delegate = Delegates.INSTANCE.notNull();
        cjkRegularFile$delegate = LazyKt.lazy((Function0)cjkRegularFile.2.INSTANCE);
        cjkRegularFont$delegate = LazyKt.lazy((Function0)cjkRegularFont.2.INSTANCE);
        symbolsRegularFile$delegate = LazyKt.lazy((Function0)symbolsRegularFile.2.INSTANCE);
        symbolsRegularFont$delegate = LazyKt.lazy((Function0)symbolsRegularFont.2.INSTANCE);
        defaultRegularFile$delegate = LazyKt.lazy((Function0)defaultRegularFile.2.INSTANCE);
        defaultRegularFont$delegate = LazyKt.lazy((Function0)defaultRegularFont.2.INSTANCE);
        defaultRegularComposite$delegate = LazyKt.lazy((Function0)defaultRegularComposite.2.INSTANCE);
        defaultRegularItalicFile$delegate = LazyKt.lazy((Function0)defaultRegularItalicFile.2.INSTANCE);
        defaultRegularItalicFont$delegate = LazyKt.lazy((Function0)defaultRegularItalicFont.2.INSTANCE);
        defaultRegularItalicComposite$delegate = LazyKt.lazy((Function0)defaultRegularItalicComposite.2.INSTANCE);
        defaultBoldFile$delegate = LazyKt.lazy((Function0)defaultBoldFile.2.INSTANCE);
        defaultBoldFont$delegate = LazyKt.lazy((Function0)defaultBoldFont.2.INSTANCE);
        defaultBoldComposite$delegate = LazyKt.lazy((Function0)defaultBoldComposite.2.INSTANCE);
        defaultBoldItalicFile$delegate = LazyKt.lazy((Function0)defaultBoldItalicFile.2.INSTANCE);
        defaultBoldItalicFont$delegate = LazyKt.lazy((Function0)defaultBoldItalicFont.2.INSTANCE);
        defaultBoldItalicComposite$delegate = LazyKt.lazy((Function0)defaultBoldItalicComposite.2.INSTANCE);
        monoRegularFile$delegate = LazyKt.lazy((Function0)monoRegularFile.2.INSTANCE);
        monoRegularFont$delegate = LazyKt.lazy((Function0)monoRegularFont.2.INSTANCE);
        monoRegularComposite$delegate = LazyKt.lazy((Function0)monoRegularComposite.2.INSTANCE);
        monoRegularItalicFile$delegate = LazyKt.lazy((Function0)monoRegularItalicFile.2.INSTANCE);
        monoRegularItalicFont$delegate = LazyKt.lazy((Function0)monoRegularItalicFont.2.INSTANCE);
        monoRegularItalicComposite$delegate = LazyKt.lazy((Function0)monoRegularItalicComposite.2.INSTANCE);
        monoBoldFile$delegate = LazyKt.lazy((Function0)monoBoldFile.2.INSTANCE);
        monoBoldFont$delegate = LazyKt.lazy((Function0)monoBoldFont.2.INSTANCE);
        monoBoldComposite$delegate = LazyKt.lazy((Function0)monoBoldComposite.2.INSTANCE);
        monoBoldItalicFile$delegate = LazyKt.lazy((Function0)monoBoldItalicFile.2.INSTANCE);
        monoBoldItalicFont$delegate = LazyKt.lazy((Function0)monoBoldItalicFont.2.INSTANCE);
        monoBoldItalicComposite$delegate = LazyKt.lazy((Function0)monoBoldItalicComposite.2.INSTANCE);
        allInstalledFonts$delegate = LazyKt.lazy((Function0)allInstalledFonts.2.INSTANCE);
        allMonoFontNames$delegate = LazyKt.lazy((Function0)allMonoFontNames.2.INSTANCE);
    }
}

