/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.util.loading.state;

import com.intellij.diagnostic.LoadingState;
import com.intellij.ide.WindowsCommandLineProcessor;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.projector.util.loading.OptionKt;
import org.jetbrains.projector.util.loading.ProjectorClassLoaderSetup;
import org.jetbrains.projector.util.loading.UseProjectorLoader;

@UseProjectorLoader
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\b\u0087\u0001\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/projector/util/loading/state/IdeState;", "", "(Ljava/lang/String;I)V", "asLoadingState", "Lcom/intellij/diagnostic/LoadingState;", "getAsLoadingState", "()Lcom/intellij/diagnostic/LoadingState;", "isOccurred", "", "()Z", "IDE_CLASSLOADER_INSTANTIATED", "IDE_CLASSLOADER_FETCHED", "BOOTSTRAP", "LAF_INITIALIZED", "COMPONENTS_REGISTERED", "CONFIGURATION_STORE_INITIALIZED", "COMPONENTS_LOADED", "APP_STARTED", "PROJECT_OPENED", "Companion", "projector-util-loading"})
public final class IdeState
extends Enum<IdeState> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    public static final String ATTACH_TO_IDE_PROPERTY_NAME = "ORG_JETBRAINS_PROJECTOR_SERVER_ATTACH_TO_IDE";
    public static final /* enum */ IdeState IDE_CLASSLOADER_INSTANTIATED;
    public static final /* enum */ IdeState IDE_CLASSLOADER_FETCHED;
    public static final /* enum */ IdeState BOOTSTRAP;
    public static final /* enum */ IdeState LAF_INITIALIZED;
    public static final /* enum */ IdeState COMPONENTS_REGISTERED;
    public static final /* enum */ IdeState CONFIGURATION_STORE_INITIALIZED;
    public static final /* enum */ IdeState COMPONENTS_LOADED;
    public static final /* enum */ IdeState APP_STARTED;
    public static final /* enum */ IdeState PROJECT_OPENED;
    private static final /* synthetic */ IdeState[] $VALUES;

    @NotNull
    public final LoadingState getAsLoadingState() {
        LoadingState loadingState;
        switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1: {
                loadingState = LoadingState.BOOTSTRAP;
                break;
            }
            case 2: {
                loadingState = LoadingState.LAF_INITIALIZED;
                break;
            }
            case 3: {
                loadingState = LoadingState.COMPONENTS_REGISTERED;
                break;
            }
            case 4: {
                loadingState = LoadingState.CONFIGURATION_STORE_INITIALIZED;
                break;
            }
            case 5: {
                loadingState = LoadingState.COMPONENTS_LOADED;
                break;
            }
            case 6: {
                loadingState = LoadingState.APP_STARTED;
                break;
            }
            case 7: {
                loadingState = LoadingState.PROJECT_OPENED;
                break;
            }
            default: {
                throw new IllegalStateException("IdeaState " + this.name() + " doesn't have backing com.intellij.diagnostic.LoadingState instance");
            }
        }
        return loadingState;
    }

    public final boolean isOccurred() {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 8: {
                bl = IdeState.Companion.isIdeClassLoaderInstantiated();
                break;
            }
            case 9: {
                bl = ProjectorClassLoaderSetup.INSTANCE.getIdeaClassLoaderInitialized$projector_util_loading();
                break;
            }
            default: {
                bl = IDE_CLASSLOADER_FETCHED.isOccurred() && this.getAsLoadingState().isOccurred();
            }
        }
        return bl;
    }

    public static IdeState[] values() {
        return (IdeState[])$VALUES.clone();
    }

    public static IdeState valueOf(String value) {
        return Enum.valueOf(IdeState.class, value);
    }

    static {
        IDE_CLASSLOADER_INSTANTIATED = new IdeState();
        IDE_CLASSLOADER_FETCHED = new IdeState();
        BOOTSTRAP = new IdeState();
        LAF_INITIALIZED = new IdeState();
        COMPONENTS_REGISTERED = new IdeState();
        CONFIGURATION_STORE_INITIALIZED = new IdeState();
        COMPONENTS_LOADED = new IdeState();
        APP_STARTED = new IdeState();
        PROJECT_OPENED = new IdeState();
        $VALUES = ideStateArray = new IdeState[]{IdeState.IDE_CLASSLOADER_INSTANTIATED, IdeState.IDE_CLASSLOADER_FETCHED, IdeState.BOOTSTRAP, IdeState.LAF_INITIALIZED, IdeState.COMPONENTS_REGISTERED, IdeState.CONFIGURATION_STORE_INITIALIZED, IdeState.COMPONENTS_LOADED, IdeState.APP_STARTED, IdeState.PROJECT_OPENED};
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\bR\u0014\u0010\n\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/projector/util/loading/state/IdeState$Companion;", "", "()V", "ATTACH_TO_IDE_PROPERTY_NAME", "", "attachToIde", "", "getAttachToIde", "()Z", "isIdeAttached", "isIdeClassLoaderInstantiated", "projector-util-loading"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isIdeAttached() {
            boolean bl;
            boolean bl2 = this.getAttachToIde();
            if (!bl2) {
                bl = false;
            } else if (bl2) {
                boolean bl3;
                try {
                    bl3 = true;
                }
                catch (Throwable t) {
                    bl3 = false;
                }
                bl = bl3;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return bl;
        }

        private final boolean isIdeClassLoaderInstantiated() {
            return this.isIdeAttached() && WindowsCommandLineProcessor.ourMainRunnerClass != null;
        }

        public final boolean getAttachToIde() {
            return StringsKt.toBooleanStrict((String)OptionKt.getOption(IdeState.ATTACH_TO_IDE_PROPERTY_NAME, "true"));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IdeState.values().length];
            nArray[IdeState.BOOTSTRAP.ordinal()] = 1;
            nArray[IdeState.LAF_INITIALIZED.ordinal()] = 2;
            nArray[IdeState.COMPONENTS_REGISTERED.ordinal()] = 3;
            nArray[IdeState.CONFIGURATION_STORE_INITIALIZED.ordinal()] = 4;
            nArray[IdeState.COMPONENTS_LOADED.ordinal()] = 5;
            nArray[IdeState.APP_STARTED.ordinal()] = 6;
            nArray[IdeState.PROJECT_OPENED.ordinal()] = 7;
            nArray[IdeState.IDE_CLASSLOADER_INSTANTIATED.ordinal()] = 8;
            nArray[IdeState.IDE_CLASSLOADER_FETCHED.ordinal()] = 9;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

