/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.detector.ngram.impl;

import ai.grazie.detector.ngram.profiles.LanguageProfile;
import ai.grazie.detector.utils.collections.array.OneOptimizedFloatArray;
import ai.grazie.detector.utils.collections.array.OptimizedFloatArray;
import ai.grazie.detector.utils.collections.ngram.NgramArray;
import ai.grazie.detector.utils.collections.ngram.NgramArrayKt;
import ai.grazie.nlp.langs.Language;
import ai.grazie.utils.CollectionFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0002\u0016\u0017B/\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lai/grazie/detector/ngram/impl/NgramFrequencies;", "", "probabilities", "", "Lai/grazie/detector/utils/collections/ngram/NgramArray;", "Lai/grazie/detector/utils/collections/array/OptimizedFloatArray;", "languages", "", "Lai/grazie/nlp/langs/Language;", "statistics", "Lai/grazie/detector/ngram/impl/NgramFrequencies$Statistics;", "(Ljava/util/Map;Ljava/util/List;Lai/grazie/detector/ngram/impl/NgramFrequencies$Statistics;)V", "getLanguages", "()Ljava/util/List;", "getStatistics", "()Lai/grazie/detector/ngram/impl/NgramFrequencies$Statistics;", "getLanguage", "pos", "", "getProbabilities", "ngram", "", "Companion", "Statistics", "nlp-detect"})
@SourceDebugExtension(value={"SMAP\nNgramFrequencies.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NgramFrequencies.kt\nai/grazie/detector/ngram/impl/NgramFrequencies\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,107:1\n1#2:108\n*E\n"})
public final class NgramFrequencies {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<NgramArray, OptimizedFloatArray> probabilities;
    @NotNull
    private final Statistics statistics;
    @NotNull
    private final List<Language> languages;

    public NgramFrequencies(@NotNull Map<NgramArray, ? extends OptimizedFloatArray> probabilities, @NotNull List<? extends Language> languages2, @NotNull Statistics statistics) {
        Intrinsics.checkNotNullParameter(probabilities, (String)"probabilities");
        Intrinsics.checkNotNullParameter(languages2, (String)"languages");
        Intrinsics.checkNotNullParameter((Object)statistics, (String)"statistics");
        this.probabilities = probabilities;
        this.statistics = statistics;
        this.languages = CollectionsKt.plus((Collection)languages2, (Object)((Object)Language.UNKNOWN));
        if (!(!languages2.contains((Object)Language.UNKNOWN))) {
            boolean bl = false;
            String string2 = "UNKNOWN language should not be passed to NgramFrequencies";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    @NotNull
    public final Statistics getStatistics() {
        return this.statistics;
    }

    @NotNull
    public final List<Language> getLanguages() {
        return this.languages;
    }

    @NotNull
    public final Language getLanguage(int pos) {
        return this.languages.get(pos);
    }

    @NotNull
    public final OptimizedFloatArray getProbabilities(@NotNull String ngram) {
        Intrinsics.checkNotNullParameter((Object)ngram, (String)"ngram");
        OptimizedFloatArray optimizedFloatArray = this.probabilities.get(NgramArrayKt.toNgramArray(ngram));
        if (optimizedFloatArray == null || (optimizedFloatArray = optimizedFloatArray.set(this.languages.size() - 1, 0.0f, (byte)this.languages.size())) == null) {
            optimizedFloatArray = new OneOptimizedFloatArray().set(this.languages.size() - 1, (float)this.statistics.getAverage(), (byte)this.languages.size());
        }
        return optimizedFloatArray;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006\u00a8\u0006\n"}, d2={"Lai/grazie/detector/ngram/impl/NgramFrequencies$Companion;", "", "()V", "create", "Lai/grazie/detector/ngram/impl/NgramFrequencies;", "profiles", "", "Lai/grazie/detector/ngram/profiles/LanguageProfile;", "gramLengths", "", "nlp-detect"})
    @SourceDebugExtension(value={"SMAP\nNgramFrequencies.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NgramFrequencies.kt\nai/grazie/detector/ngram/impl/NgramFrequencies$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,107:1\n1#2:108\n1549#3:109\n1620#3,3:110\n*S KotlinDebug\n*F\n+ 1 NgramFrequencies.kt\nai/grazie/detector/ngram/impl/NgramFrequencies$Companion\n*L\n103#1:109\n103#1:110,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final NgramFrequencies create(@NotNull Collection<? extends LanguageProfile> profiles, @NotNull Collection<Integer> gramLengths) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String key2;
            Object ngram;
            Intrinsics.checkNotNullParameter(profiles, (String)"profiles");
            Intrinsics.checkNotNullParameter(gramLengths, (String)"gramLengths");
            if (!(!profiles.isEmpty())) {
                boolean $i$a$-require-NgramFrequencies$Companion$create$42 = false;
                String $i$a$-require-NgramFrequencies$Companion$create$42 = "No language profiles provided!";
                throw new IllegalArgumentException($i$a$-require-NgramFrequencies$Companion$create$42.toString());
            }
            if (!(!gramLengths.isEmpty())) {
                boolean $i$a$-require-NgramFrequencies$Companion$create$52 = false;
                String $i$a$-require-NgramFrequencies$Companion$create$52 = "No gram lengths provided!";
                throw new IllegalArgumentException($i$a$-require-NgramFrequencies$Companion$create$52.toString());
            }
            HashMap probabilities = new HashMap();
            double sumOfAll = 0.0;
            int total = 0;
            Iterator<? extends LanguageProfile> iterator = profiles.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int index = n++;
                LanguageProfile profile = iterator.next();
                Iterator<Integer> iterator2 = gramLengths.iterator();
                while (iterator2.hasNext()) {
                    int gramLength = ((Number)iterator2.next()).intValue();
                    if (!profile.getGramLengths().contains(gramLength)) {
                        boolean $i$a$-require-NgramFrequencies$Companion$create$62 = false;
                        String $i$a$-require-NgramFrequencies$Companion$create$62 = "The language profile for " + profile.getLocale() + " does not contain " + gramLength + "-grams!";
                        throw new IllegalArgumentException($i$a$-require-NgramFrequencies$Companion$create$62.toString());
                    }
                    for (Map.Entry<String, Integer> $i$a$-require-NgramFrequencies$Companion$create$62 : profile.iterateGrams(gramLength)) {
                        ngram = $i$a$-require-NgramFrequencies$Companion$create$62.getKey();
                        int frequency = ((Number)$i$a$-require-NgramFrequencies$Companion$create$62.getValue()).intValue();
                        float prob = (float)frequency / (float)profile.getNumGramOccurrences(((String)ngram).length());
                        ++total;
                        sumOfAll += (double)prob;
                        OptimizedFloatArray optimizedFloatArray = (OptimizedFloatArray)probabilities.get(ngram);
                        if (optimizedFloatArray == null) {
                            optimizedFloatArray = new OneOptimizedFloatArray();
                        }
                        OptimizedFloatArray arr = optimizedFloatArray;
                        arr = arr.set(index, prob, (byte)profiles.size());
                        ((Map)probabilities).put(ngram, arr);
                    }
                }
            }
            Map<NgramArray, OptimizedFloatArray> optimized = CollectionFactory.INSTANCE.smallMemoryFootprintMap(profiles.size());
            for (Map.Entry index : ((Map)probabilities).entrySet()) {
                key2 = (String)index.getKey();
                OptimizedFloatArray value = (OptimizedFloatArray)index.getValue();
                optimized.put(NgramArrayKt.toNgramArray(key2), value);
            }
            Iterable iterable = profiles;
            Map<NgramArray, OptimizedFloatArray> map = optimized;
            boolean $i$f$map = false;
            key2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Map.Entry<String, Integer> item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ngram = (LanguageProfile)((Object)item$iv$iv);
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getLocale());
            }
            Statistics statistics = new Statistics(sumOfAll / (double)total);
            List list = (List)destination$iv$iv;
            Map<NgramArray, OptimizedFloatArray> map2 = map;
            return new NgramFrequencies(map2, list, statistics);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lai/grazie/detector/ngram/impl/NgramFrequencies$Statistics;", "", "average", "", "(D)V", "getAverage", "()D", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "nlp-detect"})
    public static final class Statistics {
        private final double average;

        public Statistics(double average) {
            this.average = average;
        }

        public final double getAverage() {
            return this.average;
        }

        public final double component1() {
            return this.average;
        }

        @NotNull
        public final Statistics copy(double average) {
            return new Statistics(average);
        }

        public static /* synthetic */ Statistics copy$default(Statistics statistics, double d, int n, Object object) {
            if ((n & 1) != 0) {
                d = statistics.average;
            }
            return statistics.copy(d);
        }

        @NotNull
        public String toString() {
            return "Statistics(average=" + this.average + ")";
        }

        public int hashCode() {
            return Double.hashCode(this.average);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Statistics)) {
                return false;
            }
            Statistics statistics = (Statistics)other;
            return Double.compare(this.average, statistics.average) == 0;
        }
    }
}

