/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractCharCollection;
import com.carrotsearch.hppc.AbstractIntCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.CharContainer;
import com.carrotsearch.hppc.IntCharAssociativeContainer;
import com.carrotsearch.hppc.IntCharHashMap;
import com.carrotsearch.hppc.IntCharMap;
import com.carrotsearch.hppc.IntCollection;
import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.IntLookupContainer;
import com.carrotsearch.hppc.comparators.IntCharComparator;
import com.carrotsearch.hppc.comparators.IntComparator;
import com.carrotsearch.hppc.cursors.CharCursor;
import com.carrotsearch.hppc.cursors.IntCharCursor;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.predicates.CharPredicate;
import com.carrotsearch.hppc.predicates.IntCharPredicate;
import com.carrotsearch.hppc.predicates.IntPredicate;
import com.carrotsearch.hppc.procedures.CharProcedure;
import com.carrotsearch.hppc.procedures.IntCharProcedure;
import com.carrotsearch.hppc.procedures.IntProcedure;
import com.carrotsearch.hppc.sorting.QuickSort;
import java.util.Iterator;
import java.util.function.IntBinaryOperator;

public class SortedIterationIntCharHashMap
implements IntCharMap {
    public final IntCharHashMap delegate;
    public final int[] iterationOrder;

    public SortedIterationIntCharHashMap(IntCharHashMap delegate, IntComparator comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    public SortedIterationIntCharHashMap(IntCharHashMap delegate, IntCharComparator comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    private int[] createEntryIndexes() {
        int[] keys = this.delegate.keys;
        int size = this.delegate.size();
        int[] entryIndexes = new int[size];
        int entry2 = 0;
        if (this.delegate.hasEmptyKey) {
            entryIndexes[entry2++] = this.delegate.mask + 1;
        }
        int keyIndex = 0;
        while (entry2 < size) {
            if (keys[keyIndex] != 0) {
                entryIndexes[entry2++] = keyIndex;
            }
            ++keyIndex;
        }
        return entryIndexes;
    }

    protected int[] sortIterationOrder(int[] entryIndexes, IntComparator comparator) {
        QuickSort.sort(entryIndexes, (i, j) -> {
            int[] keys = this.delegate.keys;
            return comparator.compare(keys[entryIndexes[i]], keys[entryIndexes[j]]);
        });
        return entryIndexes;
    }

    protected int[] sortIterationOrder(final int[] entryIndexes, final IntCharComparator comparator) {
        QuickSort.sort(entryIndexes, new IntBinaryOperator(){
            final int[] keys;
            final char[] values;
            {
                this.keys = SortedIterationIntCharHashMap.this.delegate.keys;
                this.values = SortedIterationIntCharHashMap.this.delegate.values;
            }

            @Override
            public int applyAsInt(int i, int j) {
                int index1 = entryIndexes[i];
                int index2 = entryIndexes[j];
                return comparator.compare(this.keys[index1], this.values[index1], this.keys[index2], this.values[index2]);
            }
        });
        return entryIndexes;
    }

    @Override
    public Iterator<IntCharCursor> iterator() {
        assert (this.checkUnmodified());
        return new EntryIterator();
    }

    @Override
    public boolean containsKey(int key2) {
        return this.delegate.containsKey(key2);
    }

    @Override
    public int size() {
        assert (this.checkUnmodified());
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int removeAll(IntContainer container) {
        throw SortedIterationIntCharHashMap.readOnlyException();
    }

    @Override
    public int removeAll(IntPredicate predicate) {
        throw SortedIterationIntCharHashMap.readOnlyException();
    }

    @Override
    public int removeAll(IntCharPredicate predicate) {
        throw SortedIterationIntCharHashMap.readOnlyException();
    }

    @Override
    public <T extends IntCharProcedure> T forEach(T procedure) {
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        int[] keys = this.delegate.keys;
        char[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            int slot = iterationOrder[i];
            procedure.apply(keys[slot], values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends IntCharPredicate> T forEach(T predicate) {
        int slot;
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        int[] keys = this.delegate.keys;
        char[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size && predicate.apply(keys[slot = iterationOrder[i]], values[slot]); ++i) {
        }
        return predicate;
    }

    @Override
    public IntCollection keys() {
        assert (this.checkUnmodified());
        return new KeysContainer();
    }

    @Override
    public CharContainer values() {
        assert (this.checkUnmodified());
        return new ValuesContainer();
    }

    @Override
    public char get(int key2) {
        return this.delegate.get(key2);
    }

    @Override
    public char getOrDefault(int key2, char defaultValue) {
        return this.delegate.getOrDefault(key2, defaultValue);
    }

    @Override
    public char put(int key2, char value) {
        throw SortedIterationIntCharHashMap.readOnlyException();
    }

    @Override
    public int putAll(IntCharAssociativeContainer container) {
        throw SortedIterationIntCharHashMap.readOnlyException();
    }

    @Override
    public int putAll(Iterable<? extends IntCharCursor> iterable) {
        throw SortedIterationIntCharHashMap.readOnlyException();
    }

    @Override
    public char putOrAdd(int key2, char putValue, char incrementValue) {
        throw SortedIterationIntCharHashMap.readOnlyException();
    }

    @Override
    public char addTo(int key2, char additionValue) {
        throw SortedIterationIntCharHashMap.readOnlyException();
    }

    @Override
    public char remove(int key2) {
        throw SortedIterationIntCharHashMap.readOnlyException();
    }

    @Override
    public int indexOf(int key2) {
        return this.delegate.indexOf(key2);
    }

    @Override
    public boolean indexExists(int index) {
        return this.delegate.indexExists(index);
    }

    @Override
    public char indexGet(int index) {
        return this.delegate.indexGet(index);
    }

    @Override
    public char indexReplace(int index, char newValue) {
        throw SortedIterationIntCharHashMap.readOnlyException();
    }

    @Override
    public void indexInsert(int index, int key2, char value) {
        throw SortedIterationIntCharHashMap.readOnlyException();
    }

    @Override
    public char indexRemove(int index) {
        throw SortedIterationIntCharHashMap.readOnlyException();
    }

    @Override
    public void clear() {
        throw SortedIterationIntCharHashMap.readOnlyException();
    }

    @Override
    public void release() {
        throw SortedIterationIntCharHashMap.readOnlyException();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return this.delegate.visualizeKeyDistribution(characters);
    }

    private static RuntimeException readOnlyException() {
        throw new UnsupportedOperationException("Read-only view cannot be modified");
    }

    private boolean checkUnmodified() {
        assert (this.delegate.size() == this.iterationOrder.length) : "The delegate map changed; this is not supported by this read-only view";
        return true;
    }

    private final class EntryIterator
    extends AbstractIterator<IntCharCursor> {
        private final IntCharCursor cursor = new IntCharCursor();
        private int index;

        private EntryIterator() {
        }

        @Override
        protected IntCharCursor fetch() {
            if (this.index < SortedIterationIntCharHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationIntCharHashMap.this.iterationOrder[this.index++];
                this.cursor.key = SortedIterationIntCharHashMap.this.delegate.keys[slot];
                this.cursor.value = SortedIterationIntCharHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (IntCharCursor)this.done();
        }
    }

    private final class KeysContainer
    extends AbstractIntCollection
    implements IntLookupContainer {
        private final SortedIterationIntCharHashMap owner;

        private KeysContainer() {
            this.owner = SortedIterationIntCharHashMap.this;
        }

        @Override
        public boolean contains(int e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends IntProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(k));
            return procedure;
        }

        @Override
        public <T extends IntPredicate> T forEach(T predicate) {
            this.owner.forEach((key2, value) -> predicate.apply(key2));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<IntCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            throw SortedIterationIntCharHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationIntCharHashMap.readOnlyException();
        }

        @Override
        public int removeAll(IntPredicate predicate) {
            throw SortedIterationIntCharHashMap.readOnlyException();
        }

        @Override
        public int removeAll(int e) {
            throw SortedIterationIntCharHashMap.readOnlyException();
        }
    }

    private final class ValuesContainer
    extends AbstractCharCollection {
        private final SortedIterationIntCharHashMap owner;

        private ValuesContainer() {
            this.owner = SortedIterationIntCharHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(char value) {
            for (IntCharCursor c : this.owner) {
                if (value != c.value) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends CharProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(v));
            return procedure;
        }

        @Override
        public <T extends CharPredicate> T forEach(T predicate) {
            this.owner.forEach((k, v) -> predicate.apply(v));
            return predicate;
        }

        @Override
        public Iterator<CharCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(char e) {
            throw SortedIterationIntCharHashMap.readOnlyException();
        }

        @Override
        public int removeAll(CharPredicate predicate) {
            throw SortedIterationIntCharHashMap.readOnlyException();
        }

        @Override
        public void clear() {
            throw SortedIterationIntCharHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationIntCharHashMap.readOnlyException();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<CharCursor> {
        private final CharCursor cursor = new CharCursor();
        private int index;

        private ValuesIterator() {
        }

        @Override
        protected CharCursor fetch() {
            if (this.index < SortedIterationIntCharHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationIntCharHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationIntCharHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (CharCursor)this.done();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor = new IntCursor();
        private int index;

        private KeysIterator() {
        }

        @Override
        protected IntCursor fetch() {
            if (this.index < SortedIterationIntCharHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationIntCharHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationIntCharHashMap.this.delegate.keys[slot];
                return this.cursor;
            }
            return (IntCursor)this.done();
        }
    }
}

