/*
 * Decompiled with CFR 0.152.
 */
package morfologik.fsa;

import morfologik.fsa.FSA;
import morfologik.fsa.FSAFlags;
import morfologik.fsa.MatchResult;

public final class FSATraversal {
    private final FSA fsa;

    public FSATraversal(FSA fsa) {
        this.fsa = fsa;
    }

    public int perfectHash(byte[] sequence, int start, int length, int node) {
        assert (this.fsa.getFlags().contains((Object)FSAFlags.NUMBERS)) : "FSA not built with NUMBERS option.";
        assert (length > 0) : "Must be a non-empty sequence.";
        int hash2 = 0;
        int end = start + length - 1;
        int seqIndex = start;
        byte label = sequence[seqIndex];
        int arc = this.fsa.getFirstArc(node);
        while (arc != 0) {
            if (this.fsa.getArcLabel(arc) == label) {
                if (this.fsa.isArcFinal(arc)) {
                    if (seqIndex == end) {
                        return hash2;
                    }
                    ++hash2;
                }
                if (this.fsa.isArcTerminal(arc)) {
                    return -3;
                }
                if (seqIndex == end) {
                    return -4;
                }
                arc = this.fsa.getFirstArc(this.fsa.getEndNode(arc));
                label = sequence[++seqIndex];
                continue;
            }
            if (this.fsa.isArcFinal(arc)) {
                ++hash2;
            }
            if (!this.fsa.isArcTerminal(arc)) {
                hash2 += this.fsa.getRightLanguageCount(this.fsa.getEndNode(arc));
            }
            arc = this.fsa.getNextArc(arc);
        }
        if (seqIndex > start) {
            return -3;
        }
        return -1;
    }

    public int perfectHash(byte[] sequence) {
        return this.perfectHash(sequence, 0, sequence.length, this.fsa.getRootNode());
    }

    public MatchResult match(MatchResult reuse, byte[] sequence, int start, int length, int node) {
        if (node == 0) {
            reuse.reset(-1, start, node);
            return reuse;
        }
        FSA fsa = this.fsa;
        int end = start + length;
        for (int i = start; i < end; ++i) {
            int arc = fsa.getArc(node, sequence[i]);
            if (arc != 0) {
                if (i + 1 == end && fsa.isArcFinal(arc)) {
                    reuse.reset(0, i, node);
                    return reuse;
                }
                if (fsa.isArcTerminal(arc)) {
                    reuse.reset(-3, i + 1, node);
                    return reuse;
                }
            } else {
                if (i > start) {
                    reuse.reset(-3, i, node);
                } else {
                    reuse.reset(-1, i, node);
                }
                return reuse;
            }
            node = fsa.getEndNode(arc);
        }
        reuse.reset(-4, 0, node);
        return reuse;
    }

    public MatchResult match(byte[] sequence, int start, int length, int node) {
        return this.match(new MatchResult(), sequence, start, length, node);
    }

    public MatchResult match(byte[] sequence, int node) {
        return this.match(sequence, 0, sequence.length, node);
    }

    public MatchResult match(byte[] sequence) {
        return this.match(sequence, this.fsa.getRootNode());
    }
}

