/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.rules.RemoteRuleConfig;
import org.languagetool.rules.RemoteRuleFilters;
import org.languagetool.rules.RemoteRuleResult;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.SuggestedReplacement;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.tools.CircuitBreakers;
import org.languagetool.tools.LtThreadPoolFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class RemoteRule
extends Rule {
    private static final Logger logger = LoggerFactory.getLogger(RemoteRule.class);
    protected static final List<Runnable> shutdownRoutines = new LinkedList<Runnable>();
    protected static final ConcurrentMap<String, CircuitBreaker> circuitBreakers = new ConcurrentHashMap<String, CircuitBreaker>();
    protected final RemoteRuleConfig serviceConfiguration;
    protected final boolean premium;
    protected final boolean inputLogging;
    protected final boolean filterMatches;
    protected final boolean fixOffsets;
    protected final boolean whitespaceNormalisation;
    protected final Language ruleLanguage;
    protected final JLanguageTool lt;
    protected final Pattern suppressMisspelledMatch;
    protected final Pattern suppressMisspelledSuggestions;

    public RemoteRule(Language language, ResourceBundle messages, RemoteRuleConfig config, boolean inputLogging, @Nullable String ruleId) {
        super(messages);
        this.serviceConfiguration = config;
        this.ruleLanguage = language;
        this.lt = new JLanguageTool(this.ruleLanguage);
        this.inputLogging = inputLogging;
        if (ruleId == null) {
            ruleId = this.getId();
        }
        this.filterMatches = Boolean.parseBoolean(this.serviceConfiguration.getOptions().getOrDefault("filterMatches", "false"));
        this.whitespaceNormalisation = Boolean.parseBoolean(this.serviceConfiguration.getOptions().getOrDefault("whitespaceNormalisation", "true"));
        this.fixOffsets = Boolean.parseBoolean(this.serviceConfiguration.getOptions().getOrDefault("fixOffsets", "true"));
        this.premium = Boolean.parseBoolean(this.serviceConfiguration.getOptions().getOrDefault("premium", "false"));
        try {
            this.suppressMisspelledMatch = this.serviceConfiguration.getOptions().containsKey("suppressMisspelledMatch") ? Pattern.compile(this.serviceConfiguration.getOptions().get("suppressMisspelledMatch")) : null;
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("suppressMisspelledMatch must be a valid regex", e);
        }
        try {
            this.suppressMisspelledSuggestions = this.serviceConfiguration.getOptions().containsKey("suppressMisspelledSuggestions") ? Pattern.compile(this.serviceConfiguration.getOptions().get("suppressMisspelledSuggestions")) : null;
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("suppressMisspelledSuggestions must be a valid regex", e);
        }
    }

    public RemoteRule(Language language, ResourceBundle messages, RemoteRuleConfig config, boolean inputLogging) {
        this(language, messages, config, inputLogging, null);
    }

    public static void shutdown() {
        shutdownRoutines.forEach(Runnable::run);
    }

    public FutureTask<RemoteRuleResult> run(List<AnalyzedSentence> sentences2) {
        return this.run(sentences2, null);
    }

    protected abstract RemoteRequest prepareRequest(List<AnalyzedSentence> var1, @Nullable Long var2);

    protected abstract Callable<RemoteRuleResult> executeRequest(RemoteRequest var1, long var2) throws TimeoutException;

    protected abstract RemoteRuleResult fallbackResults(RemoteRequest var1);

    protected CircuitBreaker createCircuitBreaker(String id) {
        CircuitBreakerConfig config = RemoteRule.getCircuitBreakerConfig(this.serviceConfiguration, id);
        return CircuitBreakers.registry().circuitBreaker("remote-rule-" + id, config);
    }

    @NotNull
    static CircuitBreakerConfig getCircuitBreakerConfig(RemoteRuleConfig c, String id) {
        CircuitBreakerConfig.SlidingWindowType type;
        try {
            type = CircuitBreakerConfig.SlidingWindowType.valueOf((String)c.getSlidingWindowType());
        }
        catch (IllegalArgumentException e) {
            type = CircuitBreakerConfig.SlidingWindowType.COUNT_BASED;
            logger.warn("Couldn't parse slidingWindowType value '{}' for rule '{}', use one of {}; defaulting to '{}'", new Object[]{c.getSlidingWindowType(), id, Arrays.asList(CircuitBreakerConfig.SlidingWindowType.values()), type});
        }
        CircuitBreakerConfig config = CircuitBreakerConfig.custom().failureRateThreshold(c.getFailureRateThreshold()).slidingWindow(c.getSlidingWindowSize(), c.getMinimumNumberOfCalls(), type).waitDurationInOpenState(Duration.ofMillis(Math.max(1L, c.getDownMilliseconds()))).enableAutomaticTransitionFromOpenToHalfOpen().build();
        return config;
    }

    @Override
    public boolean isPremium() {
        return this.premium;
    }

    public FutureTask<RemoteRuleResult> run(List<AnalyzedSentence> sentences2, @Nullable Long textSessionId) {
        if (sentences2.isEmpty()) {
            return new FutureTask<RemoteRuleResult>(() -> new RemoteRuleResult(false, true, Collections.emptyList(), sentences2));
        }
        Map context = MDC.getCopyOfContextMap();
        return new FutureTask<RemoteRuleResult>(() -> {
            List<RuleMatch> filteredSentenceMatches;
            List<RuleMatch> sentenceMatches;
            ArrayList<RuleMatch> filteredMatches;
            MDC.clear();
            if (context != null) {
                MDC.setContextMap((Map)context);
            }
            long characters = sentences2.stream().mapToInt(sentence -> sentence.getText().length()).sum();
            long timeout = this.getTimeout(characters);
            RemoteRequest req = this.prepareRequest(sentences2, textSessionId);
            RemoteRuleResult result2 = this.executeRequest(req, timeout).call();
            if (this.fixOffsets) {
                for (AnalyzedSentence sentence2 : sentences2) {
                    List<RuleMatch> toFix = result2.matchesForSentence(sentence2);
                    if (toFix == null) continue;
                    RemoteRule.fixMatchOffsets(sentence2, toFix);
                }
            }
            if (this.filterMatches) {
                filteredMatches = new ArrayList<RuleMatch>();
                for (AnalyzedSentence sentence3 : sentences2) {
                    sentenceMatches = result2.matchesForSentence(sentence3);
                    if (sentenceMatches == null) continue;
                    filteredSentenceMatches = RemoteRuleFilters.filterMatches(this.ruleLanguage, sentence3, sentenceMatches);
                    filteredMatches.addAll(filteredSentenceMatches);
                }
                result2 = new RemoteRuleResult(result2.isRemote(), result2.isSuccess(), filteredMatches, sentences2);
            }
            filteredMatches = new ArrayList();
            for (AnalyzedSentence sentence3 : sentences2) {
                sentenceMatches = result2.matchesForSentence(sentence3);
                if (sentenceMatches == null) continue;
                filteredSentenceMatches = this.suppressMisspelled(sentenceMatches);
                filteredMatches.addAll(filteredSentenceMatches);
            }
            result2 = new RemoteRuleResult(result2.isRemote(), result2.isSuccess(), filteredMatches, sentences2);
            return result2;
        });
    }

    static long getTimeout(RemoteRuleConfig serviceConfiguration, long characters) {
        long timeout = serviceConfiguration.getBaseTimeoutMilliseconds() + (long)Math.round((float)characters * serviceConfiguration.getTimeoutPerCharacterMilliseconds());
        return timeout;
    }

    public long getTimeout(long characters) {
        return RemoteRule.getTimeout(this.serviceConfiguration, characters);
    }

    public CircuitBreaker circuitBreaker() {
        return circuitBreakers.computeIfAbsent(this.getId(), this::createCircuitBreaker);
    }

    private List<RuleMatch> suppressMisspelled(List<RuleMatch> sentenceMatches) {
        ArrayList<RuleMatch> result2 = new ArrayList<RuleMatch>();
        SpellingCheckRule speller = this.ruleLanguage.getDefaultSpellingRule();
        if (speller == null) {
            if (this.suppressMisspelledMatch != null || this.suppressMisspelledSuggestions != null) {
                logger.warn("Cannot activate suppression of misspelled matches for rule {}, no spelling rule found for language {}.", (Object)this.getId(), (Object)this.ruleLanguage.getShortCodeWithCountryAndVariant());
            }
            return sentenceMatches;
        }
        Predicate<SuggestedReplacement> checkSpelling = s -> {
            try {
                AnalyzedSentence sentence = this.lt.getRawAnalyzedSentence(s.getReplacement());
                RuleMatch[] matches = speller.match(sentence);
                return matches.length == 0;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        for (RuleMatch m : sentenceMatches) {
            String id = m.getRule().getId();
            if (this.suppressMisspelledMatch != null && this.suppressMisspelledMatch.matcher(id).matches() && !m.getSuggestedReplacementObjects().stream().allMatch(checkSpelling)) continue;
            if (this.suppressMisspelledSuggestions != null && this.suppressMisspelledSuggestions.matcher(id).matches()) {
                List<SuggestedReplacement> suggestedReplacements = m.getSuggestedReplacementObjects().stream().filter(checkSpelling).collect(Collectors.toList());
                if (suggestedReplacements.isEmpty()) continue;
                m.setSuggestedReplacementObjects(suggestedReplacements);
            }
            result2.add(m);
        }
        return result2;
    }

    @Override
    public String getId() {
        return this.serviceConfiguration.getRuleId();
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        FutureTask<RemoteRuleResult> task = this.run(Collections.singletonList(sentence));
        Optional<ThreadPoolExecutor> executor = LtThreadPoolFactory.getFixedThreadPoolExecutor("remote-rule-executing-thread");
        try {
            long timeout = this.getTimeout(sentence.getText().length());
            if (executor.isPresent()) {
                executor.get().submit(task);
            } else {
                task.run();
            }
            RemoteRuleResult result2 = task.get(timeout, TimeUnit.MILLISECONDS);
            return result2.getMatches().toArray(RuleMatch.EMPTY_ARRAY);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            logger.info("Fetching results for remote rule " + this.getId() + " failed.", (Throwable)e);
            return RuleMatch.EMPTY_ARRAY;
        }
    }

    public RemoteRuleConfig getServiceConfiguration() {
        return this.serviceConfiguration;
    }

    static int[] computeOffsetShifts(String s) {
        int len = s.length() + 1;
        int[] offsets = new int[len];
        int shifted = 0;
        int original = 0;
        while (shifted < s.length()) {
            offsets[original] = shifted;
            shifted = s.offsetByCodePoints(shifted, 1);
            ++original;
        }
        if (original < len) {
            offsets[original] = shifted;
        }
        for (int i = original + 1; i < len; ++i) {
            offsets[i] = offsets[i - 1] + 1;
        }
        return offsets;
    }

    public static void fixMatchOffsets(AnalyzedSentence sentence, List<RuleMatch> matches) {
        int[] shifts = RemoteRule.computeOffsetShifts(sentence.getText());
        matches.forEach(m -> {
            int from = shifts[m.getFromPos()];
            int to = shifts[m.getToPos()];
            m.setOffsetPosition(from, to);
        });
    }

    protected static class RemoteRequest {
        protected RemoteRequest() {
        }
    }
}

